/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.modules.php.api.PhpOptions;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.atoum.commands.Bundle;
import org.netbeans.modules.php.atoum.options.AtoumOptions;
import org.netbeans.modules.php.atoum.options.AtoumOptionsValidator;
import org.netbeans.modules.php.atoum.preferences.AtoumPreferences;
import org.netbeans.modules.php.atoum.preferences.AtoumPreferencesValidator;
import org.netbeans.modules.php.atoum.run.TapParser;
import org.netbeans.modules.php.atoum.run.TestCaseVo;
import org.netbeans.modules.php.atoum.run.TestSuiteVo;
import org.netbeans.modules.php.atoum.ui.customizer.AtoumCustomizer;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.run.TestCase;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.netbeans.modules.php.spi.testing.run.TestSuite;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public final class Atoum {
    private static final Logger LOGGER = Logger.getLogger(Atoum.class.getName());
    public static final String PHAR_FILE_NAME = "mageekguy.atoum.phar";
    public static final String ATOUM_FILE_NAME = "atoum";
    public static final String BOOTSTRAP_FILE_NAME = ".bootstrap.atoum.php";
    public static final String CONFIGURATION_FILE_NAME = ".atoum.php";
    private static final String COVERAGE_SCRIPT_RELATIVE_PATH = "scripts/coverage.php";
    public static final Pattern LINE_PATTERN = Pattern.compile("(.+):(\\d+)");
    private static final String TAP_FORMAT_PARAM = "-utr";
    private static final String DIRECTORY_PARAM = "-d";
    private static final String FILE_PARAM = "-f";
    private static final String FILTER_PARAM = "-m";
    private static final String BOOTSTRAP_PARAM = "-bf";
    private static final String CONFIGURATION_PARAM = "-c";
    private static final String INIT_PARAM = "--init";
    private static final String XDEBUG_CONFIG_PARAM = "-xc";
    private static final String IDE_KEY_PARAM = "idekey=%s";
    private static final String OUTPUT_PARAM = "--output";
    private static final String USE_PARAM = "--use";
    private static final String COVERAGE_PARAM = "coverage";
    private static final File COVERAGE_LOG;
    private final String atoumPath;

    private Atoum(String atoum) {
        assert (atoum != null);
        this.atoumPath = atoum;
    }

    public static Atoum getDefault() throws InvalidPhpExecutableException {
        String error = Atoum.validateDefault();
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new Atoum(AtoumOptions.getInstance().getAtoumPath());
    }

    @CheckForNull
    public static Atoum getForPhpModule(PhpModule phpModule, boolean showCustomizer) {
        String path;
        if (Atoum.validatePhpModule(phpModule) != null) {
            if (showCustomizer) {
                UiUtils.invalidScriptProvided((PhpModule)phpModule, (String)AtoumCustomizer.IDENTIFIER, null);
            }
            return null;
        }
        if (AtoumPreferences.isAtoumEnabled(phpModule)) {
            path = AtoumPreferences.getAtoumPath(phpModule);
        } else {
            String error = Atoum.validateDefault();
            if (error != null) {
                if (showCustomizer) {
                    UiUtils.invalidScriptProvided((String)error, (String)"FrameworksAndTools/atoum");
                }
                return null;
            }
            path = AtoumOptions.getInstance().getAtoumPath();
        }
        return new Atoum(path);
    }

    @CheckForNull
    private static String validateDefault() {
        ValidationResult result = new AtoumOptionsValidator().validate(AtoumOptions.getInstance().getAtoumPath()).getResult();
        return Atoum.validateResult(result);
    }

    @CheckForNull
    private static String validatePhpModule(PhpModule phpModule) {
        ValidationResult result = new AtoumPreferencesValidator().validate(phpModule).getResult();
        return Atoum.validateResult(result);
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
    }

    public static boolean isTestMethod(PhpType.Method method) {
        return method.getName().startsWith("test");
    }

    @CheckForNull
    public static File getDefaultBootstrap(PhpModule phpModule) {
        FileObject testDirectory = phpModule.getTestDirectory(null);
        if (testDirectory == null) {
            return null;
        }
        File testDir = FileUtil.toFile((FileObject)testDirectory);
        assert (testDir != null) : testDirectory;
        return new File(testDir, BOOTSTRAP_FILE_NAME);
    }

    @CheckForNull
    public static File getDefaultConfiguration(PhpModule phpModule) {
        FileObject testDirectory = phpModule.getTestDirectory(null);
        if (testDirectory == null) {
            return null;
        }
        File testDir = FileUtil.toFile((FileObject)testDirectory);
        assert (testDir != null) : testDirectory;
        return new File(testDir, CONFIGURATION_FILE_NAME);
    }

    @CheckForNull
    public File getCoverageLog() {
        if (COVERAGE_LOG.isFile()) {
            return COVERAGE_LOG;
        }
        return null;
    }

    @CheckForNull
    public Integer runTests(PhpModule phpModule, TestRunInfo runInfo, TestSession testSession) throws TestRunException {
        List customTests;
        boolean coverageEnabled = runInfo.isCoverageEnabled();
        String command = this.atoumPath;
        boolean phar = this.atoumPath.toLowerCase().contains(".phar");
        if (coverageEnabled && !phar) {
            File atoumDir = new File(this.atoumPath).getParentFile().getParentFile();
            if (!ATOUM_FILE_NAME.equals(atoumDir.getName())) {
                atoumDir = new File(atoumDir, "atoum/atoum");
            }
            command = new File(atoumDir, COVERAGE_SCRIPT_RELATIVE_PATH).getAbsolutePath();
            assert (new File(command).isFile()) : "Coverage script should exist: " + command;
        }
        PhpExecutable atoum = this.getExecutable(command, phpModule);
        ArrayList<String> params = new ArrayList<String>();
        if (coverageEnabled) {
            if (phar) {
                params.add(USE_PARAM);
                params.add(COVERAGE_PARAM);
            }
            params.add(OUTPUT_PARAM);
            params.add(COVERAGE_LOG.getAbsolutePath());
        }
        if (!(customTests = runInfo.getCustomTests()).isEmpty()) {
            StringBuilder buffer = new StringBuilder(200);
            for (TestRunInfo.TestInfo test : customTests) {
                if (buffer.length() > 1) {
                    buffer.append(" ");
                }
                String className = test.getClassName();
                assert (className != null) : "No classname for test: " + test.getName();
                buffer.append(this.sanitizeClassName(className));
                buffer.append("::");
                buffer.append(test.getName());
            }
            params.add(FILTER_PARAM);
            params.add(buffer.toString());
        }
        if (runInfo.getSessionType() == TestRunInfo.SessionType.DEBUG) {
            params.add(XDEBUG_CONFIG_PARAM);
            params.add(String.format(IDE_KEY_PARAM, ((PhpOptions)Lookup.getDefault().lookup(PhpOptions.class)).getDebuggerSessionId()));
        }
        this.addStartFile(runInfo, params);
        params.add(TAP_FORMAT_PARAM);
        this.addBootstrap(phpModule, params);
        this.addConfiguration(phpModule, params);
        atoum.additionalParameters(params);
        if (coverageEnabled && COVERAGE_LOG.isFile() && !COVERAGE_LOG.delete()) {
            LOGGER.info("Cannot delete atoum coverage log file");
        }
        try {
            if (runInfo.getSessionType() == TestRunInfo.SessionType.TEST) {
                return atoum.runAndWait(this.getDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)new ParsingFactory(testSession), "Running atoum tests...");
            }
            List startFiles = runInfo.getStartFiles();
            assert (startFiles.size() == 1) : "Exactly one file expected for debugging but got " + startFiles;
            return atoum.debug((FileObject)startFiles.get(0), this.getDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)new ParsingFactory(testSession));
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINE, "Test running cancelled", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            if (AtoumPreferences.isAtoumEnabled(phpModule)) {
                UiUtils.processExecutionException((ExecutionException)ex, (PhpModule)phpModule, (String)AtoumCustomizer.IDENTIFIER);
            } else {
                UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/atoum");
            }
            throw new TestRunException((Throwable)ex);
        }
        return null;
    }

    @CheckForNull
    public Pair<File, File> init(PhpModule phpModule) {
        PhpExecutable atoum = this.getExecutable(phpModule);
        ArrayList<String> params = new ArrayList<String>();
        this.addBootstrap(phpModule, params);
        this.addConfiguration(phpModule, params);
        params.add(INIT_PARAM);
        atoum.additionalParameters(params);
        try {
            Integer result = atoum.runAndWait(this.getDescriptor().inputVisible(true), "Running atoum init...");
            if (result == null || result != 0) {
                return null;
            }
            return Pair.of((Object)Atoum.getDefaultBootstrap(phpModule), (Object)Atoum.getDefaultConfiguration(phpModule));
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINE, "Init cancelled", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/atoum");
        }
        return null;
    }

    private PhpExecutable getExecutable(PhpModule phpModule) {
        return this.getExecutable(this.atoumPath, phpModule);
    }

    private PhpExecutable getExecutable(String command, PhpModule phpModule) {
        FileObject testDirectory = phpModule.getTestDirectory(null);
        assert (testDirectory != null) : "Test directory not found for " + phpModule.getName();
        return new PhpExecutable(command).optionsSubcategory("FrameworksAndTools/atoum").workDir(FileUtil.toFile((FileObject)testDirectory)).redirectErrorStream(true).noDebugConfig(true).displayName(Bundle.Atoum_run_title(phpModule.getDisplayName()));
    }

    private ExecutionDescriptor getDescriptor() {
        return new ExecutionDescriptor().optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/atoum").showProgress(true).outLineBased(true).errLineBased(true);
    }

    private String sanitizeClassName(String className) {
        if (className.startsWith("\\")) {
            return className.substring(1);
        }
        return className;
    }

    private void addBootstrap(PhpModule phpModule, List<String> params) {
        if (AtoumPreferences.isBootstrapEnabled(phpModule)) {
            params.add(BOOTSTRAP_PARAM);
            params.add(AtoumPreferences.getBootstrapPath(phpModule));
        }
    }

    private void addConfiguration(PhpModule phpModule, List<String> params) {
        if (AtoumPreferences.isConfigurationEnabled(phpModule)) {
            params.add(CONFIGURATION_PARAM);
            params.add(AtoumPreferences.getConfigurationPath(phpModule));
        }
    }

    private void addStartFile(TestRunInfo runInfo, List<String> params) {
        for (FileObject startFile : runInfo.getStartFiles()) {
            if (startFile.isData()) {
                params.add(FILE_PARAM);
            } else {
                params.add(DIRECTORY_PARAM);
            }
            params.add(FileUtil.toFile((FileObject)startFile).getAbsolutePath());
        }
    }

    static {
        String logDirName = System.getProperty("java.io.tmpdir");
        COVERAGE_LOG = new File(logDirName, "nb-atoum-coverage.xml");
    }

    private static final class ParsingProcessor
    implements LineProcessor {
        private static final Logger LOGGER = Logger.getLogger(ParsingProcessor.class.getName());
        private final TestSession testSession;
        private final StringBuilder buffer = new StringBuilder();
        private String testSuiteName = null;
        private TestSuite testSuite = null;
        private long currentMillis = ParsingProcessor.currentMillis();
        private long testSuiteTime = 0L;

        public ParsingProcessor(TestSession testSession) {
            assert (testSession != null);
            this.testSession = testSession;
        }

        private static long currentMillis() {
            return System.currentTimeMillis();
        }

        public void processLine(String line) {
            LOGGER.log(Level.FINEST, "Processing line: {0}", line);
            if (TapParser.isTestCaseStart(line)) {
                this.process(this.buffer.toString());
                this.buffer.setLength(0);
            }
            this.buffer.append(line);
            this.buffer.append("\n");
        }

        public void reset() {
            LOGGER.fine("Resetting processor");
            this.finish();
        }

        public void close() {
            LOGGER.fine("Closing processor");
            this.finish();
        }

        private void finish() {
            this.process(this.buffer.toString());
            if (this.testSuite != null) {
                LOGGER.log(Level.FINE, "Test suite {0} found, finishing", this.testSuiteName);
                this.testSuite.finish(this.testSuiteTime);
                this.testSuite = null;
            }
        }

        private void process(String input) {
            LOGGER.log(Level.FINEST, "Parsing input:\n{0}", input);
            List<TestSuiteVo> suites = new TapParser().parse(input, ParsingProcessor.currentMillis() - this.currentMillis);
            LOGGER.log(Level.FINE, "Parsed test suites: {0}", suites);
            try {
                this.process(suites);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, null, throwable);
            }
            this.currentMillis = ParsingProcessor.currentMillis();
        }

        private void process(List<TestSuiteVo> suites) {
            for (TestSuiteVo suite : suites) {
                String name = suite.getName();
                if (this.testSuiteName == null || !this.testSuiteName.equals(name)) {
                    if (this.testSuite != null) {
                        LOGGER.log(Level.FINE, "Finishing the current suite {0}", this.testSuiteName);
                        this.testSuite.finish(this.testSuiteTime);
                        this.testSuiteTime = 0L;
                    }
                    this.testSuiteName = name;
                    LOGGER.log(Level.FINE, "Adding new test suite {0}", name);
                    this.testSuite = this.testSession.addTestSuite(name, this.getFileObject(suite.getFile()));
                }
                this.addTestCases(suite.getTestCases());
            }
        }

        private FileObject getFileObject(String path) {
            if (path == null) {
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)new File(path));
            assert (fileObject != null) : "Cannot find file object for: " + path;
            return fileObject;
        }

        private void addTestCases(List<TestCaseVo> testCases) {
            for (TestCaseVo kase : testCases) {
                String name = kase.getName();
                LOGGER.log(Level.FINE, "Adding new test case {0}", name);
                TestCase testCase = this.testSuite.addTestCase(name, Atoum.ATOUM_FILE_NAME);
                try {
                    this.map(kase, testCase);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, null, throwable);
                }
                this.testSuiteTime += kase.getTime();
            }
        }

        private void map(TestCaseVo kase, TestCase testCase) {
            testCase.setClassName(this.testSuiteName);
            testCase.setStatus(kase.getStatus());
            this.mapLocation(kase, testCase);
            this.mapFailureInfo(kase, testCase);
            testCase.setTime(kase.getTime());
        }

        private void mapLocation(TestCaseVo kase, TestCase testCase) {
            String file = kase.getFile();
            if (file == null) {
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)new File(file));
            assert (fileObject != null) : "Cannot find file object for file: " + file;
            testCase.setLocation(new Locations.Line(fileObject, kase.getLine()));
        }

        private void mapFailureInfo(TestCaseVo kase, TestCase testCase) {
            TestCase.Diff diff;
            List<String> stackTrace;
            if (this.isPass(kase.getStatus())) {
                assert (kase.getMessage() == null) : kase.getMessage();
                assert (kase.getDiff() == null) : kase.getDiff();
                return;
            }
            String message = kase.getMessage();
            if (!StringUtils.hasText((String)message)) {
                message = Bundle.ParsingProcessor_message_no();
            }
            if ((stackTrace = kase.getStackTrace()) == null) {
                stackTrace = Collections.emptyList();
            }
            if ((diff = kase.getDiff()) == null) {
                diff = TestCase.Diff.NOT_KNOWN;
            }
            testCase.setFailureInfo(message, stackTrace.toArray(new String[stackTrace.size()]), this.isError(kase.getStatus()), diff);
        }

        private boolean isPass(TestCase.Status status) {
            return status == TestCase.Status.PASSED;
        }

        private boolean isError(TestCase.Status status) {
            return status == TestCase.Status.ERROR;
        }
    }

    private static final class ParsingFactory
    implements ExecutionDescriptor.InputProcessorFactory2 {
        private final TestSession testSession;

        private ParsingFactory(TestSession testSession) {
            assert (testSession != null);
            this.testSession = testSession;
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new ParsingProcessor(this.testSession));
        }
    }
}

