/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.text.MessageFormat;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public final class PreferredProjectPlatform {
    private static final String PREFERRED_PLATFORM = "preferred.platform.{0}";
    private static final String PLATFORM_ANT_NAME = "platform.ant.name";

    private PreferredProjectPlatform() {
        throw new AssertionError();
    }

    @CheckForNull
    public static JavaPlatform getPreferredPlatform(@NonNull String platformType) {
        JavaPlatform defaultPlatform;
        Parameters.notNull((CharSequence)"platformType", (Object)platformType);
        String platformId = NbPreferences.forModule(PreferredProjectPlatform.class).get(MessageFormat.format(PREFERRED_PLATFORM, platformType), null);
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        if (platformId != null) {
            for (JavaPlatform jp : jpm.getInstalledPlatforms()) {
                if (!platformId.equals(jp.getProperties().get(PLATFORM_ANT_NAME)) || !platformType.equals(jp.getSpecification().getName()) || !jp.isValid()) continue;
                return jp;
            }
        }
        return platformType.equals((defaultPlatform = jpm.getDefaultPlatform()).getSpecification().getName()) ? defaultPlatform : null;
    }

    public static void setPreferredPlatform(@NonNull JavaPlatform platform) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        String platformId = (String)platform.getProperties().get(PLATFORM_ANT_NAME);
        if (platformId == null) {
            throw new IllegalArgumentException("Invalid platform, the platform has no platform.ant.name");
        }
        String platformType = platform.getSpecification().getName();
        NbPreferences.forModule(PreferredProjectPlatform.class).put(MessageFormat.format(PREFERRED_PLATFORM, platformType), platformId);
    }
}

