/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.search.request.Field;

public final class Record {
    private final String backendId;
    private final String repositoryId;
    private final String uid;
    private final Long lastUpdated;
    private final Map<Field, Object> fields;

    public Record(String backendId, String repositoryId, String uid, Long lastUpdated, Map<Field, Object> fields) {
        this.backendId = Objects.requireNonNull(backendId);
        this.repositoryId = Objects.requireNonNull(repositoryId);
        this.uid = uid;
        this.lastUpdated = lastUpdated;
        this.fields = Collections.unmodifiableMap(fields);
    }

    public String getBackendId() {
        return this.backendId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getUid() {
        return this.uid;
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public Map<Field, Object> getFields() {
        return this.fields;
    }

    public Set<Field> fieldSet() {
        return this.fields.keySet();
    }

    public boolean hasField(Field field) {
        return this.fields.containsKey(field);
    }

    public String getValue(Field.StringField field) {
        return field.getFieldValue((Map)this.fields);
    }

    public Number getValue(Field.NumberField field) {
        return field.getFieldValue((Map)this.fields);
    }

    public Boolean getValue(Field.BooleanField field) {
        return field.getFieldValue((Map)this.fields);
    }
}

