/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.ide.spi;

import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;

public abstract class IDEProject {
    private final String displayName;
    private final Icon icon;
    private final URL url;
    private final List<DeleteListener> deleteListeners = new CopyOnWriteArrayList<DeleteListener>();

    protected IDEProject(String displayName, Icon icon, URL url) {
        this.displayName = displayName;
        this.icon = icon;
        this.url = url;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public URL getURL() {
        return this.url;
    }

    public synchronized boolean addDeleteListener(DeleteListener l) {
        if (this.deleteListeners.contains(l)) {
            return false;
        }
        this.deleteListeners.add(l);
        return true;
    }

    public boolean removeDeleteListener(DeleteListener l) {
        return this.deleteListeners.remove(l);
    }

    protected final List<DeleteListener> getDeleteListeners() {
        return this.deleteListeners;
    }

    public final void notifyDeleted() {
        for (DeleteListener dl : this.deleteListeners) {
            dl.projectDeleted(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IDEProject other = (IDEProject)obj;
        return this.url == other.url || this.url != null && this.url.equals(other.url);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    public static interface DeleteListener {
        public void projectDeleted(IDEProject var1);
    }

    public static interface OpenListener {
        public void projectsOpened(IDEProject[] var1);
    }
}

