/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.Bundle;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.UpdateDependencyHintCustomizer;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.model.pom.ReportPlugin;
import org.netbeans.modules.maven.model.pom.Reporting;
import org.netbeans.modules.maven.model.pom.VersionablePOMComponent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;

public class UpdateDependencyHint
implements POMErrorFixProvider {
    private static final Configuration config = new Configuration(UpdateDependencyHint.class.getSimpleName(), Bundle.TIT_UpdateDependencyHint(), Bundle.DESC_UpdateDependencyHint(), true, Configuration.HintSeverity.WARNING);
    static final String KEY_NO_MAJOR_UPGRADE = "no_major_upgrade";
    private boolean noMajorUpgrde;
    private UpdateDependencyHintCustomizer customizer;

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        Reporting reporting;
        Build build;
        DependencyManagement depman;
        this.noMajorUpgrde = UpdateDependencyHint.getNoMajorUpgradeOption();
        HashMap<POMComponent, ErrorDescription> hints = new HashMap<POMComponent, ErrorDescription>();
        List deps = model.getProject().getDependencies();
        if (deps != null) {
            this.addHintsTo(deps, hints);
        }
        if ((depman = model.getProject().getDependencyManagement()) != null && depman.getDependencies() != null) {
            this.addHintsTo(depman.getDependencies(), hints);
        }
        if ((build = model.getProject().getBuild()) != null) {
            PluginManagement plugman;
            if (build.getPlugins() != null) {
                this.addHintsTo(build.getPlugins(), hints);
            }
            if ((plugman = build.getPluginManagement()) != null && plugman.getPlugins() != null) {
                this.addHintsTo(plugman.getPlugins(), hints);
            }
        }
        if ((reporting = model.getProject().getReporting()) != null && reporting.getReportPlugins() != null) {
            this.addHintsTo(reporting.getReportPlugins(), hints);
        }
        return new ArrayList<ErrorDescription>(hints.values());
    }

    private void addHintsTo(List<? extends VersionablePOMComponent> components, Map<POMComponent, ErrorDescription> hints) {
        for (VersionablePOMComponent versionablePOMComponent : components) {
            ErrorDescription previous;
            String requiredPrefix;
            String artifactId;
            String groupId = versionablePOMComponent.getGroupId() != null && !versionablePOMComponent.getGroupId().isBlank() ? versionablePOMComponent.getGroupId() : null;
            String string = artifactId = versionablePOMComponent.getArtifactId() != null && !versionablePOMComponent.getArtifactId().isBlank() ? versionablePOMComponent.getArtifactId() : null;
            if (groupId == null && (versionablePOMComponent instanceof Plugin || versionablePOMComponent instanceof ReportPlugin)) {
                groupId = "org.apache.maven.plugins";
            }
            if (artifactId == null || groupId == null) continue;
            boolean property = false;
            String version = versionablePOMComponent.getVersion();
            if (PomModelUtils.isPropertyExpression(version)) {
                version = PomModelUtils.getProperty(versionablePOMComponent.getModel(), version);
                property = true;
            }
            if (version == null) continue;
            boolean allow_qualifier = !UpdateDependencyHint.isNumerical(version);
            boolean allow_timestamp = !this.noTimestamp(version);
            String string2 = requiredPrefix = this.noMajorUpgrde ? this.getMajorComponentPrefix(version) : "";
            Optional<ComparableVersion> latest = RepositoryQueries.getVersionsResult((String)groupId, (String)artifactId, null).getResults().stream().map(NBVersionInfo::getVersion).filter(v -> !v.isEmpty() && v.startsWith(requiredPrefix)).filter(v -> allow_qualifier || !Character.isDigit(v.charAt(0)) || UpdateDependencyHint.isNumerical(v)).filter(v -> allow_timestamp || !Character.isDigit(v.charAt(0)) || this.noTimestamp((String)v)).map(ComparableVersion::new).max(ComparableVersion::compareTo);
            if (!latest.isPresent() || latest.get().compareTo(new ComparableVersion(version)) <= 0) continue;
            POMComponent version_comp = null;
            if (property) {
                Properties props = versionablePOMComponent.getModel().getProject().getProperties();
                if (props != null) {
                    version_comp = PomModelUtils.getFirstChild((POMComponent)props, PomModelUtils.getPropertyName(versionablePOMComponent.getVersion()));
                }
            } else {
                version_comp = PomModelUtils.getFirstChild((POMComponent)versionablePOMComponent, "version");
            }
            if (!(version_comp instanceof POMExtensibilityElement) || (previous = hints.get(version_comp)) != null && UpdateDependencyHint.compare(((UpdateVersionFix)previous.getFixes().getFixes().get((int)0)).version, version) <= 0) continue;
            hints.put(version_comp, this.createHintForComponent((POMExtensibilityElement)version_comp, latest.get().toString()));
        }
    }

    private static boolean isNumerical(String v) {
        for (char c : v.toCharArray()) {
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    private boolean noTimestamp(String v) {
        char[] chars = v.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return i == 0 || Integer.parseInt(v.substring(0, i)) < 10000;
        }
        return v.isEmpty() || Integer.parseInt(v) < 10000;
    }

    private String getMajorComponentPrefix(String v) {
        String major;
        int dot = v.indexOf(46);
        if (dot > 0 && UpdateDependencyHint.isNumerical(major = v.substring(0, dot + 1))) {
            return major;
        }
        return "";
    }

    private static int compare(String version1, String version2) {
        return new ComparableVersion(version1).compareTo(new ComparableVersion(version2));
    }

    private ErrorDescription createHintForComponent(POMExtensibilityElement comp, String version) {
        Document doc = comp.getModel().getBaseDocument();
        int line = NbEditorUtilities.getLine((Document)doc, (int)comp.findPosition(), (boolean)false).getLineNumber() + 1;
        List<UpdateVersionFix> fix = List.of(new UpdateVersionFix(comp, version));
        return ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)(Bundle.HINT_UpdateDependencyHint() + version), fix, (Document)doc, (int)line);
    }

    @Override
    public void cancel() {
        this.customizer = null;
    }

    @Override
    public Configuration getConfiguration() {
        return config;
    }

    private static boolean getNoMajorUpgradeOption() {
        return config.getPreferences().getBoolean(KEY_NO_MAJOR_UPGRADE, false);
    }

    @Override
    public String getSavedValue(JComponent customizer, String key) {
        if (KEY_NO_MAJOR_UPGRADE.equals(key) && customizer instanceof UpdateDependencyHintCustomizer) {
            return Boolean.toString(((UpdateDependencyHintCustomizer)customizer).getSavedNoMajorUpgradeOption());
        }
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences prefsCopy) {
        if (this.customizer == null) {
            this.customizer = new UpdateDependencyHintCustomizer(prefsCopy, UpdateDependencyHint.getNoMajorUpgradeOption());
        }
        return this.customizer;
    }

    private static class UpdateVersionFix
    implements Fix {
        private final POMExtensibilityElement version_comp;
        private final String version;

        private UpdateVersionFix(POMExtensibilityElement component, String toVersion) {
            this.version_comp = component;
            this.version = toVersion;
        }

        public String getText() {
            return Bundle.FIX_UpdateDependencyHint() + this.version;
        }

        public ChangeInfo implement() throws Exception {
            PomModelUtils.implementInTransaction((Model)this.version_comp.getModel(), () -> this.version_comp.setElementText(this.version));
            return new ChangeInfo();
        }
    }
}

