/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.java.JavaException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class Fault
extends ModelObject {
    private String name;
    private Block block;
    private JavaException javaException;
    private Fault parentFault;
    private Set subfaults = new HashSet();
    private QName elementName = null;
    private String javaMemberName = null;

    public Fault() {
    }

    public Fault(String name) {
        this.name = name;
        this.parentFault = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block b) {
        this.block = b;
    }

    public JavaException getJavaException() {
        return this.javaException;
    }

    public void setJavaException(JavaException e) {
        this.javaException = e;
    }

    @Override
    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public Fault getParentFault() {
        return this.parentFault;
    }

    public void setParentFault(Fault parentFault) {
        if (this.parentFault != null && parentFault != null && !this.parentFault.equals(parentFault)) {
            throw new ModelException("model.parent.fault.already.set", new Object[]{this.getName().toString(), this.parentFault.getName().toString(), parentFault.getName().toString()});
        }
        this.parentFault = parentFault;
    }

    public void addSubfault(Fault fault) {
        this.subfaults.add(fault);
        fault.setParentFault(this);
    }

    public Iterator getSubfaults() {
        if (this.subfaults.size() == 0) {
            return null;
        }
        return this.subfaults.iterator();
    }

    public Iterator getSortedSubfaults() {
        TreeSet sortedFaults = new TreeSet(new GeneratorUtil.FaultComparator());
        sortedFaults.addAll(this.subfaults);
        return sortedFaults.iterator();
    }

    public Set getSubfaultsSet() {
        return this.subfaults;
    }

    public void setSubfaultsSet(Set s) {
        this.subfaults = s;
    }

    public Iterator getAllFaults() {
        Set allFaults = this.getAllFaultsSet();
        if (allFaults.size() == 0) {
            return null;
        }
        return allFaults.iterator();
    }

    public Set getAllFaultsSet() {
        HashSet transSet = new HashSet();
        Iterator iter = this.subfaults.iterator();
        while (iter.hasNext()) {
            transSet.addAll(((Fault)iter.next()).getAllFaultsSet());
        }
        transSet.addAll(this.subfaults);
        return transSet;
    }

    public QName getElementName() {
        return this.elementName;
    }

    public void setElementName(QName elementName) {
        this.elementName = elementName;
    }

    public String getJavaMemberName() {
        return this.javaMemberName;
    }

    public void setJavaMemberName(String javaMemberName) {
        this.javaMemberName = javaMemberName;
    }
}

