/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.soap.CollectionSerializerBase;
import com.sun.xml.rpc.encoding.soap.JAXRpcMapEntry;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class MapSerializer
extends CollectionSerializerBase
implements Initializable {
    protected Class mapClass = null;
    protected JAXRPCSerializer elemSer;
    protected JAXRPCDeserializer elemDeser;

    public MapSerializer(QName type, Class mapClass, boolean encodeType, boolean isNullable, String encodingStyle) {
        this(type, mapClass, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public MapSerializer(QName type, Class mapClass, boolean encodeType, boolean isNullable, String encodingStyle, SOAPVersion version) {
        super(type, encodeType, isNullable, encodingStyle, COLLECTION_ELEMENT_NAME, QNAME_TYPE_JAX_RPC_MAP_ENTRY, JAXRpcMapEntry.class, 1, null, version);
        this.mapClass = mapClass;
    }

    @Override
    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.elemSer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.elemClass, this.elemType);
        this.elemDeser = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.elemClass, this.elemType);
    }

    @Override
    protected Object[] convertToArray(Object obj) throws Exception {
        Map mapObj = (Map)obj;
        Set mapEnt_set = mapObj.entrySet();
        Object[] mapEnt_array = mapEnt_set.toArray();
        Object[] JAXRPCMapEntries = new JAXRpcMapEntry[mapEnt_array.length];
        for (int i = 0; i < mapEnt_array.length; ++i) {
            Map.Entry o = (Map.Entry)mapEnt_array[i];
            JAXRpcMapEntry map_entry = new JAXRpcMapEntry(o.getKey(), o.getValue());
            JAXRPCMapEntries[i] = map_entry;
        }
        return JAXRPCMapEntries;
    }

    @Override
    protected void serializeArrayInstance(Object obj, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.serializeArrayElements((Object[])obj, 0, dims, writer, context);
    }

    protected void serializeArrayElements(Object[] arr, int level, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (arr == null || arr.length != dims[level]) {
            throw new SerializationException("soap.irregularMultiDimensionalArray");
        }
        boolean serializeLeaves = level == dims.length - 1;
        for (int i = 0; i < dims[level]; ++i) {
            Object elem = arr[i];
            if (serializeLeaves) {
                this.elemSer.serialize(elem, this.elemName, null, writer, context);
                continue;
            }
            this.serializeArrayElements((Object[])elem, level + 1, dims, writer, context);
        }
    }

    @Override
    protected Object deserializeArrayInstance(XMLReader reader, SOAPDeserializationContext context, int[] dims) throws Exception {
        Map instance = (Map)this.mapClass.newInstance();
        String id = this.getID(reader);
        SOAPDeserializationState state = id != null ? context.getStateFor(id) : null;
        boolean isComplete = true;
        boolean emptyDims = MapSerializer.isEmptyDimensions(dims);
        int[] dimOffsets = MapSerializer.getDimensionOffsets(dims);
        int[] offset = MapSerializer.getArrayOffset(reader, dims);
        if (offset == null) {
            offset = new int[emptyDims ? 1 : dims.length];
        }
        Object[] value = null;
        int maxPosition = 0;
        int length = 0;
        if (reader.nextElementContent() != 2) {
            Object[] newValue;
            boolean isSparseArray;
            int[] position = MapSerializer.getArrayElementPosition(reader, dims);
            boolean bl = isSparseArray = position != null;
            if (!isSparseArray) {
                position = offset;
            }
            if (emptyDims) {
                maxPosition = position[0];
                length = Math.max(maxPosition * 2, 1024);
                value = (Object[])Array.newInstance(this.elemClass, length);
            } else {
                value = (Object[])Array.newInstance(this.elemClass, dims);
            }
            while (true) {
                if (!emptyDims && !MapSerializer.isPositionWithinBounds(position, dims)) {
                    if (isSparseArray) {
                        throw new DeserializationException("soap.outOfBoundsArrayElementPosition", MapSerializer.encodeArrayDimensions(position));
                    }
                    throw new DeserializationException("soap.tooManyArrayElements");
                }
                if (emptyDims && position[0] >= length) {
                    int newLength;
                    for (newLength = length * 2; position[0] >= newLength; newLength *= 2) {
                    }
                    newValue = (Object[])Array.newInstance(this.elemClass, newLength);
                    System.arraycopy(value, 0, newValue, 0, length);
                    value = newValue;
                    length = newLength;
                }
                Object elem = null;
                elem = this.elemDeser.deserialize(this.elemName, reader, context);
                if (elem instanceof SOAPDeserializationState) {
                    SOAPDeserializationState elemState = (SOAPDeserializationState)elem;
                    isComplete = false;
                    if (state == null) {
                        state = new SOAPDeserializationState();
                    }
                    state.setInstance(instance);
                    if (state.getBuilder() == null) {
                        state.setBuilder(new MapInstanceBuilder(value, dimOffsets));
                    }
                    elemState.registerListener(state, MapSerializer.indexFromPosition(position, dimOffsets));
                } else {
                    MapSerializer.setElement(value, position, elem);
                }
                if (reader.nextElementContent() == 2) break;
                if (isSparseArray) {
                    position = MapSerializer.getArrayElementPosition(reader, dims);
                    if (position == null) {
                        throw new DeserializationException("soap.missingArrayElementPosition");
                    }
                } else if (emptyDims) {
                    position[0] = position[0] + 1;
                } else {
                    MapSerializer.incrementPosition(position, dims);
                }
                if (!emptyDims) continue;
                maxPosition = Math.max(position[0], maxPosition);
            }
            if (emptyDims && length != maxPosition + 1) {
                int newLength = maxPosition + 1;
                newValue = (Object[])Array.newInstance(this.elemClass, newLength);
                System.arraycopy(value, 0, newValue, 0, newLength);
                value = newValue;
                length = newLength;
            }
        } else {
            value = emptyDims ? (Object[])Array.newInstance(this.elemClass, 0) : (Object[])Array.newInstance(this.elemClass, dims);
        }
        if (state != null) {
            state.setDeserializer(this);
            state.setInstance(instance);
            state.doneReading();
        }
        if (isComplete) {
            return MapSerializer.arrayToMap(instance, value);
        }
        return state;
    }

    public static void setElement(Object[] value, int[] position, Object elem) {
        Object[] arr = value;
        for (int i = 0; i < position.length - 1; ++i) {
            arr = (Object[])arr[position[i]];
        }
        arr[position[position.length - 1]] = elem;
    }

    private static Map arrayToMap(Map mapInstance, Object[] arrInstance) {
        if (arrInstance != null) {
            for (int i = 0; i < arrInstance.length; ++i) {
                JAXRpcMapEntry mapItem = (JAXRpcMapEntry)arrInstance[i];
                Object key = mapItem.getKey();
                Object value = mapItem.getValue();
                mapInstance.put(key, value);
            }
        }
        return mapInstance;
    }

    private class MapInstanceBuilder
    implements SOAPInstanceBuilder {
        int[] dimOffsets = null;
        Object[] arrInstance = null;
        Map instance = null;

        MapInstanceBuilder(Object[] arrInstance, int[] dimOffsets) {
            this.arrInstance = arrInstance;
            this.dimOffsets = dimOffsets;
        }

        @Override
        public int memberGateType(int memberIndex) {
            return 10;
        }

        @Override
        public void construct() {
            throw new IllegalStateException();
        }

        @Override
        public void setMember(int index, Object memberValue) {
            int[] position = CollectionSerializerBase.positionFromIndex(index, this.dimOffsets);
            MapSerializer.setElement(this.arrInstance, position, memberValue);
        }

        @Override
        public void initialize() {
            this.instance = MapSerializer.arrayToMap(this.instance, this.arrInstance);
        }

        @Override
        public void setInstance(Object instance) {
            this.instance = (Map)instance;
        }

        @Override
        public Object getInstance() {
            return this.instance;
        }
    }
}

