/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCloudExadataInfrastructureRequest
extends BmcRequest<Void> {
    private String cloudExadataInfrastructureId;
    private String opcRequestId;

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().cloudExadataInfrastructureId(this.cloudExadataInfrastructureId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cloudExadataInfrastructureId=").append(String.valueOf(this.cloudExadataInfrastructureId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCloudExadataInfrastructureRequest)) {
            return false;
        }
        GetCloudExadataInfrastructureRequest other = (GetCloudExadataInfrastructureRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cloudExadataInfrastructureId, other.cloudExadataInfrastructureId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cloudExadataInfrastructureId == null ? 43 : this.cloudExadataInfrastructureId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCloudExadataInfrastructureRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cloudExadataInfrastructureId = null;
        private String opcRequestId = null;

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCloudExadataInfrastructureRequest o) {
            this.cloudExadataInfrastructureId(o.getCloudExadataInfrastructureId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCloudExadataInfrastructureRequest build() {
            GetCloudExadataInfrastructureRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCloudExadataInfrastructureRequest buildWithoutInvocationCallback() {
            GetCloudExadataInfrastructureRequest request = new GetCloudExadataInfrastructureRequest();
            request.cloudExadataInfrastructureId = this.cloudExadataInfrastructureId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

