/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourcePoolSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="poolSize")
    private final Integer poolSize;
    @JsonProperty(value="isDisabled")
    private final Boolean isDisabled;

    @Deprecated
    @ConstructorProperties(value={"poolSize", "isDisabled"})
    public ResourcePoolSummary(Integer poolSize, Boolean isDisabled) {
        this.poolSize = poolSize;
        this.isDisabled = isDisabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourcePoolSummary(");
        sb.append("super=").append(super.toString());
        sb.append("poolSize=").append(String.valueOf(this.poolSize));
        sb.append(", isDisabled=").append(String.valueOf(this.isDisabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePoolSummary)) {
            return false;
        }
        ResourcePoolSummary other = (ResourcePoolSummary)((Object)o);
        return Objects.equals(this.poolSize, other.poolSize) && Objects.equals(this.isDisabled, other.isDisabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.poolSize == null ? 43 : this.poolSize.hashCode());
        result = result * 59 + (this.isDisabled == null ? 43 : this.isDisabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="poolSize")
        private Integer poolSize;
        @JsonProperty(value="isDisabled")
        private Boolean isDisabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder poolSize(Integer poolSize) {
            this.poolSize = poolSize;
            this.__explicitlySet__.add("poolSize");
            return this;
        }

        public Builder isDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
            this.__explicitlySet__.add("isDisabled");
            return this;
        }

        public ResourcePoolSummary build() {
            ResourcePoolSummary model = new ResourcePoolSummary(this.poolSize, this.isDisabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourcePoolSummary model) {
            if (model.wasPropertyExplicitlySet("poolSize")) {
                this.poolSize(model.getPoolSize());
            }
            if (model.wasPropertyExplicitlySet("isDisabled")) {
                this.isDisabled(model.getIsDisabled());
            }
            return this;
        }
    }
}

