/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseConnectionStrings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cdbDefault")
    private final String cdbDefault;
    @JsonProperty(value="cdbIpDefault")
    private final String cdbIpDefault;
    @JsonProperty(value="allConnectionStrings")
    private final Map<String, String> allConnectionStrings;

    @Deprecated
    @ConstructorProperties(value={"cdbDefault", "cdbIpDefault", "allConnectionStrings"})
    public DatabaseConnectionStrings(String cdbDefault, String cdbIpDefault, Map<String, String> allConnectionStrings) {
        this.cdbDefault = cdbDefault;
        this.cdbIpDefault = cdbIpDefault;
        this.allConnectionStrings = allConnectionStrings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCdbDefault() {
        return this.cdbDefault;
    }

    public String getCdbIpDefault() {
        return this.cdbIpDefault;
    }

    public Map<String, String> getAllConnectionStrings() {
        return this.allConnectionStrings;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseConnectionStrings(");
        sb.append("super=").append(super.toString());
        sb.append("cdbDefault=").append(String.valueOf(this.cdbDefault));
        sb.append(", cdbIpDefault=").append(String.valueOf(this.cdbIpDefault));
        sb.append(", allConnectionStrings=").append(String.valueOf(this.allConnectionStrings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseConnectionStrings)) {
            return false;
        }
        DatabaseConnectionStrings other = (DatabaseConnectionStrings)((Object)o);
        return Objects.equals(this.cdbDefault, other.cdbDefault) && Objects.equals(this.cdbIpDefault, other.cdbIpDefault) && Objects.equals(this.allConnectionStrings, other.allConnectionStrings) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cdbDefault == null ? 43 : this.cdbDefault.hashCode());
        result = result * 59 + (this.cdbIpDefault == null ? 43 : this.cdbIpDefault.hashCode());
        result = result * 59 + (this.allConnectionStrings == null ? 43 : this.allConnectionStrings.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cdbDefault")
        private String cdbDefault;
        @JsonProperty(value="cdbIpDefault")
        private String cdbIpDefault;
        @JsonProperty(value="allConnectionStrings")
        private Map<String, String> allConnectionStrings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cdbDefault(String cdbDefault) {
            this.cdbDefault = cdbDefault;
            this.__explicitlySet__.add("cdbDefault");
            return this;
        }

        public Builder cdbIpDefault(String cdbIpDefault) {
            this.cdbIpDefault = cdbIpDefault;
            this.__explicitlySet__.add("cdbIpDefault");
            return this;
        }

        public Builder allConnectionStrings(Map<String, String> allConnectionStrings) {
            this.allConnectionStrings = allConnectionStrings;
            this.__explicitlySet__.add("allConnectionStrings");
            return this;
        }

        public DatabaseConnectionStrings build() {
            DatabaseConnectionStrings model = new DatabaseConnectionStrings(this.cdbDefault, this.cdbIpDefault, this.allConnectionStrings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseConnectionStrings model) {
            if (model.wasPropertyExplicitlySet("cdbDefault")) {
                this.cdbDefault(model.getCdbDefault());
            }
            if (model.wasPropertyExplicitlySet("cdbIpDefault")) {
                this.cdbIpDefault(model.getCdbIpDefault());
            }
            if (model.wasPropertyExplicitlySet("allConnectionStrings")) {
                this.allConnectionStrings(model.getAllConnectionStrings());
            }
            return this;
        }
    }
}

