/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;

final class CompositeResult<T>
implements ResultImplementation<T> {
    private final List<ResultImplementation<T>> results;

    public CompositeResult(List<ResultImplementation<T>> results) {
        this.results = results;
    }

    public CompositeResult(ResultImplementation<T> first, ResultImplementation<T> second) {
        this(List.of(first, second));
    }

    @Override
    public boolean isPartial() {
        for (ResultImplementation<T> result : this.results) {
            if (!result.isPartial()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void waitForSkipped() {
        for (ResultImplementation<T> result : this.results) {
            result.waitForSkipped();
        }
    }

    @Override
    public List<T> getResults() {
        return this.results.stream().flatMap(r -> r.getResults().stream()).sorted().distinct().collect(Collectors.toList());
    }

    @Override
    public int getTotalResultCount() {
        int ret = 0;
        for (ResultImplementation<T> result : this.results) {
            ret += result.getTotalResultCount();
        }
        return ret;
    }

    @Override
    public int getReturnedResultCount() {
        int ret = 0;
        for (ResultImplementation<T> result : this.results) {
            ret += result.getReturnedResultCount();
        }
        return ret;
    }
}

