/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.junit.DefaultPlugin;
import org.netbeans.modules.junit.api.JUnitSettings;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public final class DefaultITPlugin
extends JUnitPlugin {
    protected CommonPlugin.Location getTestLocation(CommonPlugin.Location sourceLocation) {
        String testResName;
        FileObject fileObj = sourceLocation.getFileObject();
        ClassPath srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
        if (srcCp == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        if (baseResName == null) {
            return null;
        }
        String string = testResName = !fileObj.isFolder() ? DefaultITPlugin.getTestResName(baseResName, fileObj.getExt()) : DefaultITPlugin.getSuiteResName(baseResName);
        assert (testResName != null);
        CommonPlugin.Location oppositeLocation = DefaultITPlugin.getOppositeLocation(sourceLocation, srcCp, testResName, true);
        return oppositeLocation;
    }

    protected CommonPlugin.Location getTestedLocation(CommonPlugin.Location testLocation) {
        ClassPath srcCp;
        FileObject fileObj = testLocation.getFileObject();
        if (fileObj.isFolder() || (srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source")) == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        if (baseResName == null) {
            return null;
        }
        String srcResName = DefaultITPlugin.getSrcResName(baseResName, fileObj.getExt());
        if (srcResName == null) {
            return null;
        }
        return DefaultITPlugin.getOppositeLocation(testLocation, srcCp, srcResName, false);
    }

    private static String getTestResName(String baseResName, String ext) {
        StringBuilder buf = new StringBuilder(baseResName.length() + ext.length() + 10);
        buf.append(baseResName).append("IT");
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getSuiteResName(String baseResName) {
        if (baseResName.length() == 0) {
            return JUnitSettings.getDefault().getRootSuiteClassName();
        }
        String suiteSuffix = "Suite";
        String lastNamePart = baseResName.substring(baseResName.lastIndexOf(47) + 1);
        StringBuilder buf = new StringBuilder(baseResName.length() + lastNamePart.length() + "Suite".length() + 6);
        buf.append(baseResName).append('/');
        buf.append(Character.toUpperCase(lastNamePart.charAt(0))).append(lastNamePart.substring(1));
        buf.append("Suite");
        buf.append(".java");
        return buf.toString();
    }

    private static String getSrcResName(String testResName, String ext) {
        if (!testResName.endsWith("IT")) {
            return null;
        }
        StringBuilder buf = new StringBuilder(testResName.length() + ext.length());
        buf.append(testResName.substring(0, testResName.length() - 2));
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static CommonPlugin.Location getOppositeLocation(CommonPlugin.Location sourceLocation, ClassPath fileObjCp, String oppoResourceName, boolean sourceToTest) {
        URL[] oppoRootsURLs;
        FileObject fileObj = sourceLocation.getFileObject();
        FileObject fileObjRoot = fileObjCp.findOwnerRoot(fileObj);
        if (fileObjRoot == null) {
            return null;
        }
        URL[] uRLArray = oppoRootsURLs = sourceToTest ? UnitTestForSourceQuery.findUnitTests((FileObject)fileObjRoot) : UnitTestForSourceQuery.findSources((FileObject)fileObjRoot);
        if (oppoRootsURLs == null || oppoRootsURLs.length == 0) {
            return null;
        }
        ClassPath oppoRootsClassPath = ClassPathSupport.createClassPath((URL[])oppoRootsURLs);
        List oppoFiles = oppoRootsClassPath.findAllResources(oppoResourceName);
        if (oppoFiles.isEmpty()) {
            return null;
        }
        return new CommonPlugin.Location((FileObject)oppoFiles.get(0));
    }

    protected FileObject[] createTests(FileObject[] filesToTest, FileObject targetRoot, Map<CommonPlugin.CreateTestParam, Object> params) {
        JUnitPlugin plugin;
        Project project = FileOwnerQuery.getOwner((FileObject)filesToTest[0]);
        if (project != null && (plugin = JUnitTestUtil.getPluginForProject(project)) instanceof DefaultPlugin) {
            params.put(CommonPlugin.CreateTestParam.INC_GENERATE_INTEGRATION_TEST, Boolean.TRUE);
            return ((DefaultPlugin)plugin).createTests(filesToTest, targetRoot, params);
        }
        return new FileObject[0];
    }
}

