/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.BugtrackingSupport;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.IssueScheduleProvider;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.localtasks.Bundle;
import org.netbeans.modules.localtasks.IssueProviderImpl;
import org.netbeans.modules.localtasks.IssueSchedulingProviderImpl;
import org.netbeans.modules.localtasks.IssueStatusProviderImpl;
import org.netbeans.modules.localtasks.LocalQuery;
import org.netbeans.modules.localtasks.LocalRepositoryConfig;
import org.netbeans.modules.localtasks.QueryProviderImpl;
import org.netbeans.modules.localtasks.RepositoryProviderImpl;
import org.netbeans.modules.localtasks.task.LocalTask;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.NbTask;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public final class LocalRepository {
    private static final String ID = "LocalRepositoryInstance";
    private static LocalRepository instance;
    private final Repository repository;
    private final BugtrackingSupport<LocalRepository, LocalQuery, LocalTask> fac;
    private final PropertyChangeSupport propertySuport;
    private static final String ICON_PATH = "org/netbeans/modules/localtasks/resources/local_repo.png";
    private final Image icon;
    private TaskRepository taskRepository;
    private final Object CACHE_LOCK = new Object();
    private Cache cache;
    private boolean initialized;
    public static final Logger LOG;
    private static final RequestProcessor RP;

    public static synchronized LocalRepository getInstance() {
        if (instance == null) {
            instance = new LocalRepository();
        }
        return instance;
    }

    public LocalRepository() {
        this.fac = new BugtrackingSupport((RepositoryProvider)new RepositoryProviderImpl(), (QueryProvider)new QueryProviderImpl(), (IssueProvider)new IssueProviderImpl());
        this.icon = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        this.propertySuport = new PropertyChangeSupport(this);
        this.repository = this.fac.createRepository((Object)this, (IssueStatusProvider)new IssueStatusProviderImpl(), (IssueScheduleProvider)new IssueSchedulingProviderImpl(), null, null);
    }

    public Repository getRepository() {
        return this.repository;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySuport.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySuport.removePropertyChangeListener(listener);
    }

    Image getIcon() {
        return this.icon;
    }

    String getID() {
        return ID;
    }

    String getDisplayName() {
        return this.getTaskRepository().getRepositoryLabel();
    }

    String getTooltip() {
        return Bundle.CTL_LocalRepository_tooltip(this.getUrl());
    }

    String getUrl() {
        return this.getTaskRepository().getRepositoryUrl();
    }

    Collection<LocalQuery> getQueries() {
        return Collections.singletonList(LocalQuery.getInstance());
    }

    public TaskRepository getTaskRepository() {
        if (this.taskRepository == null) {
            this.taskRepository = MylynSupport.getInstance().getLocalTaskRepository();
        }
        return this.taskRepository;
    }

    boolean refreshTasks() throws CoreException {
        Collection oldTasks = this.getCache().getAllTasks();
        for (NbTask task : MylynSupport.getInstance().getTasks(this.taskRepository)) {
            this.getLocalTask(task);
        }
        this.initialized = true;
        return !oldTasks.equals(this.getCache().getAllTasks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalTask getLocalTask(NbTask task) {
        LocalTask issue = null;
        if (task != null) {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                String taskId = LocalTask.getID((NbTask)task);
                Cache issueCache = this.getCache();
                issue = issueCache.getTask(taskId);
                if (issue == null) {
                    issue = issueCache.setTask(taskId, new LocalTask(task));
                }
            }
        }
        return issue;
    }

    Collection<LocalTask> getTasks() {
        if (!this.initialized) {
            try {
                this.refreshTasks();
            }
            catch (CoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.getCache().getAllTasks();
    }

    LocalTask createTask() {
        try {
            NbTask task = MylynSupport.getInstance().createTask(this.taskRepository, (ITaskMapping)new TaskMapping(){

                public String getSummary() {
                    return Bundle.LBL_NewTask_summary();
                }
            });
            LocalTask lt = this.getLocalTask(task);
            LocalQuery.getInstance().addTask(lt);
            return lt;
        }
        catch (OperationCanceledException ex) {
            LOG.log(Level.FINE, null, ex);
            return null;
        }
        catch (CoreException ex) {
            LOG.log(Level.WARNING, null, ex);
            return null;
        }
    }

    List<LocalTask> getTasks(String[] ids) {
        ArrayList<LocalTask> ret = new ArrayList<LocalTask>(ids.length);
        boolean queryNeedsRefresh = false;
        try {
            MylynSupport supp = MylynSupport.getInstance();
            for (String id : ids) {
                LocalTask task = this.getCache().getTask(id);
                if (task == null && (task = this.getLocalTask(supp.getTask(this.getTaskRepository().getUrl(), id))) != null) {
                    queryNeedsRefresh = true;
                }
                if (task == null) continue;
                ret.add(task);
            }
        }
        catch (CoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        if (queryNeedsRefresh) {
            this.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    LocalQuery.getInstance().fireFinished();
                }
            });
        }
        return ret;
    }

    Collection<LocalTask> simpleSearch(String criteria) {
        LocalTask task;
        String[] keywords = criteria.split(" ");
        HashSet<LocalTask> tasks = new HashSet<LocalTask>();
        LocalQuery.getInstance().refresh();
        if (keywords.length == 1 && this.isInteger(keywords[0]) && (task = this.getCache().getTask(keywords[0])) != null) {
            tasks.add(task);
        }
        Collection<LocalTask> allTasks = this.getTasks();
        for (LocalTask task2 : allTasks) {
            if (!task2.searchFor(keywords)) continue;
            tasks.add(task2);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = new Cache();
            }
            return this.cache;
        }
    }

    public RequestProcessor getRequestProcessor() {
        return RP;
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void taskDeleted(String id) {
        LocalRepositoryConfig.getInstance().deleteTaskPreferences(id);
        LocalTask lt = this.getCache().getTask(id);
        if (lt != null) {
            this.getCache().removeTask(id);
            LocalQuery.getInstance().removeTask(lt);
        }
    }

    static {
        LOG = Logger.getLogger(LocalRepository.class.getName());
        RP = new RequestProcessor("Local Task Repository");
    }

    private class Cache {
        private final Map<String, Reference<LocalTask>> tasks = new LinkedHashMap<String, Reference<LocalTask>>();

        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LocalTask getTask(String id) {
            Object object = LocalRepository.this.CACHE_LOCK;
            synchronized (object) {
                Reference<LocalTask> taskRef = this.tasks.get(id);
                return taskRef == null ? null : taskRef.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LocalTask setTask(String id, LocalTask task) {
            Object object = LocalRepository.this.CACHE_LOCK;
            synchronized (object) {
                this.tasks.put(id, new SoftReference<LocalTask>(task));
            }
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTask(String id) {
            Object object = LocalRepository.this.CACHE_LOCK;
            synchronized (object) {
                this.tasks.remove(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<LocalTask> getAllTasks() {
            ArrayList<LocalTask> allTasks;
            Object object = LocalRepository.this.CACHE_LOCK;
            synchronized (object) {
                allTasks = new ArrayList<LocalTask>(this.tasks.size());
                for (Reference<LocalTask> ref : this.tasks.values()) {
                    LocalTask task = ref.get();
                    if (task == null) continue;
                    allTasks.add(task);
                }
            }
            return allTasks;
        }
    }
}

