/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.SessionBridge;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDAMethodChooserUtils;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RunIntoMethodActionSupport {
    private static final Logger logger = Logger.getLogger(RunIntoMethodActionSupport.class.getName());

    private RunIntoMethodActionSupport() {
    }

    public static void runIntoMethod(final JPDADebuggerImpl debugger, final String url, String className, final String method, final int methodLine, final int methodOffset) {
        VirtualMachine vm = debugger.getVirtualMachine();
        if (vm == null) {
            return;
        }
        ReferenceType clazz = null;
        String clazzName = null;
        JPDAThreadImpl ct = (JPDAThreadImpl)debugger.getCurrentThread();
        if (ct != null) {
            ThreadReference threadReference = ct.getThreadReference();
            try {
                if (ThreadReferenceWrapper.frameCount(threadReference) < 1) {
                    return;
                }
                clazz = LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
                clazzName = ReferenceTypeWrapper.name(clazz);
            }
            catch (InternalExceptionWrapper ex) {
                return;
            }
            catch (ObjectCollectedExceptionWrapper ex) {
            }
            catch (InvalidStackFrameExceptionWrapper ex) {
            }
            catch (IncompatibleThreadStateException ex) {
            }
            catch (IllegalThreadStateExceptionWrapper ex) {
                return;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return;
            }
        }
        if (clazz != null && (className == null || className.equals(clazzName))) {
            RunIntoMethodActionSupport.doAction(debugger, url, clazz, methodLine, methodOffset, method, true);
        } else {
            try {
                List<ReferenceType> classes = VirtualMachineWrapper.classesByName(vm, className);
                if (classes.size() > 0) {
                    RunIntoMethodActionSupport.doAction(debugger, url, classes.get(0), methodLine, methodOffset, method, true);
                    return;
                }
            }
            catch (InternalExceptionWrapper ex) {
                return;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return;
            }
            final ClassLoadUnloadBreakpoint cbrkp = ClassLoadUnloadBreakpoint.create((String)className, (boolean)false, (int)1);
            cbrkp.setHidden(true);
            cbrkp.setSuspend(0);
            cbrkp.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)cbrkp);
                    RunIntoMethodActionSupport.doAction(debugger, url, event.getReferenceType(), methodLine, methodOffset, method, false);
                }
            });
            cbrkp.setSession((JPDADebugger)debugger);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)cbrkp);
            RunIntoMethodActionSupport.resume(debugger);
        }
    }

    private static void resume(JPDADebugger debugger) {
        if (debugger.getSuspend() == 1) {
            debugger.getCurrentThread().resume();
        } else {
            ((JPDADebuggerImpl)debugger).resume();
        }
    }

    private static void doAction(JPDADebuggerImpl debugger, String url, ReferenceType clazz, int methodLine, int methodOffset, String methodName, boolean doResume) {
        List<Object> locations = Collections.emptyList();
        try {
            while (methodLine > 0 && (locations = ReferenceTypeWrapper.locationsOfLine(clazz, methodLine)).isEmpty()) {
                --methodLine;
            }
        }
        catch (InternalExceptionWrapper aiex) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper aiex) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper aiex) {
            return;
        }
        catch (ClassNotPreparedExceptionWrapper aiex) {
        }
        catch (AbsentInformationException aiex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)aiex, (Level)Level.INFO));
        }
        logger.log(Level.FINE, "doAction({0}, {1}, {2}, {3}) locations = {4}", new Object[]{url, clazz, methodLine, methodName, locations});
        if (locations.isEmpty()) {
            debugger.actionMessageCallback(ActionsManager.ACTION_RUN_INTO_METHOD, NbBundle.getMessage(RunIntoMethodActionSupport.class, (String)"MSG_RunIntoMeth_absentInfo", (Object)clazz.name()));
            return;
        }
        ExpressionPool.Expression expr = debugger.getExpressionPool().getExpressionAt((Location)locations.get(0), url);
        Location bpLocation = null;
        ExpressionPool.Interval expressionLines = null;
        String methodClassType = null;
        boolean isNative = false;
        if (expr != null) {
            EditorContext.Operation[] ops = expr.getOperations();
            for (int i = 0; i < ops.length; ++i) {
                EditorContext.Operation op = ops[i];
                if (op.getMethodStartPosition().getOffset() > methodOffset || methodOffset > op.getMethodEndPosition().getOffset()) continue;
                bpLocation = expr.getLocations()[i];
                methodClassType = op.getMethodClassType();
                isNative = op.isNative();
                break;
            }
            expressionLines = expr.getInterval();
        }
        if (bpLocation == null) {
            bpLocation = (Location)locations.get(0);
        }
        RunIntoMethodActionSupport.doAction(debugger, methodName, methodClassType, isNative, bpLocation, expressionLines, false, doResume, JPDAMethodChooserUtils.MethodEntry.SELECTED);
    }

    static boolean doAction(JPDADebuggerImpl debugger, String methodName, String methodClassType, boolean isNative, Location bpLocation, ExpressionPool.Interval expressionLines, boolean setBoundaryStep, JPDAMethodChooserUtils.MethodEntry methodEntry) {
        return RunIntoMethodActionSupport.doAction(debugger, methodName, methodClassType, isNative, bpLocation, expressionLines, setBoundaryStep, true, methodEntry);
    }

    private static boolean doAction(final JPDADebuggerImpl debugger, final String methodName, final String methodClassType, final boolean isNative, Location bpLocation, ExpressionPool.Interval expressionLines, boolean setBoundaryStep, boolean doResume, final JPDAMethodChooserUtils.MethodEntry methodEntry) {
        JPDAThreadImpl t;
        boolean areWeOnTheLocation;
        CallStackFrame[] topFramePtr;
        final VirtualMachine vm = debugger.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        final int line = LocationWrapper.lineNumber0(bpLocation, "Java");
        JPDAThreadImpl ct = (JPDAThreadImpl)debugger.getCurrentThread();
        if (ct == null) {
            return false;
        }
        try {
            topFramePtr = ct.getCallStack(0, 1);
        }
        catch (AbsentInformationException ex) {
            logger.log(Level.FINE, "doAction() = false, ex = {0}", ex);
            return false;
        }
        if (topFramePtr.length < 1) {
            logger.fine("doAction() = false, no top frame.");
            return false;
        }
        CallStackFrameImpl csf = (CallStackFrameImpl)topFramePtr[0];
        try {
            areWeOnTheLocation = LocationWrapper.equals(StackFrameWrapper.location(csf.getStackFrame()), bpLocation);
            t = (JPDAThreadImpl)csf.getThread();
        }
        catch (InvalidStackFrameExceptionWrapper e) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return false;
        }
        catch (InternalExceptionWrapper e) {
            return false;
        }
        final boolean doFinishWhenMethodNotFound = setBoundaryStep;
        logger.log(Level.FINE, "doAction() areWeOnTheLocation = {0}, methodName = {1}", new Object[]{areWeOnTheLocation, methodName});
        if (areWeOnTheLocation) {
            RunIntoMethodActionSupport.traceLineForMethod(debugger, ct, methodName, methodClassType, isNative, line, doFinishWhenMethodNotFound, methodEntry);
        } else {
            final JPDAStep[] boundaryStepPtr = new JPDAStep[]{null};
            try {
                final BreakpointRequest brReq = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(vm), bpLocation);
                final ThreadReference preferredThread = t.getThreadReference();
                Executor tracingExecutor = new Executor(){

                    @Override
                    public boolean exec(Event event) {
                        ThreadReference tr = ((BreakpointEvent)event).thread();
                        JPDAThreadImpl jtr = null;
                        try {
                            if (!preferredThread.equals(tr)) {
                                logger.log(Level.FINE, "doAction: tracingExecutor.exec({0}) called with non-preferred thread.", event);
                                for (int i = 20; !ThreadReferenceWrapper.isAtBreakpoint(preferredThread) && i > 0; --i) {
                                    try {
                                        Thread.sleep(50L);
                                        continue;
                                    }
                                    catch (InterruptedException ex) {
                                        break;
                                    }
                                }
                                if (ThreadReferenceWrapper.isAtBreakpoint(preferredThread) && ThreadReferenceWrapper.frameCount(tr) > 0) {
                                    Location prLoc;
                                    Location trLoc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0));
                                    if (ThreadReferenceWrapper.frameCount(preferredThread) > 0 && trLoc.equals(prLoc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(preferredThread, 0)))) {
                                        logger.log(Level.FINE, "doAction: tracingExecutor - preferredThread {0} is at breakpoint, resuming hit thread {1}", new Object[]{preferredThread, tr});
                                        return true;
                                    }
                                }
                            } else {
                                jtr = t;
                            }
                        }
                        catch (InternalExceptionWrapper i) {
                        }
                        catch (InternalException i) {
                        }
                        catch (VMDisconnectedExceptionWrapper i) {
                        }
                        catch (VMDisconnectedException i) {
                        }
                        catch (ObjectCollectedExceptionWrapper i) {
                        }
                        catch (ObjectCollectedException i) {
                        }
                        catch (IllegalThreadStateExceptionWrapper i) {
                        }
                        catch (IllegalThreadStateException i) {
                        }
                        catch (IncompatibleThreadStateException i) {
                        }
                        catch (InvalidStackFrameExceptionWrapper i) {
                            // empty catch block
                        }
                        if (jtr == null) {
                            jtr = debugger.getThread(tr);
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("doAction: tracingExecutor.exec(" + event + ") called with thread " + tr + " which is " + (preferredThread.equals(tr) ? "" : "not ") + "preferred.");
                            logger.fine("Calling location reached, tracing for " + methodName + "()");
                        }
                        if (boundaryStepPtr[0] != null) {
                            ((JPDAStepImpl)boundaryStepPtr[0]).cancel();
                        }
                        try {
                            try {
                                EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), brReq);
                            }
                            catch (InvalidRequestStateExceptionWrapper i) {
                                // empty catch block
                            }
                            debugger.getOperator().unregister(brReq);
                        }
                        catch (InternalExceptionWrapper i) {
                        }
                        catch (VMDisconnectedExceptionWrapper e) {
                            return false;
                        }
                        RunIntoMethodActionSupport.traceLineForMethod(debugger, jtr, methodName, methodClassType, isNative, line, doFinishWhenMethodNotFound, methodEntry);
                        return true;
                    }

                    @Override
                    public void removed(EventRequest eventRequest) {
                    }
                };
                debugger.getOperator().register(brReq, tracingExecutor);
                EventRequestWrapper.setSuspendPolicy(brReq, debugger.getSuspend());
                try {
                    EventRequestWrapper.enable(brReq);
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    debugger.getOperator().unregister(brReq);
                    return false;
                }
                catch (InvalidRequestStateExceptionWrapper irse) {
                    Exceptions.printStackTrace((Throwable)irse);
                    debugger.getOperator().unregister(brReq);
                    return false;
                }
                if (setBoundaryStep) {
                    boundaryStepPtr[0] = RunIntoMethodActionSupport.setBoundaryStepRequest(debugger, t, brReq, expressionLines);
                }
            }
            catch (VMDisconnectedExceptionWrapper e) {
                return false;
            }
            catch (InternalExceptionWrapper e) {
                return false;
            }
        }
        if (doResume) {
            RunIntoMethodActionSupport.resume(debugger);
        }
        return true;
    }

    private static JPDAStep setBoundaryStepRequest(final JPDADebuggerImpl debugger, final JPDAThread tr, final EventRequest request, final ExpressionPool.Interval expressionLines) {
        JPDAStep boundaryStep = debugger.createJPDAStep(-2, 2);
        boundaryStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VirtualMachine vm = debugger.getVirtualMachine();
                if (vm != null) {
                    try {
                        debugger.getOperator().unregister(request);
                        EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), request);
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    }
                    catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                        // empty catch block
                    }
                }
            }
        });
        ((JPDAStepImpl)boundaryStep).setStopHereCheck(new JPDAStepImpl.StopHereCheck(){

            @Override
            public boolean stopHere(boolean willStop) {
                int line;
                if (willStop && expressionLines.contains(line = tr.getLineNumber(debugger.getSession().getCurrentLanguage()))) {
                    willStop = false;
                }
                return willStop;
            }
        });
        boundaryStep.addStep(tr);
        return boundaryStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceLineForMethod(final JPDADebuggerImpl debugger, final JPDAThreadImpl jtr, final String method, String methodClassType, boolean isNative, final int methodLine, final boolean finishWhenNotFound, JPDAMethodChooserUtils.MethodEntry methodEntry) {
        final int depth = jtr.getStackDepth();
        if (isNative && SessionBridge.getDefault().isChangerFor((String)ActionsManager.ACTION_STEP_INTO)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("javaClass", methodClassType);
            properties.put("javaMethod", method);
            Session session = debugger.getSession();
            RunIntoMethodActionSupport.putConnectionProperties(session, properties);
            Lock writeLock = jtr.accessLock.writeLock();
            boolean changed = false;
            writeLock.lock();
            try {
                changed = SessionBridge.getDefault().suggestChange(session, (String)ActionsManager.ACTION_STEP_INTO, properties);
            }
            finally {
                if (changed) {
                    writeLock.unlock();
                    jtr.resume();
                    return;
                }
                writeLock.unlock();
            }
        }
        final JPDAStep step = debugger.createJPDAStep(-2, 1);
        step.setHidden(true);
        logger.log(Level.FINE, "Will traceLineForMethod({0}, {1}, {2})", new Object[]{method, methodLine, finishWhenNotFound});
        if (JPDAMethodChooserUtils.MethodEntry.SELECTED.equals((Object)methodEntry)) {
            ((JPDAStepImpl)step).setIgnoreStepFilters(true);
        }
        step.addPropertyChangeListener("exec", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block16: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("traceLineForMethod(" + method + ") step is at " + debugger.getCurrentThread().getClassName() + ":" + debugger.getCurrentThread().getMethodName());
                    }
                    int currentDepth = jtr.getStackDepth();
                    logger.log(Level.FINE, "  depth = {0}, target = {1}", new Object[]{currentDepth, depth});
                    if (currentDepth == depth) {
                        try {
                            if (jtr.getCallStack()[0].getLineNumber("Java") != methodLine) {
                                step.setHidden(false);
                                break block16;
                            }
                            logger.fine("  back on the method invoaction line, setting additional step into.");
                            step.setDepth(1);
                            step.addStep(debugger.getCurrentThread());
                        }
                        catch (AbsentInformationException aiex) {
                            Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)aiex, (Level)Level.INFO));
                            step.setHidden(false);
                        }
                    } else {
                        String threadMethod = jtr.getMethodName();
                        logger.log(Level.FINE, "  threadMethod = ''{0}'', tracing method = ''{1}'', equals = {2}", new Object[]{threadMethod, method, threadMethod.equals(method)});
                        boolean isInit = threadMethod.equals("<init>");
                        if (threadMethod.equals(method)) {
                            step.setHidden(false);
                        } else if (isInit && (jtr.getClassName().endsWith("." + method) || jtr.getClassName().equals(method))) {
                            step.setHidden(false);
                        } else {
                            boolean doFinish = finishWhenNotFound;
                            if (doFinish && currentDepth > depth) {
                                try {
                                    if (jtr.getCallStack(0, depth + 1)[depth].getLineNumber("Java") == methodLine) {
                                        doFinish = false;
                                    }
                                }
                                catch (AbsentInformationException aiex) {
                                    Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)aiex, (Level)Level.INFO));
                                }
                            }
                            if (doFinish) {
                                step.setHidden(false);
                                logger.fine("  stepping finished.");
                            } else {
                                logger.fine("  step out submitted.");
                                step.setDepth(3);
                                step.addStep(debugger.getCurrentThread());
                            }
                        }
                    }
                }
            }
        });
        step.addStep((JPDAThread)jtr);
    }

    private static void putConnectionProperties(Session session, Map properties) {
        ListeningDICookie lc = (ListeningDICookie)session.lookupFirst(null, ListeningDICookie.class);
        Map args = null;
        if (lc != null) {
            args = lc.getArgs();
            properties.put("conn_port", lc.getPortNumber());
            properties.put("conn_shmem", lc.getSharedMemoryName());
        } else {
            AttachingDICookie ac = (AttachingDICookie)session.lookupFirst(null, AttachingDICookie.class);
            if (ac != null) {
                args = ac.getArgs();
                properties.put("conn_host", ac.getHostName());
                properties.put("conn_port", ac.getPortNumber());
                properties.put("conn_shmem", ac.getSharedMemoryName());
                properties.put("conn_pid", ac.getProcessID());
            }
        }
    }
}

