/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.datatype.CustomDatatype;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.AttributeRef;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.impl.SchemaGeneratorUtil;
import org.netbeans.modules.xml.axi.impl.SchemaUpdate;
import org.netbeans.modules.xml.axi.visitor.AXINonCyclicVisitor;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ComplexContent;
import org.netbeans.modules.xml.schema.model.ComplexContentDefinition;
import org.netbeans.modules.xml.schema.model.ComplexContentRestriction;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.ComplexTypeDefinition;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.Extension;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalAttributeContainer;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.NameableSchemaComponent;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleContent;
import org.netbeans.modules.xml.schema.model.SimpleContentDefinition;
import org.netbeans.modules.xml.schema.model.SimpleContentRestriction;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public abstract class DefaultSchemaGenerator
extends SchemaGenerator {
    protected AXIModel am;
    protected SchemaModel sm;
    protected SchemaGenerator.UniqueId id;
    protected SchemaGenerator.PrimitiveCart pc;
    List<AXIComponent> path = new ArrayList<AXIComponent>();
    protected SchemaComponent sc;
    protected SchemaComponent scParent;
    protected SchemaComponent datatypeParent;
    protected SortedMap<Integer, List<Object>> fixNamesMap = null;
    protected List<SchemaComponent> createGlobals = null;
    protected HashMap<SchemaComponent, SchemaComponent> refMap = null;
    protected HashMap<Class, HashMap<String, SchemaComponent>> namesMap = null;
    protected List<Element> elementReuseList = null;
    protected SchemaGeneratorHelper sgh;
    private int fgeCount = 0;
    public static final int commitRange = Integer.getInteger("schematools.axi.adp", 0);

    public DefaultSchemaGenerator(SchemaGenerator.Mode mode) {
        super(mode);
        this.id = this.createUniqueId();
        this.pc = this.createPrimitiveCart();
        this.fixNamesMap = new TreeMap<Integer, List<Object>>();
        this.createGlobals = new ArrayList<SchemaComponent>();
        this.refMap = new HashMap();
        this.namesMap = new HashMap();
        this.elementReuseList = new ArrayList<Element>();
    }

    @Override
    public void updateSchema(SchemaModel sm) throws IOException {
        assert (this.getMode() == SchemaGenerator.Mode.UPDATE);
        this.sgh = new UpdateHelper();
        this.sgh.execute(sm);
    }

    @Override
    public void transformSchema(SchemaModel sm) throws IOException {
        assert (this.getMode() == SchemaGenerator.Mode.TRANSFORM);
        this.sgh = new TransformHelper();
        this.sgh.execute(sm);
    }

    @Override
    public void visit(Element element) {
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM && element instanceof ElementRef) {
            this.prepareElementRef((ElementRef)element);
        } else {
            this.prepareLocalElement(element);
        }
    }

    @Override
    public void visit(Attribute attribute) {
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM && attribute instanceof AttributeRef) {
            this.prepareAttributeRef((AttributeRef)attribute);
        } else {
            this.prepareLocalAttribute(attribute);
        }
    }

    public void visit(AXIType type) {
        if (type instanceof Datatype) {
            ((Datatype)type).accept(this);
        }
    }

    @Override
    public void visit(Datatype d) {
        SchemaGeneratorUtil.createInlineSimpleType(d, this.sm, this.datatypeParent, this.pc);
    }

    @Override
    public void visit(ContentModel cm) {
        if (this.scParent instanceof Schema) {
            GlobalComplexType gct = SchemaGeneratorUtil.createGlobalComplexType(this.sm);
            assert (gct != null);
            gct.setName(cm.getName());
            SchemaGeneratorUtil.populateContentModel((SchemaComponent)gct, cm);
            if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                cm.setPeer((SchemaComponent)gct);
                int index = cm.getIndex(false);
                SchemaGeneratorUtil.addChildComponent(this.sm, (SchemaComponent)this.sm.getSchema(), (SchemaComponent)gct, index);
            } else {
                this.scParent = gct;
            }
            this.scParent = gct;
            for (AXIComponent child : cm.getChildren()) {
                child.accept(this);
            }
        }
    }

    @Override
    public void visit(Compositor compositor) {
        int index = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            index = compositor.getIndex(false);
        }
        switch (compositor.getType()) {
            case SEQUENCE: {
                Sequence seq = null;
                if (this.scParent instanceof ComplexType) {
                    if (this.scParent instanceof LocalComplexType) {
                        LocalComplexType lct = (LocalComplexType)this.scParent;
                        if (lct.getDefinition() != null) {
                            ComplexTypeDefinition ctd = lct.getDefinition();
                            if (ctd instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, ctd);
                                seq = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)lct);
                            } else {
                                seq = SchemaGeneratorUtil.createSequence(this.sm, ctd, index);
                            }
                        } else {
                            seq = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)((LocalComplexType)this.scParent));
                        }
                    } else if (this.scParent instanceof GlobalComplexType) {
                        GlobalComplexType gct = (GlobalComplexType)this.scParent;
                        if (gct.getDefinition() != null) {
                            ComplexTypeDefinition ctd = gct.getDefinition();
                            if (ctd instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, ctd);
                                seq = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)gct);
                            } else {
                                seq = SchemaGeneratorUtil.createSequence(this.sm, ctd, index);
                            }
                        } else {
                            seq = SchemaGeneratorUtil.createSequence(this.sm, (ComplexType)((GlobalComplexType)this.scParent));
                        }
                    }
                } else if (this.scParent instanceof ComplexContentDefinition) {
                    ComplexContentDefinition ccd = (ComplexContentDefinition)this.scParent;
                    seq = ccd instanceof ComplexContentRestriction && ((ComplexContentRestriction)ccd).getDefinition() != null ? SchemaGeneratorUtil.createSequence(this.sm, ((ComplexContentRestriction)ccd).getDefinition(), index) : SchemaGeneratorUtil.createSequence(this.sm, (ComplexContentDefinition)this.scParent);
                } else if (this.scParent instanceof Sequence) {
                    seq = SchemaGeneratorUtil.createSequence(this.sm, (ComplexTypeDefinition)((Sequence)this.scParent), index);
                } else if (this.scParent instanceof Choice) {
                    seq = SchemaGeneratorUtil.createSequence(this.sm, (ComplexTypeDefinition)((Choice)this.scParent), index);
                }
                SchemaGeneratorUtil.populateCompositor(seq, compositor);
                if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                    compositor.setPeer((SchemaComponent)seq);
                    break;
                }
                this.scParent = seq;
                break;
            }
            case CHOICE: {
                Choice c = null;
                if (this.scParent instanceof ComplexType) {
                    ComplexTypeDefinition ctd;
                    if (this.scParent instanceof LocalComplexType) {
                        LocalComplexType lct = (LocalComplexType)this.scParent;
                        if (lct.getDefinition() != null) {
                            ctd = lct.getDefinition();
                            if (ctd instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, ctd);
                                c = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)lct);
                            } else {
                                c = SchemaGeneratorUtil.createChoice(this.sm, ctd, index);
                            }
                        } else {
                            c = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)((LocalComplexType)this.scParent));
                        }
                    }
                    if (this.scParent instanceof GlobalComplexType) {
                        GlobalComplexType gct = (GlobalComplexType)this.scParent;
                        if (gct.getDefinition() != null) {
                            ctd = gct.getDefinition();
                            if (ctd instanceof SimpleContent) {
                                this.transformToComplexContent(compositor, ctd);
                                c = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)gct);
                            } else {
                                c = SchemaGeneratorUtil.createChoice(this.sm, ctd, index);
                            }
                        } else {
                            c = SchemaGeneratorUtil.createChoice(this.sm, (ComplexType)((GlobalComplexType)this.scParent));
                        }
                    }
                } else if (this.scParent instanceof ComplexContentDefinition) {
                    ComplexContentDefinition ccd = (ComplexContentDefinition)this.scParent;
                    c = ccd instanceof ComplexContentRestriction && ((ComplexContentRestriction)ccd).getDefinition() != null ? SchemaGeneratorUtil.createChoice(this.sm, ((ComplexContentRestriction)ccd).getDefinition(), index) : SchemaGeneratorUtil.createChoice(this.sm, (ComplexContentDefinition)this.scParent);
                } else if (this.scParent instanceof Choice) {
                    c = SchemaGeneratorUtil.createChoice(this.sm, (ComplexTypeDefinition)((Choice)this.scParent), index);
                } else if (this.scParent instanceof Sequence) {
                    c = SchemaGeneratorUtil.createChoice(this.sm, (ComplexTypeDefinition)((Sequence)this.scParent), index);
                }
                SchemaGeneratorUtil.populateCompositor(c, compositor);
                if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                    compositor.setPeer((SchemaComponent)c);
                    break;
                }
                this.scParent = c;
                break;
            }
            case ALL: {
                All a = null;
                if (this.scParent instanceof ComplexType) {
                    a = SchemaGeneratorUtil.createAll(this.sm, (ComplexType)this.scParent);
                } else if (this.scParent instanceof ComplexContentDefinition) {
                    ComplexContentDefinition ccd = (ComplexContentDefinition)this.scParent;
                    a = ccd instanceof ComplexContentRestriction && ((ComplexContentRestriction)ccd).getDefinition() != null ? (All)((ComplexContentRestriction)ccd).getDefinition() : SchemaGeneratorUtil.createAll(this.sm, (ComplexContentDefinition)this.scParent);
                }
                SchemaGeneratorUtil.populateCompositor((ComplexTypeDefinition)a, compositor);
                if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
                    compositor.setPeer((SchemaComponent)a);
                    break;
                }
                this.scParent = a;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private ComplexType transformToComplexContent(Compositor compositor, ComplexTypeDefinition ctd) {
        AXIComponent parent = (AXIComponent)compositor.getParent();
        ComplexType lct = null;
        if (ctd instanceof SimpleContent) {
            NamedComponentReference base;
            lct = (ComplexType)ctd.getParent();
            if (ctd.getChildren().get(0) instanceof SimpleExtension && (base = ((SimpleExtension)ctd.getChildren().get(0)).getBase()) != null && base.get() instanceof GlobalSimpleType) {
                SimpleContent sc1 = (SimpleContent)ctd;
                this.copyAttribute(parent, (LocalAttributeContainer)lct, (SchemaComponent)sc1);
                this.copyAttribute(parent, (LocalAttributeContainer)lct, (SchemaComponent)sc1.getLocalDefinition());
            }
        }
        return lct;
    }

    private void copyAttribute(AXIComponent parent, LocalAttributeContainer lac, SchemaComponent scd) {
        for (SchemaComponent sc : scd.getChildren()) {
            if (!(sc instanceof org.netbeans.modules.xml.schema.model.Attribute)) continue;
            LocalAttribute la = (LocalAttribute)((org.netbeans.modules.xml.schema.model.Attribute)sc).copy((Component)lac);
            lac.addLocalAttribute(la);
            for (AXIComponent child : parent.getChildren()) {
                if (child.getPeer() != sc) continue;
                child.setPeer((SchemaComponent)la);
            }
        }
    }

    public void visit(AXIComponent c) {
        throw new IllegalArgumentException("No action taken on this component: " + c.toString());
    }

    protected abstract SchemaGenerator.Pattern getSchemaDesignPattern();

    protected void prepareGlobalElement(Element element) {
        GlobalElement e = null;
        ElementReference eref = null;
        int index = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            index = element.getIndex(false);
        }
        if (this.scParent instanceof Schema) {
            e = this.createGlobalElement(element);
            this.sgh.addElement(e, index);
            this.prepareFixGlobalElementNames(element, e, null);
        } else if (this.scParent instanceof ComplexTypeDefinition) {
            HashMap<String, SchemaComponent> map;
            String seed = element.getName();
            boolean found = false;
            if ((SchemaGeneratorUtil.isSimpleElement(element) || SchemaGeneratorUtil.hasProxyChild(element)) && (map = this.namesMap.get(GlobalElement.class)) != null && map.get(seed) != null) {
                GlobalElement ge1 = (GlobalElement)map.get(seed);
                GlobalElement ge2 = SchemaGeneratorUtil.createGlobalElement(this.sm);
                ge2.setName(element.getName());
                SchemaGeneratorUtil.populateElement((org.netbeans.modules.xml.schema.model.Element)ge2, element);
                this.datatypeParent = ge2;
                if (element.getType() instanceof Datatype) {
                    element.getType().accept(this);
                } else if (element.getType() instanceof ContentModel) {
                    SchemaGeneratorUtil.setType((org.netbeans.modules.xml.schema.model.Element)ge2, (GlobalComplexType)((ContentModel)element.getType()).getPeer());
                }
                if (SchemaGeneratorUtil.isIdentical((SchemaComponent)ge1, (SchemaComponent)ge2)) {
                    found = true;
                    e = ge1;
                    if (!this.elementReuseList.contains(element)) {
                        this.elementReuseList.add(element);
                    }
                }
            }
            if (!found) {
                e = this.createGlobalElement(element);
                this.sgh.addElement(e, -1);
            }
            eref = SchemaGeneratorUtil.createElementReference(this.sm, this.scParent, e, index);
            this.addRef((SchemaComponent)eref, (SchemaComponent)e);
            this.prepareFixGlobalElementNames(element, e, eref);
        }
        assert (e != null);
        this.sc = e;
        SchemaGeneratorUtil.populateElement((org.netbeans.modules.xml.schema.model.Element)e, element);
        if (eref != null) {
            SchemaGeneratorUtil.populateElement(eref, element);
        }
        this.datatypeParent = e;
        if (element.getType() instanceof Datatype) {
            element.getType().accept(this);
        }
        this.setPeer(element, (org.netbeans.modules.xml.schema.model.Element)e, eref);
    }

    protected void prepareElementRef(ElementRef element) {
        int index = element.getIndex();
        ElementReference eRef = SchemaGeneratorUtil.createElementReference(this.sm, (SchemaComponent)((ComplexTypeDefinition)this.scParent), (GlobalElement)element.getReferent().getPeer(), index);
        this.setPeer(element, null, eRef);
    }

    protected void prepareLocalElement(Element element) {
        GlobalElement e = null;
        int index = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            index = element.getIndex(false);
        }
        if (this.scParent instanceof Schema) {
            e = this.createGlobalElement(element);
            this.sgh.addElement(e, index);
            this.prepareFixGlobalElementNames(element, e, null);
        } else if (this.scParent instanceof ComplexTypeDefinition) {
            e = SchemaGeneratorUtil.createLocalElement(this.sm, (ComplexTypeDefinition)this.scParent, element.getName(), index);
        }
        assert (e != null);
        this.sc = e;
        SchemaGeneratorUtil.populateElement((org.netbeans.modules.xml.schema.model.Element)e, element);
        this.datatypeParent = e;
        if (element.getType() instanceof Datatype) {
            element.getType().accept(this);
        }
        this.setPeer(element, (org.netbeans.modules.xml.schema.model.Element)e, null);
    }

    protected void prepareAttributeRef(AttributeRef attribute) {
        int index = attribute.getIndex();
        AttributeReference aRef = SchemaGeneratorUtil.createAttributeReference(this.sm, this.scParent, (GlobalAttribute)attribute.getReferent().getPeer(), index);
        this.setPeer(attribute, null, aRef);
    }

    protected void prepareLocalAttribute(Attribute attribute) {
        assert (this.scParent != null);
        int index = -1;
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            index = attribute.getIndex();
        }
        LocalAttribute attr = null;
        if (this.scParent instanceof ComplexType && ((ComplexType)this.scParent).getDefinition() instanceof ComplexTypeDefinition) {
            if (((ComplexType)this.scParent).getDefinition() instanceof SimpleContent) {
                SimpleContentDefinition def = ((SimpleContent)((ComplexType)this.scParent).getDefinition()).getLocalDefinition();
                if (def instanceof SimpleContentRestriction) {
                    attr = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((SimpleContentRestriction)def), index);
                } else if (def instanceof Extension) {
                    attr = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((Extension)def), index);
                }
            } else if (((ComplexType)this.scParent).getDefinition() instanceof ComplexContent) {
                ComplexContentDefinition def = ((ComplexContent)((ComplexType)this.scParent).getDefinition()).getLocalDefinition();
                if (def instanceof ComplexContentRestriction) {
                    attr = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((ComplexContentRestriction)def), index);
                } else if (def instanceof Extension) {
                    attr = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), (SchemaComponent)((Extension)def), index);
                }
            } else {
                attr = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), this.scParent, index);
            }
        } else {
            attr = SchemaGeneratorUtil.createLocalAttribute(this.sm, attribute.getName(), this.scParent, index);
        }
        assert (attr != null);
        SchemaGeneratorUtil.populateAttribute((org.netbeans.modules.xml.schema.model.Attribute)attr, attribute);
        this.datatypeParent = attr;
        if (attribute.getType() instanceof Datatype) {
            attribute.getType().accept(this);
        }
        if (this.getMode() != SchemaGenerator.Mode.TRANSFORM) {
            attribute.setPeer((SchemaComponent)attr);
        }
    }

    protected GlobalElement createGlobalElement(Element element) {
        GlobalElement ge = SchemaGeneratorUtil.createGlobalElement(this.sm);
        String eName = this.findUniqueGlobalName(GlobalElement.class, (NameableSchemaComponent)ge, element.getName());
        ge.setName(eName);
        return ge;
    }

    protected GlobalComplexType createGlobalComplexType(String seed) {
        GlobalComplexType gct = SchemaGeneratorUtil.createGlobalComplexType(this.sm);
        String typeName = this.findUniqueGlobalName(GlobalComplexType.class, (NameableSchemaComponent)gct, seed);
        gct.setName(typeName);
        return gct;
    }

    public void createGlobalSimpleType(Datatype d, SchemaModel sm, SchemaComponent sc, SchemaGenerator.UniqueId id, SchemaGenerator.PrimitiveCart pc) {
        if (d != null) {
            NamedComponentReference ref = null;
            if (SchemaGeneratorUtil.isPrimitiveType(d)) {
                ref = SchemaGeneratorUtil.createPrimitiveType(d, sc, pc);
            } else {
                GlobalSimpleType gst = SchemaGeneratorUtil.createGlobalSimpleType(sm);
                String typeName = d.getName();
                typeName = this.findUniqueGlobalName(GlobalSimpleType.class, (NameableSchemaComponent)gst, "New" + typeName.substring(0, 1).toUpperCase() + typeName.substring(1) + "Type" + String.valueOf(id.nextId()));
                gst.setName(typeName);
                this.sgh.addSimpleType(gst, -1);
                if (d instanceof CustomDatatype) {
                    SchemaGeneratorUtil.populateSimpleType(((CustomDatatype)d).getBase(), sm, (SchemaComponent)gst, pc);
                } else {
                    SchemaGeneratorUtil.populateSimpleType(d, sm, (SchemaComponent)gst, pc);
                }
                ref = sc.createReferenceTo((ReferenceableSchemaComponent)gst, GlobalSimpleType.class);
            }
            SchemaGeneratorUtil.setSimpleType(sc, ref);
        }
    }

    protected GlobalType createPeerGlobalComplexType(Element element) {
        org.netbeans.modules.xml.schema.model.Element e = (org.netbeans.modules.xml.schema.model.Element)element.getPeer();
        if (e instanceof ElementReference) {
            e = (GlobalElement)this.getRef((SchemaComponent)e);
        }
        GlobalComplexType gct = this.createGlobalComplexType(element.getName() + "Type");
        assert (gct != null);
        this.sgh.addComplexType(gct, -1);
        SchemaGeneratorUtil.setType(e, gct);
        return gct;
    }

    protected void prepareFixGlobalElementNames(Element element, GlobalElement e, ElementReference eref) {
        ArrayList<Element> scs = new ArrayList<Element>();
        scs.add(element);
        scs.add((Element)e);
        scs.add((Element)eref);
        this.fixNamesMap.put(this.fgeCount++, scs);
    }

    protected void fixGlobalElementNames() {
        this.namesMap.clear();
        HashMap erefMap = new HashMap();
        for (Map.Entry<Integer, List<Object>> e : this.fixNamesMap.entrySet()) {
            List<Object> scs = e.getValue();
            if (scs == null || scs.size() <= 1) continue;
            GlobalElement ge = (GlobalElement)scs.get(1);
            ElementReference eref = (ElementReference)scs.get(2);
            ArrayList<ElementReference> erefs = (ArrayList<ElementReference>)erefMap.get(ge);
            if (erefs == null) {
                erefs = new ArrayList<ElementReference>();
                erefMap.put(ge, erefs);
            }
            if (eref == null || erefs.contains(eref)) continue;
            erefs.add(eref);
        }
        int count = 0;
        Iterator it = erefMap.keySet().iterator();
        while (it.hasNext()) {
            if (commitRange > 0 && count++ % commitRange == 0) {
                this.sm.endTransaction();
                this.sm.startTransaction();
            }
            GlobalElement ge = (GlobalElement)it.next();
            List erefs = (List)erefMap.get(ge);
            String name = this.findUniqueGlobalName(GlobalElement.class, (NameableSchemaComponent)ge, ge.getName());
            ge.setName(name);
            for (ElementReference eref : erefs) {
                eref.setRef(eref.createReferenceTo((ReferenceableSchemaComponent)ge, GlobalElement.class));
            }
        }
        erefMap.clear();
        erefMap = null;
        this.fixNamesMap.clear();
    }

    <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> type, NameableSchemaComponent c, String seed) {
        return this.sgh.findUniqueGlobalName(type, c, seed);
    }

    protected SchemaComponent getParent(AXIComponent axiparent) throws IllegalArgumentException {
        return this.sgh.getParent(axiparent);
    }

    protected void setPeer(Element element, org.netbeans.modules.xml.schema.model.Element e, ElementReference eref) {
        this.sgh.setPeer(element, e, eref);
    }

    protected void setPeer(Attribute attribute, org.netbeans.modules.xml.schema.model.Attribute a, AttributeReference aRef) {
        this.sgh.setPeer(attribute, a, aRef);
    }

    private SchemaGenerator.UniqueId createUniqueId() {
        return new SchemaGenerator.UniqueId(){
            private int lastId = -1;

            @Override
            public int nextId() {
                return ++this.lastId;
            }
        };
    }

    private SchemaGenerator.PrimitiveCart createPrimitiveCart() {
        return new SchemaGenerator.PrimitiveCart(){
            private Map<SchemaComponent, Datatype> pc = new HashMap<SchemaComponent, Datatype>();
            private Map<String, GlobalSimpleType> ptypes = new HashMap<String, GlobalSimpleType>();
            private GlobalSimpleType def = null;

            @Override
            public void add(Datatype d, SchemaComponent referer) {
                this.pc.put(referer, d);
            }

            @Override
            public Set<Map.Entry<SchemaComponent, Datatype>> getEntries() {
                return this.pc.entrySet();
            }

            @Override
            public GlobalSimpleType getDefaultPrimitive() {
                if (this.def == null) {
                    this.def = this.getPrimitiveType("string");
                }
                return this.def;
            }

            @Override
            public GlobalSimpleType getPrimitiveType(String typeName) {
                if (this.ptypes.isEmpty()) {
                    SchemaModel primitiveModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
                    Collection primitives = primitiveModel.getSchema().getSimpleTypes();
                    for (GlobalSimpleType ptype : primitives) {
                        this.ptypes.put(ptype.getName(), ptype);
                    }
                }
                return this.ptypes.get(typeName);
            }
        };
    }

    protected void addRef(SchemaComponent referer, SchemaComponent ref) {
        this.sgh.addRef(referer, ref);
    }

    protected SchemaComponent getRef(SchemaComponent referer) {
        return this.sgh.getRef(referer);
    }

    protected void addToGlobal(SchemaComponent sc) {
        this.createGlobals.add(sc);
    }

    private void fixPrimitiveTypes() {
        for (Map.Entry<SchemaComponent, Datatype> e : this.pc.getEntries()) {
            Datatype d = e.getValue();
            SchemaComponent referer = e.getKey();
            String typeName = d.getName();
            if (d instanceof CustomDatatype) {
                typeName = ((CustomDatatype)d).getBase().getName();
            }
            GlobalSimpleType gst = this.pc.getPrimitiveType(typeName);
            NamedComponentReference ref = referer.createReferenceTo((ReferenceableSchemaComponent)gst, GlobalSimpleType.class);
            SchemaGeneratorUtil.setSimpleType(referer, (NamedComponentReference<GlobalSimpleType>)ref);
        }
    }

    protected void clear() {
        this.path.clear();
        this.path = null;
        this.createGlobals.clear();
        this.createGlobals = null;
        this.fixNamesMap.clear();
        this.fixNamesMap = null;
        this.refMap.clear();
        this.refMap = null;
        this.namesMap.clear();
        this.namesMap = null;
    }

    class TransformHelper
    implements SchemaGeneratorHelper {
        TransformHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(SchemaModel sm) throws IOException {
            DefaultSchemaGenerator.this.sm = sm;
            DefaultSchemaGenerator.this.am = AXIModelFactory.getDefault().getModel(sm);
            Schema schema = sm.getSchema();
            assert (schema != null);
            try {
                HashMap<Class, Map<String, SchemaComponent>> allGlobals = new HashMap<Class, Map<String, SchemaComponent>>();
                List<Element> lrges = this.preTransform(schema, allGlobals);
                ((AXIModelImpl)DefaultSchemaGenerator.this.am).disableAutoSync();
                sm.startTransaction();
                for (Element element : lrges) {
                    ArrayList<AXIComponent> pathFromRoot = new ArrayList<AXIComponent>();
                    pathFromRoot.add(element);
                    this.transformChildren(element, (SchemaComponent)schema, pathFromRoot);
                }
                this.postTransform(schema, allGlobals);
            }
            finally {
                this.clear();
                try {
                    sm.endTransaction();
                }
                finally {
                    ((AXIModelImpl)DefaultSchemaGenerator.this.am).enableAutoSync();
                    DefaultSchemaGenerator.this.am.sync();
                }
            }
        }

        @Override
        public SchemaComponent getParent(AXIComponent axiparent) throws IllegalArgumentException {
            throw new IllegalArgumentException("should not call this api during transform");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void transformChildren(AXIComponent component, SchemaComponent parent, List<AXIComponent> pathFromRoot) {
            if (!SchemaGeneratorUtil.fromSameSchemaModel(component.getPeer(), DefaultSchemaGenerator.this.sm)) {
                return;
            }
            assert (parent != null);
            DefaultSchemaGenerator.this.scParent = parent;
            component.accept(DefaultSchemaGenerator.this);
            if (DefaultSchemaGenerator.this.elementReuseList.contains(component)) {
                return;
            }
            SchemaComponent cc = DefaultSchemaGenerator.this.sc;
            if (component instanceof Element) {
                Element orig = (Element)component;
                if (orig.isReference()) {
                    orig = SchemaGeneratorUtil.findOriginalElement(orig);
                }
                if (DefaultSchemaGenerator.this.path.size() > 0 && DefaultSchemaGenerator.this.path.contains(orig)) {
                    return;
                }
                DefaultSchemaGenerator.this.path.add(orig);
            }
            try {
                if (component.getChildren().size() > 0) {
                    parent = DefaultSchemaGenerator.this.scParent;
                }
                assert (parent != null);
                if (component instanceof AbstractElement) {
                    for (AbstractAttribute attr : ((AbstractElement)component).getAttributes()) {
                        if (!SchemaGeneratorUtil.fromSameSchemaModel(attr.getPeer(), DefaultSchemaGenerator.this.sm)) continue;
                        DefaultSchemaGenerator.this.scParent = parent;
                        attr.accept(DefaultSchemaGenerator.this);
                    }
                }
                for (AXIComponent child : component.getChildren()) {
                    if (child instanceof AbstractAttribute || pathFromRoot.contains(child.getOriginal())) continue;
                    pathFromRoot.add(child.getOriginal());
                    this.transformChildren(child, parent, pathFromRoot);
                }
            }
            finally {
                if (component instanceof Element) {
                    DefaultSchemaGenerator.this.path.remove(DefaultSchemaGenerator.this.path.size() - 1);
                }
            }
        }

        protected List<Element> preTransform(Schema schema, Map<Class, Map<String, SchemaComponent>> allGlobals) {
            List<Element> lrges = SchemaGeneratorUtil.findMasterGlobalElements(DefaultSchemaGenerator.this.am);
            AXINonCyclicVisitor visitor = new AXINonCyclicVisitor(DefaultSchemaGenerator.this.am);
            visitor.expand(lrges);
            TreeMap<String, GlobalGroup> ggmap = new TreeMap<String, GlobalGroup>();
            allGlobals.put(GlobalGroup.class, ggmap);
            for (Object ag : schema.getGroups()) {
                ggmap.put(ag.getName(), (GlobalGroup)ag);
            }
            TreeMap<String, GlobalComplexType> gctmap = new TreeMap<String, GlobalComplexType>();
            allGlobals.put(GlobalComplexType.class, gctmap);
            for (Object gct : schema.getComplexTypes()) {
                gctmap.put(gct.getName(), (GlobalComplexType)gct);
            }
            TreeMap<String, GlobalAttributeGroup> gagmap = new TreeMap<String, GlobalAttributeGroup>();
            allGlobals.put(GlobalAttributeGroup.class, gagmap);
            for (Object ag : schema.getAttributeGroups()) {
                gagmap.put(ag.getName(), (GlobalAttributeGroup)ag);
            }
            TreeMap<String, GlobalType> gstmap = new TreeMap<String, GlobalType>();
            allGlobals.put(GlobalSimpleType.class, gstmap);
            for (Object gst : schema.getSimpleTypes()) {
                gstmap.put(gst.getName(), (GlobalType)gst);
            }
            TreeMap<String, GlobalElement> gemap = new TreeMap<String, GlobalElement>();
            allGlobals.put(GlobalElement.class, gemap);
            for (GlobalElement ge : schema.getElements()) {
                gemap.put(ge.getName(), ge);
            }
            TreeMap<String, GlobalAttribute> gamap = new TreeMap<String, GlobalAttribute>();
            allGlobals.put(GlobalAttribute.class, gamap);
            for (GlobalAttribute ga : schema.getAttributes()) {
                gamap.put(ga.getName(), ga);
            }
            return lrges;
        }

        protected void postTransform(Schema schema, HashMap<Class, Map<String, SchemaComponent>> allGlobals) {
            this.removeAllGlobals(schema, allGlobals);
            this.addAllGlobals(schema, DefaultSchemaGenerator.this.createGlobals);
            DefaultSchemaGenerator.this.fixGlobalElementNames();
            DefaultSchemaGenerator.this.fixPrimitiveTypes();
        }

        private void removeAllGlobals(Schema schema, HashMap<Class, Map<String, SchemaComponent>> allGlobals) {
            this.removeGlobalSchemaComponent(GlobalSimpleType.class, allGlobals, schema);
            this.removeGlobalSchemaComponent(GlobalAttribute.class, allGlobals, schema);
            this.removeGlobalSchemaComponent(GlobalAttributeGroup.class, allGlobals, schema);
            this.removeGlobalSchemaComponent(GlobalComplexType.class, allGlobals, schema);
            this.removeGlobalSchemaComponent(GlobalGroup.class, allGlobals, schema);
            this.removeGlobalSchemaComponent(GlobalElement.class, allGlobals, schema);
        }

        private void removeGlobalSchemaComponent(Class type, HashMap<Class, Map<String, SchemaComponent>> allGlobals, Schema schema) {
            Map<String, SchemaComponent> gmap = allGlobals.get(type);
            if (gmap == null) {
                return;
            }
            int count = 0;
            for (Map.Entry<String, SchemaComponent> entry : gmap.entrySet()) {
                SchemaComponent sc = entry.getValue();
                this.commitTransaction(count);
                if (sc instanceof GlobalSimpleType) {
                    schema.removeSimpleType((GlobalSimpleType)sc);
                    continue;
                }
                if (sc instanceof GlobalAttribute) {
                    schema.removeAttribute((GlobalAttribute)sc);
                    continue;
                }
                if (sc instanceof GlobalAttributeGroup) {
                    schema.removeAttributeGroup((GlobalAttributeGroup)sc);
                    continue;
                }
                if (sc instanceof GlobalComplexType) {
                    schema.removeComplexType((GlobalComplexType)sc);
                    continue;
                }
                if (sc instanceof GlobalGroup) {
                    schema.removeGroup((GlobalGroup)sc);
                    continue;
                }
                if (!(sc instanceof GlobalElement)) continue;
                schema.removeElement((GlobalElement)sc);
            }
        }

        private void commitTransaction(int count) {
            if (commitRange > 0 && count++ % commitRange == 0) {
                DefaultSchemaGenerator.this.sm.endTransaction();
                DefaultSchemaGenerator.this.sm.startTransaction();
            }
        }

        @Override
        public <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> type, NameableSchemaComponent c, String seed) {
            HashMap<String, Object> map = DefaultSchemaGenerator.this.namesMap.get(type);
            if (map == null) {
                map = new HashMap();
                DefaultSchemaGenerator.this.namesMap.put(type, map);
            }
            int count = 0;
            boolean found = true;
            while (found) {
                found = false;
                SchemaComponent sc = (SchemaComponent)map.get(count > 0 ? seed + String.valueOf(count) : seed);
                if (sc == null) continue;
                ++count;
                found = true;
            }
            String uniqueName = count > 0 ? seed + String.valueOf(count) : seed;
            map.put(uniqueName, c);
            return uniqueName;
        }

        @Override
        public void setPeer(Element element, org.netbeans.modules.xml.schema.model.Element e, ElementReference eref) {
            if (element.getChildren().size() > 0) {
                LocalType lct = SchemaGeneratorUtil.getLocalComplexType((SchemaComponent)e);
                if (lct == null) {
                    lct = SchemaGeneratorUtil.findTypeFromOtherModel(e, element, DefaultSchemaGenerator.this.sm);
                    if (lct == null) {
                        lct = SchemaGeneratorUtil.createLocalComplexType(DefaultSchemaGenerator.this.sm, (SchemaComponent)e);
                    }
                    assert (lct != null);
                    DefaultSchemaGenerator.this.scParent = lct;
                }
            } else {
                DefaultSchemaGenerator.this.scParent = e;
            }
        }

        @Override
        public void setPeer(Attribute attribute, org.netbeans.modules.xml.schema.model.Attribute a, AttributeReference aref) {
        }

        @Override
        public void addElement(GlobalElement ge, int index) {
            DefaultSchemaGenerator.this.addToGlobal((SchemaComponent)ge);
        }

        @Override
        public void addComplexType(GlobalComplexType gct, int index) {
            DefaultSchemaGenerator.this.addToGlobal((SchemaComponent)gct);
        }

        @Override
        public void addSimpleType(GlobalSimpleType gst, int index) {
            DefaultSchemaGenerator.this.addToGlobal((SchemaComponent)gst);
        }

        protected void addAllGlobals(Schema schema, List<SchemaComponent> createGlobals) {
            for (int i = 0; i < createGlobals.size(); ++i) {
                SchemaComponent sc = createGlobals.get(i);
                if (commitRange > 0 && i % commitRange == 0) {
                    DefaultSchemaGenerator.this.sm.endTransaction();
                    DefaultSchemaGenerator.this.sm.startTransaction();
                }
                if (sc instanceof GlobalElement) {
                    DefaultSchemaGenerator.this.sm.getSchema().addElement((GlobalElement)sc);
                } else if (sc instanceof GlobalComplexType) {
                    DefaultSchemaGenerator.this.sm.getSchema().addComplexType((GlobalComplexType)sc);
                }
                if (sc instanceof GlobalSimpleType) {
                    DefaultSchemaGenerator.this.sm.getSchema().addSimpleType((GlobalSimpleType)sc);
                    continue;
                }
                if (sc instanceof GlobalGroup) {
                    DefaultSchemaGenerator.this.sm.getSchema().addGroup((GlobalGroup)sc);
                    continue;
                }
                if (!(sc instanceof GlobalAttributeGroup)) continue;
                DefaultSchemaGenerator.this.sm.getSchema().addAttributeGroup((GlobalAttributeGroup)sc);
            }
        }

        @Override
        public void addRef(SchemaComponent referer, SchemaComponent ref) {
            DefaultSchemaGenerator.this.refMap.put(referer, ref);
        }

        @Override
        public SchemaComponent getRef(SchemaComponent referer) {
            return DefaultSchemaGenerator.this.refMap.get(referer);
        }

        protected void clear() {
            DefaultSchemaGenerator.this.clear();
        }
    }

    class UpdateHelper
    implements SchemaGeneratorHelper {
        UpdateHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(SchemaModel sm) throws IOException {
            DefaultSchemaGenerator.this.sm = sm;
            DefaultSchemaGenerator.this.am = AXIModelFactory.getDefault().getModel(sm);
            SchemaUpdate su = SchemaGeneratorUtil.getSchemaUpdate(DefaultSchemaGenerator.this.am);
            Collection<SchemaUpdate.UpdateUnit> us = su.getUpdateUnits();
            try {
                ((AXIModelImpl)DefaultSchemaGenerator.this.am).disableAutoSync();
                sm.startTransaction();
                for (SchemaUpdate.UpdateUnit u : us) {
                    AXIComponent source = u.getSource();
                    if (source.getModel() != DefaultSchemaGenerator.this.am) continue;
                    SchemaUpdate.UpdateUnit.Type type = u.getType();
                    if (type == SchemaUpdate.UpdateUnit.Type.CHILD_ADDED) {
                        this.addSchemaComponent(source, u);
                        continue;
                    }
                    if (type == SchemaUpdate.UpdateUnit.Type.CHILD_DELETED) {
                        SchemaGeneratorUtil.removeSchemaComponent(source, u, sm);
                        continue;
                    }
                    if (type != SchemaUpdate.UpdateUnit.Type.CHILD_MODIFIED) continue;
                    SchemaGeneratorUtil.modifySchemaComponent(source, u, sm, DefaultSchemaGenerator.this.pc);
                }
            }
            finally {
                this.clear();
                sm.endTransaction();
                ((AXIModelImpl)DefaultSchemaGenerator.this.am).enableAutoSync();
            }
        }

        protected void addSchemaComponent(AXIComponent source, SchemaUpdate.UpdateUnit u) {
            assert (u.getNewValue() != null);
            DefaultSchemaGenerator.this.scParent = DefaultSchemaGenerator.this.getParent((AXIComponent)((AXIComponent)u.getNewValue()).getParent());
            assert (DefaultSchemaGenerator.this.scParent != null);
            ((AXIComponent)u.getNewValue()).accept(DefaultSchemaGenerator.this);
        }

        @Override
        public <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> type, NameableSchemaComponent c, String seed) {
            return SchemaGeneratorUtil.findUniqueGlobalName(type, seed, DefaultSchemaGenerator.this.sm);
        }

        @Override
        public SchemaComponent getParent(AXIComponent axiparent) throws IllegalArgumentException {
            Schema scParent = null;
            if (axiparent instanceof AXIDocument) {
                scParent = DefaultSchemaGenerator.this.sm.getSchema();
            } else if (axiparent instanceof Element) {
                SchemaComponent e = axiparent.getPeer();
                if (e instanceof ElementReference) {
                    e = this.getRef(axiparent.getPeer());
                }
                assert (e != null);
                LocalType lct = SchemaGeneratorUtil.getLocalComplexType(e);
                if (lct == null && (lct = SchemaGeneratorUtil.getGlobalComplexType(e)) == null) {
                    if (e instanceof GlobalElement && ((GlobalElement)e).getType() != null && ((GlobalElement)e).getType().get() instanceof GlobalSimpleType || e instanceof LocalElement && ((LocalElement)e).getType() != null && ((LocalElement)e).getType().get() instanceof GlobalSimpleType) {
                        SimpleContent newsc = DefaultSchemaGenerator.this.sm.getFactory().createSimpleContent();
                        SimpleExtension se = DefaultSchemaGenerator.this.sm.getFactory().createSimpleExtension();
                        newsc.setLocalDefinition((SimpleContentDefinition)se);
                        GlobalType gst = null;
                        if (e instanceof GlobalElement) {
                            gst = (GlobalType)((GlobalElement)e).getType().get();
                        } else if (e instanceof LocalElement) {
                            gst = (GlobalType)((LocalElement)e).getType().get();
                        }
                        if (gst != null) {
                            se.setBase(se.createReferenceTo((ReferenceableSchemaComponent)gst, GlobalType.class));
                        }
                        lct = SchemaGeneratorUtil.createLocalComplexType(DefaultSchemaGenerator.this.sm, e);
                        ((LocalComplexType)lct).setDefinition((ComplexTypeDefinition)newsc);
                    } else {
                        lct = SchemaGeneratorUtil.createLocalComplexType(DefaultSchemaGenerator.this.sm, e);
                    }
                }
                assert (lct != null);
                scParent = lct;
            } else if (axiparent instanceof ContentModel) {
                scParent = axiparent.getPeer();
            } else if (axiparent instanceof Compositor) {
                scParent = axiparent.getPeer();
            }
            return scParent;
        }

        @Override
        public void setPeer(Element element, org.netbeans.modules.xml.schema.model.Element e, ElementReference eref) {
            if (eref != null) {
                element.setPeer((SchemaComponent)eref);
            } else {
                element.setPeer((SchemaComponent)e);
            }
        }

        @Override
        public void setPeer(Attribute attribute, org.netbeans.modules.xml.schema.model.Attribute a, AttributeReference aRef) {
            if (aRef != null) {
                attribute.setPeer((SchemaComponent)aRef);
            } else {
                attribute.setPeer((SchemaComponent)a);
            }
        }

        @Override
        public void addElement(GlobalElement ge, int index) {
            if (index != -1) {
                SchemaGeneratorUtil.addChildComponent(DefaultSchemaGenerator.this.sm, (SchemaComponent)DefaultSchemaGenerator.this.sm.getSchema(), (SchemaComponent)ge, index);
            } else {
                DefaultSchemaGenerator.this.sm.getSchema().addElement(ge);
            }
        }

        @Override
        public void addComplexType(GlobalComplexType gct, int index) {
            if (index != -1) {
                SchemaGeneratorUtil.addChildComponent(DefaultSchemaGenerator.this.sm, (SchemaComponent)DefaultSchemaGenerator.this.sm.getSchema(), (SchemaComponent)gct, index);
            } else {
                DefaultSchemaGenerator.this.sm.getSchema().addComplexType(gct);
            }
        }

        @Override
        public void addSimpleType(GlobalSimpleType gst, int index) {
            if (index != -1) {
                SchemaGeneratorUtil.addChildComponent(DefaultSchemaGenerator.this.sm, (SchemaComponent)DefaultSchemaGenerator.this.sm.getSchema(), (SchemaComponent)gst, index);
            } else {
                DefaultSchemaGenerator.this.sm.getSchema().addSimpleType(gst);
            }
        }

        @Override
        public void addRef(SchemaComponent referer, SchemaComponent ref) {
        }

        @Override
        public SchemaComponent getRef(SchemaComponent referer) {
            if (referer instanceof ElementReference) {
                return (SchemaComponent)((ElementReference)referer).getRef().get();
            }
            if (referer instanceof org.netbeans.modules.xml.schema.model.Element) {
                if (referer instanceof GlobalElement && ((GlobalElement)referer).getType() != null && ((GlobalElement)referer).getType().get() instanceof GlobalComplexType) {
                    return (SchemaComponent)((GlobalElement)referer).getType().get();
                }
                if (referer instanceof LocalElement && ((LocalElement)referer).getType() != null && ((LocalElement)referer).getType().get() instanceof GlobalComplexType) {
                    return (SchemaComponent)((LocalElement)referer).getType().get();
                }
            }
            return null;
        }

        protected void clear() {
            DefaultSchemaGenerator.this.clear();
        }
    }

    static interface SchemaGeneratorHelper {
        public void execute(SchemaModel var1) throws IOException;

        public SchemaComponent getParent(AXIComponent var1) throws IllegalArgumentException;

        public <T extends NameableSchemaComponent> String findUniqueGlobalName(Class<T> var1, NameableSchemaComponent var2, String var3);

        public void setPeer(Element var1, org.netbeans.modules.xml.schema.model.Element var2, ElementReference var3);

        public void setPeer(Attribute var1, org.netbeans.modules.xml.schema.model.Attribute var2, AttributeReference var3);

        public void addRef(SchemaComponent var1, SchemaComponent var2);

        public SchemaComponent getRef(SchemaComponent var1);

        public void addElement(GlobalElement var1, int var2);

        public void addComplexType(GlobalComplexType var1, int var2);

        public void addSimpleType(GlobalSimpleType var1, int var2);
    }
}

