/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.xml.axi.AXIComponentFactory;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.AXIDocumentImpl;
import org.netbeans.modules.xml.axi.impl.AXIModelBuilder;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.Util;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.schema.model.Documentation;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.openide.util.WeakListeners;

public abstract class AXIComponent
extends AbstractComponent<AXIComponent>
implements Cloneable,
PropertyChangeListener {
    private SchemaComponent peer;
    protected AXIComponent sharedComponent;
    private PropertyChangeSupport pcs;
    private WeakHashMap<AXIComponent, PropertyChangeListener> listenerMap;
    private static final String PROP_CHILD_ADDED = "child_added";
    private static final String PROP_CHILD_REMOVED = "child_removed";

    public AXIComponent(AXIModel model) {
        super((AbstractModel)model);
    }

    public AXIComponent(AXIModel model, SchemaComponent schemaComponent) {
        super((AbstractModel)model);
        this.setPeer(schemaComponent);
    }

    public AXIComponent(AXIModel model, AXIComponent sharedComponent) {
        super((AbstractModel)model);
        this.setSharedComponent(sharedComponent);
    }

    public abstract void accept(AXIVisitor var1);

    public int getIndex() {
        return this.getIndex(true);
    }

    public int getIndex(boolean absolute) {
        AXIComponent parent = (AXIComponent)this.getParent();
        if (parent == null || !this.isInModel()) {
            return -1;
        }
        List childs = Collections.emptyList();
        childs = absolute ? parent.getChildren() : parent.getChildren(this.getClass());
        for (int i = 0; i < childs.size(); ++i) {
            if (childs.get(i) != this) continue;
            return i;
        }
        return -1;
    }

    public AXIComponent getOriginal() {
        if (this.getComponentType() == ComponentType.REFERENCE) {
            return this;
        }
        if (this.getComponentType() == ComponentType.PROXY) {
            return this.getSharedComponent().getOriginal();
        }
        return this;
    }

    public AXIComponent getSharedComponent() {
        return this.sharedComponent;
    }

    public boolean isGlobal() {
        return this.getParent() instanceof AXIDocument;
    }

    protected void setSharedComponent(AXIComponent sharedComponent) {
        this.sharedComponent = sharedComponent;
        if (sharedComponent == null) {
            return;
        }
        AXIModelImpl thisModel = (AXIModelImpl)this.getModel();
        if (thisModel == sharedComponent.getModel()) {
            sharedComponent.addListener(this);
            return;
        }
        thisModel.listenToReferencedModel(sharedComponent.getModel());
    }

    public void addListener(AXIComponent proxy) {
        PropertyChangeListener l;
        if (this.getModel() != proxy.getModel()) {
            return;
        }
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        if ((l = this.getWeakListener(proxy, false)) != null) {
            this.pcs.addPropertyChangeListener(l);
        }
    }

    public void removeListener(AXIComponent proxy) {
        if (this.pcs == null) {
            return;
        }
        this.pcs.removePropertyChangeListener(this.getWeakListener(proxy, true));
    }

    private void removeAllListeners() {
        if (this.pcs == null) {
            return;
        }
        for (AXIComponent listener : this.getRefSet()) {
            this.removeListener(listener);
        }
    }

    public List<AXIComponent> getRefSet() {
        if (this.pcs == null || this.listenerMap == null) {
            return null;
        }
        Set<AXIComponent> keySet = this.listenerMap.keySet();
        return Collections.unmodifiableList(Arrays.asList(keySet.toArray(new AXIComponent[keySet.size()])));
    }

    private PropertyChangeListener getWeakListener(AXIComponent proxy, boolean remove) {
        PropertyChangeListener listener;
        if (this.listenerMap == null) {
            this.listenerMap = new WeakHashMap();
        }
        if (remove) {
            return this.listenerMap.remove(proxy);
        }
        if (proxy.getComponentType() != ComponentType.PROXY) {
            Set<AXIComponent> keySet = this.listenerMap.keySet();
            for (AXIComponent key : keySet) {
                if (key.getPeer() != proxy.getPeer()) continue;
                return null;
            }
        }
        if ((listener = this.listenerMap.get(proxy)) == null) {
            listener = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)proxy, (Object)this);
            this.listenerMap.put(proxy, listener);
            return listener;
        }
        return null;
    }

    public String getDocumentation() {
        if (this.getPeer() == null || this.getPeer().getAnnotation() == null || this.getPeer().getAnnotation().getDocumentationElements() == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (Documentation doc : this.getPeer().getAnnotation().getDocumentationElements()) {
            buffer.append(doc.getContent());
        }
        return buffer.toString();
    }

    public boolean isReadOnly() {
        if (!this.isInModel()) {
            return false;
        }
        return this.getModel().isReadOnly() || this.getModel() != this.getOriginal().getModel();
    }

    public boolean supportsCardinality() {
        return !(this.getParent() instanceof AXIDocument);
    }

    public boolean canVisitChildren() {
        return super.isChildrenInitialized();
    }

    public boolean isShared() {
        ComponentType type = this.getComponentType();
        return type == ComponentType.PROXY || type == ComponentType.REFERENCE;
    }

    public ComponentType getComponentType() {
        if (this.getParent() instanceof AXIDocument) {
            return ComponentType.SHARED;
        }
        return ComponentType.LOCAL;
    }

    public ContentModel getContentModel() {
        if (this.getComponentType() == ComponentType.PROXY) {
            return this.getOriginal().getContentModel();
        }
        if (this instanceof ContentModel) {
            return (ContentModel)this;
        }
        AXIComponent parent = (AXIComponent)this.getParent();
        if (parent == null || parent instanceof AXIDocument || parent instanceof Element) {
            return null;
        }
        return parent.getContentModel();
    }

    public String getTargetNamespace() {
        if (this.getComponentType() == ComponentType.PROXY) {
            return this.getOriginal().getTargetNamespace();
        }
        SchemaComponent peer = this.getPeer();
        return peer.getModel().getEffectiveNamespace(peer);
    }

    public AXIModel getModel() {
        return (AXIModel)super.getModel();
    }

    public Element getParentElement() {
        AXIComponent parent = (AXIComponent)this.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Element) {
            return (Element)parent;
        }
        return parent.getParentElement();
    }

    public List<AbstractElement> getChildElements() {
        ArrayList<AbstractElement> childrenElements = new ArrayList<AbstractElement>();
        this.populateChildElements(childrenElements, this);
        return Collections.unmodifiableList(childrenElements);
    }

    private void populateChildElements(List<AbstractElement> childrenElements, AXIComponent component) {
        for (AXIComponent child : component.getChildren()) {
            if (child instanceof ContentModel) continue;
            if (child instanceof AbstractElement) {
                childrenElements.add((AbstractElement)child);
                continue;
            }
            this.populateChildElements(childrenElements, child);
        }
    }

    public final SchemaComponent getPeer() {
        if (this.getComponentType() == ComponentType.REFERENCE) {
            return this.peer;
        }
        if (this.getSharedComponent() != null) {
            return this.getSharedComponent().getPeer();
        }
        return this.peer;
    }

    public final void setPeer(SchemaComponent peer) {
        if (this.getComponentType() == ComponentType.REFERENCE) {
            this.peer = peer;
            return;
        }
        if (this.getSharedComponent() != null) {
            this.getSharedComponent().setPeer(peer);
            return;
        }
        this.peer = peer;
    }

    protected void appendChildQuietly(AXIComponent newComponent, List<AXIComponent> children) {
        if (this.getComponentType() == ComponentType.PROXY) {
            this.getOriginal().appendChildQuietly(newComponent, children);
            return;
        }
        children.add(newComponent);
    }

    protected void insertAtIndexQuietly(AXIComponent newComponent, List<AXIComponent> children, int index) {
        if (this.getComponentType() == ComponentType.PROXY) {
            this.getOriginal().insertAtIndexQuietly(newComponent, children, index);
            return;
        }
        children.add(index, newComponent);
    }

    protected void removeChildQuietly(AXIComponent component, List<AXIComponent> children) {
        if (this.getComponentType() == ComponentType.PROXY) {
            this.getOriginal().removeChildQuietly(component, children);
            return;
        }
        children.remove(component);
    }

    public void populateChildren(List<AXIComponent> children) {
        if (this.getSharedComponent() != null) {
            Util.addProxyChildren(this, this.getSharedComponent(), children);
            return;
        }
        if (this.getPeer() == null) {
            return;
        }
        AXIModelBuilder builder = new AXIModelBuilder(this);
        builder.populateChildren(this.getPeer(), true, children);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AXIComponent copy(AXIComponent parent) {
        AXIComponentFactory f = parent.getModel().getComponentFactory();
        return f.copy(this);
    }

    protected boolean isInModel() {
        if (this instanceof AXIDocument) {
            return this.getModel() != null;
        }
        return this.getParent() != null && this.getModel() != null;
    }

    protected void firePropertyChangeEvent(String property, Object oldVal, Object newVal) {
        if (!this.isInModel()) {
            return;
        }
        this.fireValueChanged();
        if (property != null) {
            this.firePropertyChange(property, oldVal, newVal);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange(property, oldVal, newVal);
        }
    }

    protected void appendChild(String property, AXIComponent child) {
        if (this.getModel() != child.getModel()) {
            return;
        }
        super.appendChild(property, (Component)child);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_CHILD_ADDED, null, child);
        }
        if (this instanceof AXIDocumentImpl) {
            ((AXIDocumentImpl)this).addToCache(child);
        }
    }

    public void insertAtIndex(String property, AXIComponent child, int index) {
        if (this.getModel() != child.getModel()) {
            return;
        }
        super.insertAtIndex(property, (Component)child, index);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_CHILD_ADDED, null, child);
        }
        if (this instanceof AXIDocumentImpl) {
            ((AXIDocumentImpl)this).addToCache(child);
        }
    }

    public void removeChild(String property, AXIComponent child) {
        if (this.getModel() != child.getModel()) {
            return;
        }
        super.removeChild(property, (Component)child);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_CHILD_REMOVED, child, null);
            child.removeAllListeners();
        }
        if (this instanceof AXIDocumentImpl) {
            ((AXIDocumentImpl)this).removeFromCache(child);
        }
    }

    public final void appendChild(AXIComponent child) {
        if (this.getComponentType() == ComponentType.PROXY && !this.getModel().inSync()) {
            this.getOriginal().appendChild(child);
            return;
        }
        this.appendChild(Util.getProperty(child), child);
    }

    public final void addChildAtIndex(AXIComponent child, int index) {
        if (this.getComponentType() == ComponentType.PROXY && !this.getModel().inSync()) {
            this.getOriginal().addChildAtIndex(child, index);
            return;
        }
        this.insertAtIndex(Util.getProperty(child), child, index);
    }

    public final void removeChild(AXIComponent child) {
        if (child.getComponentType() == ComponentType.REFERENCE) {
            this.removeChild(Util.getProperty(child), child);
            return;
        }
        if (child.getComponentType() == ComponentType.PROXY && !this.getModel().inSync()) {
            AXIComponent oChild = child.getOriginal();
            ((AXIComponent)oChild.getParent()).removeChild(oChild);
            return;
        }
        this.removeChild(Util.getProperty(child), child);
    }

    public void removeAllChildren() {
        ArrayList<AXIComponent> removedChildren = new ArrayList<AXIComponent>();
        for (AXIComponent child : this.getChildren()) {
            removedChildren.add(child);
        }
        for (AXIComponent child : removedChildren) {
            this.removeChild(Util.getProperty(child), child);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AXIComponent source = (AXIComponent)evt.getSource();
        String property = evt.getPropertyName();
        if (!this.isInModel()) {
            source.removeListener(this);
            return;
        }
        if (PROP_CHILD_ADDED.equals(property)) {
            this.onChildAdded(evt);
            return;
        }
        if (PROP_CHILD_REMOVED.equals(property)) {
            this.onChildDeleted(evt);
            return;
        }
        this.firePropertyChangeEvent(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    private void onChildAdded(PropertyChangeEvent evt) {
        if (!this.isChildrenInitialized()) {
            return;
        }
        AXIComponent parent = (AXIComponent)evt.getSource();
        AXIComponent child = (AXIComponent)evt.getNewValue();
        int index = -1;
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            if (parent.getChildren().get(i) != child) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        AXIComponentFactory factory = this.getModel().getComponentFactory();
        AXIComponent proxy = factory.createProxy(child);
        this.insertAtIndex(Util.getProperty(child), proxy, index);
    }

    private void onChildDeleted(PropertyChangeEvent evt) {
        AXIComponent parent = (AXIComponent)evt.getSource();
        AXIComponent child = (AXIComponent)evt.getOldValue();
        if (child instanceof ContentModel) {
            this.onContentModelDeleted((ContentModel)child);
            return;
        }
        AXIComponent deletedChild = null;
        for (AXIComponent c : this.getChildren()) {
            if (c.getSharedComponent() != child) continue;
            deletedChild = c;
            break;
        }
        if (deletedChild == null) {
            return;
        }
        this.removeChild(Util.getProperty(deletedChild), deletedChild);
    }

    private void onContentModelDeleted(ContentModel contentModel) {
        ArrayList<AXIComponent> removeList = new ArrayList<AXIComponent>();
        for (AXIComponent child : this.getChildren()) {
            if (child.getContentModel() != contentModel) continue;
            removeList.add(child);
        }
        for (AXIComponent child : removeList) {
            ((AXIComponent)child.getParent()).removeChild(Util.getProperty(child), child);
        }
    }

    public static enum ComponentType {
        LOCAL,
        SHARED,
        PROXY,
        REFERENCE;

    }
}

