/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_scrollbar")
public class NkStyleScrollbar
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_ACTIVE;
    public static final int CURSOR_BORDER_COLOR;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int BORDER_CURSOR;
    public static final int ROUNDING_CURSOR;
    public static final int PADDING;
    public static final int SHOW_BUTTONS;
    public static final int INC_BUTTON;
    public static final int DEC_BUTTON;
    public static final int INC_SYMBOL;
    public static final int DEC_SYMBOL;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    public NkStyleScrollbar(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleScrollbar.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleScrollbar.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleScrollbar.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleScrollbar.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleScrollbar.nborder_color(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_normal() {
        return NkStyleScrollbar.ncursor_normal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_hover() {
        return NkStyleScrollbar.ncursor_hover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_active() {
        return NkStyleScrollbar.ncursor_active(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_border_color() {
        return NkStyleScrollbar.ncursor_border_color(this.address());
    }

    public float border() {
        return NkStyleScrollbar.nborder(this.address());
    }

    public float rounding() {
        return NkStyleScrollbar.nrounding(this.address());
    }

    public float border_cursor() {
        return NkStyleScrollbar.nborder_cursor(this.address());
    }

    public float rounding_cursor() {
        return NkStyleScrollbar.nrounding_cursor(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleScrollbar.npadding(this.address());
    }

    public int show_buttons() {
        return NkStyleScrollbar.nshow_buttons(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton inc_button() {
        return NkStyleScrollbar.ninc_button(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton dec_button() {
        return NkStyleScrollbar.ndec_button(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int inc_symbol() {
        return NkStyleScrollbar.ninc_symbol(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int dec_symbol() {
        return NkStyleScrollbar.ndec_symbol(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleScrollbar.nuserdata(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_begin")
    public NkDrawBeginCallback draw_begin() {
        return NkStyleScrollbar.ndraw_begin(this.address());
    }

    @Nullable
    @NativeType(value="nk_draw_end")
    public NkDrawEndCallback draw_end() {
        return NkStyleScrollbar.ndraw_end(this.address());
    }

    public NkStyleScrollbar normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.nnormal(this.address(), value);
        return this;
    }

    public NkStyleScrollbar normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleScrollbar hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.nhover(this.address(), value);
        return this;
    }

    public NkStyleScrollbar hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleScrollbar active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.nactive(this.address(), value);
        return this;
    }

    public NkStyleScrollbar active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleScrollbar border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleScrollbar.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleScrollbar border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleScrollbar cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_normal());
        return this;
    }

    public NkStyleScrollbar cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_hover());
        return this;
    }

    public NkStyleScrollbar cursor_active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_active());
        return this;
    }

    public NkStyleScrollbar cursor_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleScrollbar.ncursor_border_color(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_border_color());
        return this;
    }

    public NkStyleScrollbar border(float value) {
        NkStyleScrollbar.nborder(this.address(), value);
        return this;
    }

    public NkStyleScrollbar rounding(float value) {
        NkStyleScrollbar.nrounding(this.address(), value);
        return this;
    }

    public NkStyleScrollbar border_cursor(float value) {
        NkStyleScrollbar.nborder_cursor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar rounding_cursor(float value) {
        NkStyleScrollbar.nrounding_cursor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleScrollbar.npadding(this.address(), value);
        return this;
    }

    public NkStyleScrollbar padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleScrollbar show_buttons(int value) {
        NkStyleScrollbar.nshow_buttons(this.address(), value);
        return this;
    }

    public NkStyleScrollbar inc_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleScrollbar.ninc_button(this.address(), value);
        return this;
    }

    public NkStyleScrollbar inc_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.inc_button());
        return this;
    }

    public NkStyleScrollbar dec_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleScrollbar.ndec_button(this.address(), value);
        return this;
    }

    public NkStyleScrollbar dec_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.dec_button());
        return this;
    }

    public NkStyleScrollbar inc_symbol(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleScrollbar.ninc_symbol(this.address(), value);
        return this;
    }

    public NkStyleScrollbar dec_symbol(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleScrollbar.ndec_symbol(this.address(), value);
        return this;
    }

    public NkStyleScrollbar userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleScrollbar.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleScrollbar userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleScrollbar draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
        NkStyleScrollbar.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleScrollbar draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
        NkStyleScrollbar.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleScrollbar set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkStyleItem cursor_active, NkColor cursor_border_color, float border, float rounding, float border_cursor, float rounding_cursor, NkVec2 padding, int show_buttons, NkStyleButton inc_button, NkStyleButton dec_button, int inc_symbol, int dec_symbol, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_active(cursor_active);
        this.cursor_border_color(cursor_border_color);
        this.border(border);
        this.rounding(rounding);
        this.border_cursor(border_cursor);
        this.rounding_cursor(rounding_cursor);
        this.padding(padding);
        this.show_buttons(show_buttons);
        this.inc_button(inc_button);
        this.dec_button(dec_button);
        this.inc_symbol(inc_symbol);
        this.dec_symbol(dec_symbol);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleScrollbar set(NkStyleScrollbar src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleScrollbar malloc() {
        return (NkStyleScrollbar)NkStyleScrollbar.wrap(NkStyleScrollbar.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkStyleScrollbar calloc() {
        return (NkStyleScrollbar)NkStyleScrollbar.wrap(NkStyleScrollbar.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkStyleScrollbar create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkStyleScrollbar)NkStyleScrollbar.wrap(NkStyleScrollbar.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkStyleScrollbar create(long address) {
        return (NkStyleScrollbar)NkStyleScrollbar.wrap(NkStyleScrollbar.class, (long)address);
    }

    @Nullable
    public static NkStyleScrollbar createSafe(long address) {
        return address == 0L ? null : (NkStyleScrollbar)NkStyleScrollbar.wrap(NkStyleScrollbar.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkStyleScrollbar.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkStyleScrollbar.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkStyleScrollbar.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleScrollbar.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkStyleScrollbar.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkStyleScrollbar.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkStyleScrollbar.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkStyleScrollbar mallocStack() {
        return NkStyleScrollbar.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleScrollbar callocStack() {
        return NkStyleScrollbar.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleScrollbar mallocStack(MemoryStack stack) {
        return NkStyleScrollbar.malloc(stack);
    }

    @Deprecated
    public static NkStyleScrollbar callocStack(MemoryStack stack) {
        return NkStyleScrollbar.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleScrollbar.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleScrollbar.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleScrollbar.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleScrollbar.calloc(capacity, stack);
    }

    public static NkStyleScrollbar malloc(MemoryStack stack) {
        return (NkStyleScrollbar)NkStyleScrollbar.wrap(NkStyleScrollbar.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleScrollbar calloc(MemoryStack stack) {
        return (NkStyleScrollbar)NkStyleScrollbar.wrap(NkStyleScrollbar.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleScrollbar.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleScrollbar.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkStyleItem ncursor_active(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_ACTIVE);
    }

    public static NkColor ncursor_border_color(long struct) {
        return NkColor.create(struct + (long)CURSOR_BORDER_COLOR);
    }

    public static float nborder(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROUNDING);
    }

    public static float nborder_cursor(long struct) {
        return UNSAFE.getFloat(null, struct + (long)BORDER_CURSOR);
    }

    public static float nrounding_cursor(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ROUNDING_CURSOR);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static int nshow_buttons(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHOW_BUTTONS);
    }

    public static NkStyleButton ninc_button(long struct) {
        return NkStyleButton.create(struct + (long)INC_BUTTON);
    }

    public static NkStyleButton ndec_button(long struct) {
        return NkStyleButton.create(struct + (long)DEC_BUTTON);
    }

    public static int ninc_symbol(long struct) {
        return UNSAFE.getInt(null, struct + (long)INC_SYMBOL);
    }

    public static int ndec_symbol(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEC_SYMBOL);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    @Nullable
    public static NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_BEGIN)));
    }

    @Nullable
    public static NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_END)));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROUNDING, value);
    }

    public static void nborder_cursor(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDER_CURSOR, value);
    }

    public static void nrounding_cursor(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ROUNDING_CURSOR, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    public static void nshow_buttons(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHOW_BUTTONS, value);
    }

    public static void ninc_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INC_BUTTON), (long)NkStyleButton.SIZEOF);
    }

    public static void ndec_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEC_BUTTON), (long)NkStyleButton.SIZEOF);
    }

    public static void ninc_symbol(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INC_SYMBOL, value);
    }

    public static void ndec_symbol(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEC_SYMBOL, value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_BEGIN), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_END), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkStyleScrollbar.__struct((Struct.Member[])new Struct.Member[]{NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)NkStyleButton.SIZEOF, (int)NkStyleButton.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleButton.SIZEOF, (int)NkStyleButton.ALIGNOF), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkStyleScrollbar.__member((int)POINTER_SIZE), NkStyleScrollbar.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        CURSOR_NORMAL = layout.offsetof(4);
        CURSOR_HOVER = layout.offsetof(5);
        CURSOR_ACTIVE = layout.offsetof(6);
        CURSOR_BORDER_COLOR = layout.offsetof(7);
        BORDER = layout.offsetof(8);
        ROUNDING = layout.offsetof(9);
        BORDER_CURSOR = layout.offsetof(10);
        ROUNDING_CURSOR = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        SHOW_BUTTONS = layout.offsetof(13);
        INC_BUTTON = layout.offsetof(14);
        DEC_BUTTON = layout.offsetof(15);
        INC_SYMBOL = layout.offsetof(16);
        DEC_SYMBOL = layout.offsetof(17);
        USERDATA = layout.offsetof(18);
        DRAW_BEGIN = layout.offsetof(19);
        DRAW_END = layout.offsetof(20);
    }

    public static class Buffer
    extends StructBuffer<NkStyleScrollbar, Buffer>
    implements NativeResource {
        private static final NkStyleScrollbar ELEMENT_FACTORY = NkStyleScrollbar.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleScrollbar getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleScrollbar.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleScrollbar.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleScrollbar.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleScrollbar.nborder_color(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_normal() {
            return NkStyleScrollbar.ncursor_normal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_hover() {
            return NkStyleScrollbar.ncursor_hover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_active() {
            return NkStyleScrollbar.ncursor_active(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_border_color() {
            return NkStyleScrollbar.ncursor_border_color(this.address());
        }

        public float border() {
            return NkStyleScrollbar.nborder(this.address());
        }

        public float rounding() {
            return NkStyleScrollbar.nrounding(this.address());
        }

        public float border_cursor() {
            return NkStyleScrollbar.nborder_cursor(this.address());
        }

        public float rounding_cursor() {
            return NkStyleScrollbar.nrounding_cursor(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleScrollbar.npadding(this.address());
        }

        public int show_buttons() {
            return NkStyleScrollbar.nshow_buttons(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton inc_button() {
            return NkStyleScrollbar.ninc_button(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton dec_button() {
            return NkStyleScrollbar.ndec_button(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int inc_symbol() {
            return NkStyleScrollbar.ninc_symbol(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int dec_symbol() {
            return NkStyleScrollbar.ndec_symbol(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleScrollbar.nuserdata(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_begin")
        public NkDrawBeginCallback draw_begin() {
            return NkStyleScrollbar.ndraw_begin(this.address());
        }

        @Nullable
        @NativeType(value="nk_draw_end")
        public NkDrawEndCallback draw_end() {
            return NkStyleScrollbar.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleScrollbar.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_normal());
            return this;
        }

        public Buffer cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_hover());
            return this;
        }

        public Buffer cursor_active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_active());
            return this;
        }

        public Buffer cursor_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleScrollbar.ncursor_border_color(this.address(), value);
            return this;
        }

        public Buffer cursor_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_border_color());
            return this;
        }

        public Buffer border(float value) {
            NkStyleScrollbar.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleScrollbar.nrounding(this.address(), value);
            return this;
        }

        public Buffer border_cursor(float value) {
            NkStyleScrollbar.nborder_cursor(this.address(), value);
            return this;
        }

        public Buffer rounding_cursor(float value) {
            NkStyleScrollbar.nrounding_cursor(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleScrollbar.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer show_buttons(int value) {
            NkStyleScrollbar.nshow_buttons(this.address(), value);
            return this;
        }

        public Buffer inc_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleScrollbar.ninc_button(this.address(), value);
            return this;
        }

        public Buffer inc_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.inc_button());
            return this;
        }

        public Buffer dec_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleScrollbar.ndec_button(this.address(), value);
            return this;
        }

        public Buffer dec_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.dec_button());
            return this;
        }

        public Buffer inc_symbol(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleScrollbar.ninc_symbol(this.address(), value);
            return this;
        }

        public Buffer dec_symbol(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleScrollbar.ndec_symbol(this.address(), value);
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleScrollbar.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@Nullable @NativeType(value="nk_draw_begin") NkDrawBeginCallbackI value) {
            NkStyleScrollbar.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@Nullable @NativeType(value="nk_draw_end") NkDrawEndCallbackI value) {
            NkStyleScrollbar.ndraw_end(this.address(), value);
            return this;
        }
    }
}

