/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class Remove
extends SystemFunctionCall
implements Callable {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression exp = super.simplify(visitor);
        if (exp instanceof Remove) {
            return ((Remove)exp).simplifyAsTailExpression();
        }
        return exp;
    }

    private Expression simplifyAsTailExpression() {
        if (Literal.isAtomic(this.argument[1])) {
            try {
                long value = ((IntegerValue)((Literal)this.argument[1]).getValue()).longValue();
                if (value <= 0L) {
                    return this.argument[0];
                }
                if (value == 1L) {
                    TailExpression t = new TailExpression(this.argument[0], 2);
                    ExpressionTool.copyLocationInfo(this, t);
                    return t;
                }
            }
            catch (XPathException err) {
                return this;
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            return this.simplifyAsTailExpression();
        }
        return e;
    }

    public ItemType getItemType() {
        return this.argument[0].getItemType();
    }

    public IntegerValue[] getIntegerBounds() {
        return this.argument[0].getIntegerBounds();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator seq = this.argument[0].iterate(context);
        NumericValue n = (NumericValue)this.argument[1].evaluateItem(context);
        int pos = (int)n.longValue();
        if (pos < 1) {
            return seq;
        }
        return new RemoveIterator(seq, pos);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NumericValue n = (NumericValue)arguments[1].head();
        int pos = (int)n.longValue();
        if (pos < 1) {
            return arguments[0];
        }
        return SequenceTool.toLazySequence(new RemoveIterator(arguments[0].iterate(), pos));
    }

    public static class RemoveIterator
    implements SequenceIterator,
    LastPositionFinder {
        SequenceIterator base;
        int removePosition;
        int basePosition = 0;
        Item current = null;

        public RemoveIterator(SequenceIterator base, int removePosition) {
            this.base = base;
            this.removePosition = removePosition;
        }

        public Item next() throws XPathException {
            this.current = this.base.next();
            ++this.basePosition;
            if (this.current != null && this.basePosition == this.removePosition) {
                this.current = this.base.next();
                ++this.basePosition;
            }
            return this.current;
        }

        public void close() {
            this.base.close();
        }

        public int getLength() throws XPathException {
            if (this.base instanceof LastPositionFinder) {
                int x = ((LastPositionFinder)((Object)this.base)).getLength();
                if (this.removePosition >= 1 && this.removePosition <= x) {
                    return x - 1;
                }
                return x;
            }
            throw new AssertionError((Object)"base of removeIterator is not a LastPositionFinder");
        }

        public RemoveIterator getAnother() throws XPathException {
            return new RemoveIterator(this.base.getAnother(), this.removePosition);
        }

        public int getProperties() {
            return this.base.getProperties() & 2;
        }
    }
}

