/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class IRBlockBody
extends ContextAwareBlockBody {
    protected final String fileName;
    protected final int lineNumber;

    public IRBlockBody(IRScope closure, Signature signature) {
        this(closure.getStaticScope(), closure.getFile(), closure.getLine(), signature);
    }

    public IRBlockBody(StaticScope scope, String file2, int line, Signature signature) {
        super(scope, signature);
        this.fileName = file2;
        this.lineNumber = line;
    }

    @Override
    public abstract boolean canCallDirect();

    @Override
    public IRubyObject call(ThreadContext context, Block block) {
        return this.call(context, block, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0) {
        return this.call(context, block, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1) {
        return this.call(context, block, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, block, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2) {
        return this.call(context, block, args2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        if (this.canCallDirect()) {
            return this.callDirect(context, block, args2, blockArg);
        }
        return this.commonYieldPath(context, block, this.prepareArgumentsForCall(context, args2, block.type), null, blockArg);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block) {
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, null, null);
        }
        IRubyObject[] args2 = IRubyObject.NULL_ARRAY;
        if (block.type == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, block, args2, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0) {
        if (this.canCallDirect()) {
            IRubyObject[] args2 = arg0 instanceof RubyArray ? IRRuntimeHelpers.convertValueIntoArgArray(context, (RubyArray)arg0, this.signature) : new IRubyObject[]{arg0};
            return this.yieldDirect(context, block, args2, null);
        }
        if (arg0 instanceof RubyArray) {
            IRubyObject[] args3 = IRRuntimeHelpers.convertValueIntoArgArray(context, (RubyArray)arg0, this.signature);
            if (block.type == Block.Type.LAMBDA) {
                this.signature.checkArity(context.runtime, args3);
            }
            return this.commonYieldPath(context, block, args3, null, Block.NULL_BLOCK);
        }
        return this.doYield(context, block, arg0);
    }

    private IRubyObject yieldSpecificMultiArgsCommon(ThreadContext context, Block block, IRubyObject ... args2) {
        int blockArity = this.signature.arityValue();
        if (blockArity == 1) {
            args2 = new IRubyObject[]{RubyArray.newArrayMayCopy(context.runtime, args2)};
        }
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, args2, null);
        }
        if (blockArity == 0) {
            args2 = IRubyObject.NULL_ARRAY;
        }
        if (block.type == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, block, args2, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1) {
        return this.yieldSpecificMultiArgsCommon(context, block, arg0, arg1);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.yieldSpecificMultiArgsCommon(context, block, arg0, arg1, arg2);
    }

    public static IRubyObject[] toAry(ThreadContext context, IRubyObject value2) {
        IRubyObject ary = Helpers.aryToAry(context, value2);
        if (ary instanceof RubyArray) {
            return ((RubyArray)ary).toJavaArray();
        }
        if (ary == context.nil) {
            return new IRubyObject[]{value2};
        }
        throw context.runtime.newTypeError(value2.getType().getName() + "#to_ary should return Array");
    }

    protected IRubyObject doYieldLambda(ThreadContext context, Block block, IRubyObject value2) {
        IRubyObject[] args2 = value2 == null ? IRubyObject.NULL_ARRAY : (this.signature.required() == 1 || this.signature.arityValue() == -1 ? new IRubyObject[]{value2} : IRBlockBody.toAry(context, value2));
        this.signature.checkArity(context.runtime, args2);
        return this.commonYieldPath(context, block, args2, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
        if (block.type == Block.Type.LAMBDA) {
            return this.doYieldLambda(context, block, value2);
        }
        IRubyObject[] args2 = value2 == null ? IRubyObject.NULL_ARRAY : (!this.signature.isSpreadable() ? new IRubyObject[]{value2} : IRBlockBody.toAry(context, value2));
        return this.commonYieldPath(context, block, args2, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        if (block.type == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, block, args2, self2, Block.NULL_BLOCK);
    }

    protected abstract IRubyObject commonYieldPath(ThreadContext var1, Block var2, IRubyObject[] var3, IRubyObject var4, Block var5);

    static void postYield(ThreadContext context, InterpreterContext ic, Binding binding2, Visibility oldVis, Frame prevFrame) {
        binding2.getFrame().setVisibility(oldVis);
        if (ic.popDynScope()) {
            context.postYield(binding2, prevFrame);
        } else {
            context.postYieldNoScope(prevFrame);
        }
    }

    public IRClosure getScope() {
        return (IRClosure)this.scope.getIRScope();
    }

    @Override
    public String getFile() {
        return this.fileName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public boolean isRubyBlock() {
        return true;
    }
}

