// This file is generated by kconfig_compiler_kf5 from expirycheckerconfigbase.kcfg.
// All changes you do to this file will be lost.
#ifndef KLEO_EXPIRYCHECKERCONFIGBASE_H
#define KLEO_EXPIRYCHECKERCONFIGBASE_H

#include "kleo_export.h"

#include <qglobal.h>
#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace Kleo {

class KLEO_EXPORT ExpiryCheckerConfigBase : public KConfigSkeleton
{
  public:

    ExpiryCheckerConfigBase( );
    ~ExpiryCheckerConfigBase() override;

    /**
      Set Threshold for own certificates
    */
    void setOwnKeyThresholdInDays( int v )
    {
      if (v < -1)
      {
        qDebug() << "setOwnKeyThresholdInDays: value " << v << " is less than the minimum value of -1";
        v = -1;
      }

      if (v > 999)
      {
        qDebug() << "setOwnKeyThresholdInDays: value " << v << " is greater than the maximum value of 999";
        v = 999;
      }

      if (!isOwnKeyThresholdInDaysImmutable())
        mOwnKeyThresholdInDays = v;
    }

    /**
      Get Threshold for own certificates
    */
    int ownKeyThresholdInDays() const
    {
      return mOwnKeyThresholdInDays;
    }

    /**
      Is Threshold for own certificates Immutable
    */
    bool isOwnKeyThresholdInDaysImmutable() const
    {
      return isImmutable( QStringLiteral( "ownKeyThresholdInDays" ) );
    }

    /**
      Get Threshold for own certificates default value
    */
    int defaultOwnKeyThresholdInDaysValue() const
    {
        return defaultOwnKeyThresholdInDaysValue_helper();
    }

    /**
      Set Threshold for other certificates
    */
    void setOtherKeyThresholdInDays( int v )
    {
      if (v < -1)
      {
        qDebug() << "setOtherKeyThresholdInDays: value " << v << " is less than the minimum value of -1";
        v = -1;
      }

      if (v > 999)
      {
        qDebug() << "setOtherKeyThresholdInDays: value " << v << " is greater than the maximum value of 999";
        v = 999;
      }

      if (!isOtherKeyThresholdInDaysImmutable())
        mOtherKeyThresholdInDays = v;
    }

    /**
      Get Threshold for other certificates
    */
    int otherKeyThresholdInDays() const
    {
      return mOtherKeyThresholdInDays;
    }

    /**
      Is Threshold for other certificates Immutable
    */
    bool isOtherKeyThresholdInDaysImmutable() const
    {
      return isImmutable( QStringLiteral( "otherKeyThresholdInDays" ) );
    }

    /**
      Get Threshold for other certificates default value
    */
    int defaultOtherKeyThresholdInDaysValue() const
    {
        return defaultOtherKeyThresholdInDaysValue_helper();
    }

    /**
      Set Threshold for root certificates
    */
    void setRootCertificateThresholdInDays( int v )
    {
      if (v < -1)
      {
        qDebug() << "setRootCertificateThresholdInDays: value " << v << " is less than the minimum value of -1";
        v = -1;
      }

      if (v > 999)
      {
        qDebug() << "setRootCertificateThresholdInDays: value " << v << " is greater than the maximum value of 999";
        v = 999;
      }

      if (!isRootCertificateThresholdInDaysImmutable())
        mRootCertificateThresholdInDays = v;
    }

    /**
      Get Threshold for root certificates
    */
    int rootCertificateThresholdInDays() const
    {
      return mRootCertificateThresholdInDays;
    }

    /**
      Is Threshold for root certificates Immutable
    */
    bool isRootCertificateThresholdInDaysImmutable() const
    {
      return isImmutable( QStringLiteral( "rootCertificateThresholdInDays" ) );
    }

    /**
      Get Threshold for root certificates default value
    */
    int defaultRootCertificateThresholdInDaysValue() const
    {
        return defaultRootCertificateThresholdInDaysValue_helper();
    }

    /**
      Set Threshold for intermediate certificates
    */
    void setIntermediateCertificateThresholdInDays( int v )
    {
      if (v < -1)
      {
        qDebug() << "setIntermediateCertificateThresholdInDays: value " << v << " is less than the minimum value of -1";
        v = -1;
      }

      if (v > 999)
      {
        qDebug() << "setIntermediateCertificateThresholdInDays: value " << v << " is greater than the maximum value of 999";
        v = 999;
      }

      if (!isIntermediateCertificateThresholdInDaysImmutable())
        mIntermediateCertificateThresholdInDays = v;
    }

    /**
      Get Threshold for intermediate certificates
    */
    int intermediateCertificateThresholdInDays() const
    {
      return mIntermediateCertificateThresholdInDays;
    }

    /**
      Is Threshold for intermediate certificates Immutable
    */
    bool isIntermediateCertificateThresholdInDaysImmutable() const
    {
      return isImmutable( QStringLiteral( "intermediateCertificateThresholdInDays" ) );
    }

    /**
      Get Threshold for intermediate certificates default value
    */
    int defaultIntermediateCertificateThresholdInDaysValue() const
    {
        return defaultIntermediateCertificateThresholdInDaysValue_helper();
    }

  protected:

    // General
    int mOwnKeyThresholdInDays;
    int defaultOwnKeyThresholdInDaysValue_helper() const;
    int mOtherKeyThresholdInDays;
    int defaultOtherKeyThresholdInDaysValue_helper() const;
    int mRootCertificateThresholdInDays;
    int defaultRootCertificateThresholdInDaysValue_helper() const;
    int mIntermediateCertificateThresholdInDays;
    int defaultIntermediateCertificateThresholdInDaysValue_helper() const;

  private:
};

}

#endif

