/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.health;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourcesHealthSupport;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class DataSourceHealthCheck
implements HealthCheck {
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    @PostConstruct
    protected void init() {
        DataSourcesHealthSupport support = (DataSourcesHealthSupport)Arc.container().instance(DataSourcesHealthSupport.class, new Annotation[0]).get();
        Set names = support.getConfiguredNames();
        Set excludedNames = support.getExcludedNames();
        for (String name : names) {
            DataSource ds;
            DataSource dataSource = ds = DataSourceUtil.isDefault((String)name) ? (DataSource)Arc.container().instance(DataSource.class, new Annotation[0]).get() : (DataSource)Arc.container().instance(DataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(name)}).get();
            if (excludedNames.contains(name) || ds == null) continue;
            this.dataSources.put(name, ds);
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Database connections health check").up();
        for (Map.Entry<String, DataSource> dataSource : this.dataSources.entrySet()) {
            String data;
            boolean isDefault = DataSourceUtil.isDefault((String)dataSource.getKey());
            AgroalDataSource ads = (AgroalDataSource)dataSource.getValue();
            String dsName = dataSource.getKey();
            try {
                boolean valid = ads.isHealthy(false);
                if (!valid) {
                    data = isDefault ? "validation check failed for the default DataSource" : "validation check failed for DataSource '" + dataSource.getKey() + "'";
                    builder.down().withData(dsName, data);
                    continue;
                }
                builder.withData(dsName, "UP");
            }
            catch (SQLException e) {
                data = isDefault ? "Unable to execute the validation check for the default DataSource: " : "Unable to execute the validation check for DataSource '" + dataSource.getKey() + "': ";
                builder.down().withData(dsName, data + e.getMessage());
            }
        }
        return builder.build();
    }
}

