/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Collections;
import java.util.HashMap;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo1_9_2
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.9.2");

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    protected void migrateRealm(RealmModel realm) {
        if (realm.getBrowserSecurityHeaders() != null) {
            HashMap<String, String> browserSecurityHeaders = new HashMap<String, String>(realm.getBrowserSecurityHeaders());
            browserSecurityHeaders.put("xContentTypeOptions", "nosniff");
            realm.setBrowserSecurityHeaders(Collections.unmodifiableMap(browserSecurityHeaders));
        }
    }
}

