/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;

public class GrpcBinderProcessor {
    static final String CLIENT_GRPC_METRICS_INTERCEPTOR = "io.quarkus.micrometer.runtime.binder.grpc.GrpcMetricsClientInterceptor";
    static final String SERVER_GRPC_METRICS_INTERCEPTOR = "io.quarkus.micrometer.runtime.binder.grpc.GrpcMetricsServerInterceptor";
    static final String CLIENT_INTERCEPTOR = "io.grpc.ClientInterceptor";
    static final String SERVER_INTERCEPTOR = "io.grpc.ServerInterceptor";
    static final Class<?> CLIENT_INTERCEPTOR_CLASS = MicrometerRecorder.getClassForName((String)"io.grpc.ClientInterceptor");
    static final Class<?> SERVER_INTERCEPTOR_CLASS = MicrometerRecorder.getClassForName((String)"io.grpc.ServerInterceptor");

    @BuildStep(onlyIf={GrpcClientSupportEnabled.class})
    AdditionalBeanBuildItem addGrpcClientMetricInterceptor() {
        return AdditionalBeanBuildItem.unremovableOf((String)CLIENT_GRPC_METRICS_INTERCEPTOR);
    }

    @BuildStep(onlyIf={GrpcServerSupportEnabled.class})
    AdditionalBeanBuildItem addGrpcServerMetricInterceptor(BuildProducer<AdditionalIndexedClassesBuildItem> producer) {
        producer.produce((BuildItem)new AdditionalIndexedClassesBuildItem(SERVER_GRPC_METRICS_INTERCEPTOR));
        return AdditionalBeanBuildItem.unremovableOf((String)SERVER_GRPC_METRICS_INTERCEPTOR);
    }

    static class GrpcServerSupportEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        GrpcServerSupportEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return SERVER_INTERCEPTOR_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.grpcServer);
        }
    }

    static class GrpcClientSupportEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        GrpcClientSupportEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return CLIENT_INTERCEPTOR_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.grpcClient);
        }
    }
}

