/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.jboss7;

import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.jul.JulLogEvent;
import java.util.Set;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;

public class JBoss7JulLogEvent
extends JulLogEvent {
    private ExtLogRecord extLogRecord;

    public JBoss7JulLogEvent(ExtLogRecord logRecord) {
        super((LogRecord)logRecord);
        this.extLogRecord = logRecord;
    }

    @Override
    public Values getValues(MessageField field) {
        if (field instanceof MdcMessageField) {
            return new Values(field.getName(), this.getMdcValue(((MdcMessageField)field).getMdcName()));
        }
        if (field instanceof DynamicMdcMessageField) {
            return this.getMdcValues((DynamicMdcMessageField)field);
        }
        return super.getValues(field);
    }

    @Override
    public String getValue(LogMessageField field) {
        switch (field.getNamedLogField()) {
            case NDC: {
                String ndc = this.extLogRecord.getNdc();
                if (ndc != null && !"".equals(ndc)) {
                    return ndc;
                }
                return null;
            }
            case SourceLineNumber: {
                return this.getSourceLineNumber();
            }
            case ThreadName: {
                return this.extLogRecord.getThreadName();
            }
        }
        return super.getValue(field);
    }

    private String getSourceLineNumber() {
        if (this.extLogRecord.getSourceLineNumber() <= 0) {
            return null;
        }
        return "" + this.extLogRecord.getSourceLineNumber();
    }

    private Values getMdcValues(DynamicMdcMessageField field) {
        Values result = new Values();
        Set<String> mdcNames = this.getAllMdcNames();
        Set<String> matchingMdcNames = GelfUtil.getMatchingMdcNames(field, mdcNames);
        for (String mdcName : matchingMdcNames) {
            String mdcValue = this.getMdcValue(mdcName);
            if (mdcValue == null) continue;
            result.setValue(mdcName, mdcValue);
        }
        return result;
    }

    private Set<String> getAllMdcNames() {
        return this.extLogRecord.getMdcCopy().keySet();
    }

    @Override
    public String getMdcValue(String mdcName) {
        return this.extLogRecord.getMdc(mdcName);
    }

    @Override
    public Set<String> getMdcNames() {
        return this.getAllMdcNames();
    }
}

