/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.gelf.GelfMessageAssembler;
import biz.paluch.logging.gelf.GelfUtil;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.PropertyProvider;
import biz.paluch.logging.gelf.intern.GelfMessage;
import java.util.Set;

public class MdcGelfMessageAssembler
extends GelfMessageAssembler {
    public static final String PROPERTY_MDC_PROFILING = "mdcProfiling";
    public static final String PROPERTY_INCLUDE_FULL_MDC = "includeFullMdc";
    public static final String PROPERTY_MDC_FIELD = "mdcField.";
    public static final String PROPERTY_DYNAMIC_MDC_FIELD = "dynamicMdcFields.";
    private boolean mdcProfiling;
    private boolean includeFullMdc;

    @Override
    public void initialize(PropertyProvider propertyProvider) {
        super.initialize(propertyProvider);
        this.mdcProfiling = "true".equalsIgnoreCase(propertyProvider.getProperty(PROPERTY_MDC_PROFILING));
        this.includeFullMdc = "true".equalsIgnoreCase(propertyProvider.getProperty(PROPERTY_INCLUDE_FULL_MDC));
    }

    @Override
    public GelfMessage createGelfMessage(LogEvent logEvent) {
        GelfMessage gelfMessage = super.createGelfMessage(logEvent);
        if (this.mdcProfiling) {
            GelfUtil.addMdcProfiling(logEvent, gelfMessage);
        }
        if (this.includeFullMdc) {
            Set<String> mdcNames = logEvent.getMdcNames();
            for (String mdcName : mdcNames) {
                String mdcValue;
                if (mdcName == null || (mdcValue = logEvent.getMdcValue(mdcName)) == null) continue;
                gelfMessage.addField(mdcName, mdcValue);
            }
        }
        return gelfMessage;
    }

    public boolean isMdcProfiling() {
        return this.mdcProfiling;
    }

    public void setMdcProfiling(boolean mdcProfiling) {
        this.mdcProfiling = mdcProfiling;
    }

    public boolean isIncludeFullMdc() {
        return this.includeFullMdc;
    }

    public void setIncludeFullMdc(boolean includeFullMdc) {
        this.includeFullMdc = includeFullMdc;
    }
}

