/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    static final boolean DEBUG = false;
    private static final int SSL_CERT_SAN_DNS_NAME = 2;
    public static final String[] VALID_SSL_VERSION_STRINGS = new String[]{"1.2", "1.3", "1.3 or 1.2"};
    public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS = new String[][]{{"TLSv1.2"}, {"TLSv1.3"}, {"TLSv1.3", "TLSv1.2"}};
    public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP = new int[]{0, 1, 2};
    static final HashSet<String> UNSUPPORTED_PROTOCOLS_SET = new HashSet();
    static final HashSet<String> DEFAULT_VALUE_SET;

    private TcpsConfigure() {
    }

    public static void configureVersion(SSLSocket sslSocket, SSLEngine sslEngine, String sslVersionString, boolean useNio) throws NetException, IOException {
        if (sslVersionString == null) {
            sslVersionString = System.getProperty("oracle.net.ssl_version");
        }
        String[] enabledProtocols = null;
        int validSSLVersionIndex = -1;
        if (sslVersionString != null && !DEFAULT_VALUE_SET.contains(sslVersionString)) {
            if (sslVersionString.startsWith("(") && sslVersionString.endsWith(")")) {
                sslVersionString = sslVersionString.substring(1, sslVersionString.length() - 1);
            }
            if (sslVersionString.startsWith("{")) {
                if ((sslVersionString = sslVersionString.substring(1, sslVersionString.length() - 1)).startsWith("(")) {
                    sslVersionString = sslVersionString.substring(1, sslVersionString.length() - 1);
                }
                enabledProtocols = sslVersionString.trim().split("\\s*,\\s*");
            } else {
                try {
                    for (int i = 0; i < VALID_SSL_VERSION_STRINGS.length; ++i) {
                        if (!sslVersionString.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[i])) continue;
                        validSSLVersionIndex = i;
                        break;
                    }
                }
                catch (Exception ex) {
                    throw (NetException)new NetException(17950, sslVersionString).initCause(ex);
                }
                if (validSSLVersionIndex == -1 || validSSLVersionIndex >= VALID_SSL_VERSION_STRINGS.length) {
                    throw new NetException(17950);
                }
                enabledProtocols = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[validSSLVersionIndex]];
            }
        } else {
            enabledProtocols = TcpsConfigure.getAllSupportedProtocols(useNio, sslEngine, sslSocket);
            if (enabledProtocols == null) {
                throw new NetException(17950);
            }
        }
        try {
            if (!useNio) {
                sslSocket.setEnabledProtocols(enabledProtocols);
            } else {
                sslEngine.setEnabledProtocols(enabledProtocols);
            }
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(17951).initCause(ex);
        }
    }

    public static void configureCipherSuites(SSLSocket sslSocket, SSLEngine sslEngine, String cipherSuitesString, boolean useNio) throws NetException, IOException {
        if (cipherSuitesString == null) {
            cipherSuitesString = System.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (cipherSuitesString == null) {
            return;
        }
        cipherSuitesString = ((String)cipherSuitesString).startsWith("(") && ((String)cipherSuitesString).endsWith(")") ? "(cipher_suites=" + (String)cipherSuitesString + ")" : "(cipher_suites=(" + (String)cipherSuitesString + "))";
        try {
            NVPair nvpCipher = new NVFactory().createNVPair((String)cipherSuitesString);
            String[] listCipherSuites = new String[nvpCipher.getListSize()];
            if (nvpCipher.getRHSType() == NVPair.LIST_COMMASEP || nvpCipher.getRHSType() == NVPair.RHS_LIST) {
                for (int i = 0; i < nvpCipher.getListSize(); ++i) {
                    listCipherSuites[i] = nvpCipher.getListElement(i).getName();
                }
            } else {
                throw new NetException(17952, (String)cipherSuitesString);
            }
            if (!useNio) {
                sslSocket.setEnabledCipherSuites(listCipherSuites);
            } else {
                sslEngine.setEnabledCipherSuites(listCipherSuites);
            }
        }
        catch (NLException ex) {
            throw new NetException(17952, (String)cipherSuitesString);
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(17953).initCause(ex);
        }
    }

    private static String[] getAllSupportedProtocols(boolean useNio, SSLEngine sslEngine, SSLSocket sslSocket) {
        ArrayList<String> allSupportedProtocols = new ArrayList<String>();
        String[] allProtocols = null;
        allProtocols = useNio ? sslEngine.getSupportedProtocols() : sslSocket.getSupportedProtocols();
        if (allProtocols == null) {
            return null;
        }
        for (String curProtocol : allProtocols) {
            if (UNSUPPORTED_PROTOCOLS_SET.contains(curProtocol)) continue;
            allSupportedProtocols.add(curProtocol);
        }
        return allSupportedProtocols.toArray(new String[allSupportedProtocols.size()]);
    }

    static {
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv3");
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv2Hello");
        DEFAULT_VALUE_SET = new HashSet();
        DEFAULT_VALUE_SET.add("0");
        DEFAULT_VALUE_SET.add("(0)");
        DEFAULT_VALUE_SET.add("undetermined");
        DEFAULT_VALUE_SET.add("(undetermined)");
    }
}

