/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrgnc;
import oracle.jdbc.driver.T4CTTIkpdnrri;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.TIMESTAMPTZ;

final class T4CTTIokpn
extends T4CTTIfun {
    static final int REGISTER_KPNDEF = 1;
    static final int UNREGISTER_KPNDEF = 2;
    static final int POST_KPNDEF = 3;
    static final int ENABLE_KPNDEF = 4;
    static final int DISABLE_KPNDEF = 5;
    static final int EXISTINGCLIENT_KPNDEF = 0;
    static final int NEWCLIENT_KPNDEF = 1;
    static final int CLIENTCON_KPNDEF = 4;
    static final int KPUN_PRS_RAW = 1;
    static final int KPUN_VER_10200 = 2;
    static final int KPUN_VER_11100 = 3;
    static final int KPUN_VER_11200 = 4;
    static final int KPUN_VER_12100 = 6;
    static final int OCI_SUBSCR_NAMESPACE_ANONYMOUS = 0;
    static final int OCI_SUBSCR_NAMESPACE_AQ = 1;
    static final int OCI_SUBSCR_NAMESPACE_DBCHANGE = 2;
    static final int OCI_SUBSCR_NAMESPACE_MAX = 3;
    static final int KPD_CHNF_OPFILTER = 1;
    static final int KPD_CHNF_INSERT = 2;
    static final int KPD_CHNF_UPDATE = 4;
    static final int KPD_CHNF_DELETE = 8;
    static final int KPD_CHNF_ROWID = 16;
    static final int KPD_CQ_QUERYNF = 32;
    static final int KPD_CQ_BEST_EFFORT = 64;
    static final int KPD_CQ_CLQRYCACHE = 128;
    static final int KPD_CHNF_INVALID_REGID = 0;
    static final int KPD_NTFN_CONNID_LEN = 29;
    static final int KKCN_CTX_RAW = 0;
    static final int SUBSCR_QOS_RELIABLE = 1;
    static final int SUBSCR_QOS_PAYLOAD = 2;
    static final int SUBSCR_QOS_REPLICATE = 4;
    static final int SUBSCR_QOS_SECURE = 8;
    static final int SUBSCR_QOS_PURGE_ON_NTFN = 16;
    static final int SUBSCR_QOS_MULTICBK = 32;
    static final int SUBSCR_QOS_ASYNC_DEQ = 512;
    static final int SUBSCR_QOS_TX_ACK = 2048;
    static final int SUBSCR_QOS_AUTO_ACK = 1024;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_NONE = 0;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_TIME = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_SUMMARY = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_LAST = 2;
    private int opcode;
    private int mode;
    private int nbOfRegistrationInfo;
    private String jmsConnectionId = null;
    private String[] databaseInstances = null;
    private int[] namespace;
    private int[] kpdnrgrpval;
    private int[] kpdnrgrprepcnt;
    private int[] payloadType;
    private int[] qosFlags;
    private int[] timeout;
    private int[] dbchangeOpFilter;
    private int[] dbchangeTxnLag = null;
    private byte[] kpncid = null;
    private byte[][] registeredAgentName = null;
    private byte[][] kpdnrcx = null;
    private byte[] kpdnrgrpcla;
    private byte[] kpdnrgrptyp = null;
    private TIMESTAMPTZ[] kpdnrgrpstatim = null;
    private long[] dbchangeRegistrationId = null;
    private byte[] userArr = null;
    private byte[] locationArr = null;
    private byte[] subscriberName = null;
    private byte[] selectorByteArray = null;
    private long regid = 0L;
    private long[] registrationId = null;
    ArrayList<String> listenerAddresses = new ArrayList();
    T4CTTIkpdnrri kpninst = null;
    T4CTTIkpdnrgnc kpngcret = null;

    T4CTTIokpn(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)125);
    }

    void doOKPN(int _opcode, int _mode, String user, String location, int _nbOfRegistrationInfo, int[] _namespace, String[] _registeredAgentName, byte[][] _kpdnrcx, int[] _payloadType, int[] _qosFlags, int[] _timeout, int[] _dbchangeOpFilter, int[] _dbchangeTxnLag, long[] _dbchangeRegistrationId, byte[] _kpdnrgrpcla, int[] _kpdnrgrpval, byte[] _kpdnrgrptyp, TIMESTAMPTZ[] _kpdnrgrpstatim, int[] _kpdnrgrprepcnt, long[] _kpdnrregid) throws IOException, SQLException {
        this.doOKPN(_opcode, _mode, user, location, _nbOfRegistrationInfo, _namespace, _registeredAgentName, _kpdnrcx, _payloadType, _qosFlags, _timeout, _dbchangeOpFilter, _dbchangeTxnLag, _dbchangeRegistrationId, _kpdnrgrpcla, _kpdnrgrpval, _kpdnrgrptyp, _kpdnrgrpstatim, _kpdnrgrprepcnt, _kpdnrregid, null);
    }

    void doOKPN(int _opcode, int _mode, String user, String location, int _nbOfRegistrationInfo, int[] _namespace, String[] _registeredAgentName, byte[][] _kpdnrcx, int[] _payloadType, int[] _qosFlags, int[] _timeout, int[] _dbchangeOpFilter, int[] _dbchangeTxnLag, long[] _dbchangeRegistrationId, byte[] _kpdnrgrpcla, int[] _kpdnrgrpval, byte[] _kpdnrgrptyp, TIMESTAMPTZ[] _kpdnrgrpstatim, int[] _kpdnrgrprepcnt, long[] _kpdnrregid, String selector) throws IOException, SQLException {
        this.opcode = _opcode;
        this.mode = _mode;
        this.nbOfRegistrationInfo = _nbOfRegistrationInfo;
        this.namespace = _namespace;
        this.kpdnrcx = _kpdnrcx;
        this.payloadType = _payloadType;
        this.qosFlags = _qosFlags;
        this.timeout = _timeout;
        this.dbchangeOpFilter = _dbchangeOpFilter;
        if (this.dbchangeOpFilter == null) {
            this.dbchangeOpFilter = new int[this.nbOfRegistrationInfo];
        }
        this.dbchangeTxnLag = _dbchangeTxnLag;
        if (this.dbchangeTxnLag == null) {
            this.dbchangeTxnLag = new int[this.nbOfRegistrationInfo];
        }
        this.dbchangeRegistrationId = _dbchangeRegistrationId;
        if (this.dbchangeRegistrationId == null) {
            this.dbchangeRegistrationId = new long[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrpcla = _kpdnrgrpcla;
        if (this.kpdnrgrpcla == null) {
            this.kpdnrgrpcla = new byte[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrpval = _kpdnrgrpval;
        if (this.kpdnrgrpval == null) {
            this.kpdnrgrpval = new int[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrptyp = _kpdnrgrptyp;
        if (this.kpdnrgrptyp == null) {
            this.kpdnrgrptyp = new byte[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrpstatim = _kpdnrgrpstatim;
        if (this.kpdnrgrpstatim == null) {
            this.kpdnrgrpstatim = new TIMESTAMPTZ[this.nbOfRegistrationInfo];
        }
        this.kpdnrgrprepcnt = _kpdnrgrprepcnt;
        if (this.kpdnrgrprepcnt == null) {
            this.kpdnrgrprepcnt = new int[this.nbOfRegistrationInfo];
        }
        this.registrationId = _kpdnrregid;
        if (this.registrationId == null) {
            this.registrationId = new long[this.nbOfRegistrationInfo];
        }
        this.registeredAgentName = new byte[this.nbOfRegistrationInfo][];
        for (int i = 0; i < this.nbOfRegistrationInfo; ++i) {
            if (_registeredAgentName[i] == null) continue;
            this.registeredAgentName[i] = this.meg.conv.StringToCharBytes(_registeredAgentName[i]);
        }
        this.userArr = (byte[])(user != null ? this.meg.conv.StringToCharBytes(user) : null);
        this.locationArr = (byte[])(location != null ? this.meg.conv.StringToCharBytes(location) : null);
        this.selectorByteArray = (byte[])(selector != null ? this.meg.conv.StringToCharBytes(selector) : null);
        this.regid = 0L;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        int presentation = 1;
        int kpnver = 6;
        this.meg.marshalUB1((byte)this.opcode);
        this.meg.marshalUB4(this.mode);
        if (this.userArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.userArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.locationArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.locationArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.nbOfRegistrationInfo);
        this.meg.marshalUB2(presentation);
        this.meg.marshalUB2(kpnver);
        if (this.connection.getTTCVersion() >= 4) {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            if (this.connection.getTTCVersion() >= 5) {
                this.meg.marshalNULLPTR();
                this.meg.marshalPTR();
                if (this.connection.getTTCVersion() >= 7) {
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalPTR();
                    this.meg.marshalSWORD(29);
                    this.meg.marshalPTR();
                }
            }
        }
        if (this.userArr != null) {
            this.meg.marshalCHR(this.userArr);
        }
        if (this.locationArr != null) {
            this.meg.marshalCHR(this.locationArr);
        }
        assert (this.namespace != null && this.registeredAgentName != null && this.payloadType != null && this.qosFlags != null && this.timeout != null) : " namespace : " + this.namespace + ", registeredAgentName : " + this.registeredAgentName + ", payloadType : " + this.payloadType + ", qosFlags : " + this.qosFlags + ", timeout : " + this.timeout;
        assert (this.namespace.length == this.nbOfRegistrationInfo && this.registeredAgentName.length == this.nbOfRegistrationInfo && this.payloadType.length == this.nbOfRegistrationInfo && this.qosFlags.length == this.nbOfRegistrationInfo && this.timeout.length == this.nbOfRegistrationInfo && this.kpdnrcx.length == this.nbOfRegistrationInfo && this.dbchangeOpFilter.length == this.nbOfRegistrationInfo && this.dbchangeTxnLag.length == this.nbOfRegistrationInfo && this.kpdnrgrpcla.length == this.nbOfRegistrationInfo && this.kpdnrgrpval.length == this.nbOfRegistrationInfo && this.kpdnrgrptyp.length == this.nbOfRegistrationInfo && this.kpdnrgrpstatim.length == this.nbOfRegistrationInfo && this.kpdnrgrprepcnt.length == this.nbOfRegistrationInfo && this.registrationId.length == this.nbOfRegistrationInfo) : " namespace.length = " + this.namespace.length + ", registeredAgentName.length = " + this.registeredAgentName.length + ", qosFlags.length = " + this.qosFlags.length + ", timeout.length = " + this.timeout.length + ", kpdnrcx.length = " + this.kpdnrcx.length + ", dbchangeOpFilter.length = " + this.dbchangeOpFilter.length + ", dbchangeTxnLag.length = " + this.dbchangeTxnLag.length + ", kpdnrgrpcla.length = " + this.kpdnrgrpcla.length + ", kpdnrgrpval.length = " + this.kpdnrgrpval.length + ", kpdnrgrptyp.length = " + this.kpdnrgrptyp.length + ", kpdnrgrpstatim.length = " + this.kpdnrgrpstatim.length + ", kpdnrgrprepcnt.length = " + this.kpdnrgrprepcnt.length + ", registrationId.length = " + this.registrationId.length;
        for (int i = 0; i < this.nbOfRegistrationInfo; ++i) {
            this.meg.marshalUB4(this.namespace[i]);
            byte[] kpdnrnm = this.registeredAgentName[i];
            if (kpdnrnm != null && kpdnrnm.length > 0) {
                this.meg.marshalUB4(kpdnrnm.length);
                this.meg.marshalCLR(kpdnrnm, 0, kpdnrnm.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            if (this.kpdnrcx == null) {
                this.meg.marshalUB4(0L);
            } else if (this.kpdnrcx[i] != null && this.kpdnrcx[i].length > 0) {
                this.meg.marshalUB4(this.kpdnrcx[i].length);
                this.meg.marshalCLR(this.kpdnrcx[i], 0, this.kpdnrcx[i].length);
            } else {
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalUB4(this.payloadType[i]);
            if (this.connection.getTTCVersion() < 4) continue;
            this.meg.marshalUB4(this.qosFlags[i]);
            if (this.selectorByteArray == null || this.selectorByteArray.length == 0) {
                this.meg.marshalUB4(0L);
            } else {
                this.meg.marshalUB4(this.selectorByteArray.length);
                this.meg.marshalCLR(this.selectorByteArray, this.selectorByteArray.length);
            }
            this.meg.marshalUB4(this.timeout[i]);
            int kpdnsd = 0;
            this.meg.marshalUB4(kpdnsd);
            this.meg.marshalUB4(this.dbchangeOpFilter[i]);
            this.meg.marshalUB4(this.dbchangeTxnLag[i]);
            this.meg.marshalUB4((int)this.dbchangeRegistrationId[i]);
            if (this.connection.getTTCVersion() < 5) continue;
            this.meg.marshalUB1(this.kpdnrgrpcla[i]);
            this.meg.marshalUB4(this.kpdnrgrpval[i]);
            this.meg.marshalUB1(this.kpdnrgrptyp[i]);
            if (this.kpdnrgrpstatim[i] == null) {
                this.meg.marshalDALC(null);
            } else {
                this.meg.marshalDALC(this.kpdnrgrpstatim[i].shareBytes());
            }
            this.meg.marshalSB4(this.kpdnrgrprepcnt[i]);
            this.meg.marshalSB8(this.registrationId[i]);
        }
    }

    long getRegistrationId() {
        return this.regid;
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int kpnrl = (int)this.meg.unmarshalUB4();
        for (int i = 0; i < kpnrl; ++i) {
            this.meg.unmarshalUB4();
        }
        int[] regidArr = new int[kpnrl];
        for (int i = 0; i < kpnrl; ++i) {
            regidArr[i] = (int)this.meg.unmarshalUB4();
        }
        this.regid = regidArr[0];
        if (this.connection.getTTCVersion() >= 5) {
            int kpngrl = (int)this.meg.unmarshalUB4();
            this.registrationId = new long[kpngrl];
            for (int j = 0; j < kpngrl; ++j) {
                int kpngnnosl;
                this.registrationId[j] = this.meg.unmarshalSB8();
                if (this.connection.getTTCVersion() < 7 || (kpngnnosl = (int)this.meg.unmarshalUB4()) <= 0) continue;
                this.subscriberName = new byte[kpngnnosl];
                int[] intAr = new int[1];
                this.meg.unmarshalCLR(this.subscriberName, 0, intAr, kpngnnosl);
            }
            this.regid = this.registrationId[0];
            if (this.connection.getTTCVersion() >= 7) {
                int kpninstl = (int)this.meg.unmarshalUB4();
                this.databaseInstances = new String[kpninstl];
                for (int i = 0; i < kpninstl; ++i) {
                    this.kpninst = new T4CTTIkpdnrri(this.connection);
                    this.kpninst.receive();
                    byte[] kpdnrrinm = this.kpninst.getKpdnrrinm();
                    if (kpdnrrinm == null) continue;
                    this.databaseInstances[i] = this.meg.conv.CharBytesToString(kpdnrrinm, kpdnrrinm.length);
                }
                int kpngcretl = (int)this.meg.unmarshalUB4();
                this.listenerAddresses = new ArrayList();
                for (int i = 0; i < kpngcretl; ++i) {
                    this.kpngcret = new T4CTTIkpdnrgnc(this.connection);
                    this.kpngcret.receive();
                    byte[] kpdnrgnclsc = this.kpngcret.getKpdnrgnclsc();
                    if (kpdnrgnclsc == null) continue;
                    String listenerAddress = this.meg.conv.CharBytesToString(kpdnrgnclsc, kpdnrgnclsc.length);
                    this.listenerAddresses.add(listenerAddress);
                }
                int kpncidl = this.meg.unmarshalUB2();
                if (kpncidl > 0) {
                    this.kpncid = new byte[kpncidl];
                    this.kpncid = this.meg.unmarshalCHR(kpncidl);
                    if (this.kpncid != null) {
                        this.jmsConnectionId = this.meg.conv.CharBytesToString(this.kpncid, this.kpncid.length);
                    }
                }
            }
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    ArrayList<String> getListenerAddresses() {
        return this.listenerAddresses;
    }

    String getListenerAddress() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    long[] getRegistrationIdArray() {
        return this.registrationId;
    }

    String getJMSConnectionId() {
        return this.jmsConnectionId;
    }

    String[] getDatabaseInstances() {
        return this.databaseInstances;
    }
}

