/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.babelfish.BabelfishCallableStatement;
import oracle.jdbc.babelfish.BabelfishConnection;
import oracle.jdbc.babelfish.BabelfishGenericProxy;
import oracle.jdbc.babelfish.BabelfishPreparedStatement;
import oracle.jdbc.babelfish.BabelfishStatement;
import oracle.jdbc.babelfish.TranslationManager;
import oracle.jdbc.babelfish.Translator;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.jdbc.diagnostics.OracleDiagnosticsMXBean;
import oracle.jdbc.driver.BlockSource;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.resource.ProviderProperties;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.spi.OracleConfigurationProvider;
import oracle.net.ns.NetException;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EZConnectResolver;
import oracle.security.pki.OraclePKIProvider;

public class OracleDriver
implements Driver,
Monitor {
    public static final String oracle_string = "oracle";
    public static final String jdbc_string = "jdbc";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    @Deprecated
    public static final String access_string = "access";
    @Deprecated
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "oracle.jdbc.proxyClientName";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String prelim_auth_string = "prelim_auth";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    @Deprecated
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    public static final String dms_stmt_caching_metrics_string = "oracle.jdbc.DMSStatementCachingMetrics";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String set_new_password_string = "oracle.jdbc.newPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    private static final String URL_DRIVERS = "(thin|oci|oci8|kprb|sharding)";
    private static final String URL_CREDENTIALS = "\\w*/?\\w*";
    private static final String SIMPLE_URL_FORMAT = "jdbc:oracle:(thin|oci|oci8|kprb|sharding):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+";
    private static final Pattern SERVICE_PROVIDER_URL = Pattern.compile("jdbc:oracle:(thin|oci|oci8|kprb|sharding):(\\w*/?\\w*)@config-(\\w*):(.*)", 2);
    static final int EXTENSION_TYPE_NUCLEO_CLIENT = -4;
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static final Monitor DEFAULT_CONN_MONITOR;
    private static OracleDriver defaultDriver;
    public static final Map<String, Class<?>> systemTypeMap;
    private static final String DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME = "/oracle/jdbc/defaultConnectionProperties.properties";
    protected static final Properties DEFAULT_CONNECTION_PROPERTIES;
    private static ExecutorService threadPool;
    private static final String SERVER_SIDE_DEFAULT_URL_PREFIX = "jdbc:default:connection";
    private static final int SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH;
    private static ObjectName diagnosticMBeanObjectName;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    public static void registerMBeans() {
        block14: {
            try {
                MBeanServer mbs = null;
                try {
                    Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                    Object factory = cls.newInstance();
                    Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                    mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
                }
                catch (NoClassDefFoundError ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (ClassNotFoundException ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InstantiationException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not create an instance.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                if (mbs != null) {
                    ClassLoader loader = OracleDriver.class.getClassLoader();
                    String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                    int count = 0;
                    while (true) {
                        String name = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                        diagnosticMBeanObjectName = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + name);
                        try {
                            OracleDiagnosticsMXBean mbeanInstance = OracleDiagnosticsMXBean.getInstance();
                            mbs.registerMBean(mbeanInstance, diagnosticMBeanObjectName);
                            break block14;
                        }
                        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                            continue;
                        }
                        break;
                    }
                }
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer so no MBears are registered.");
            }
            catch (JMException ex) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
            }
            catch (Throwable ex) {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
            }
        }
    }

    public static void unRegisterMBeans() {
        try {
            MBeanServer mbs = null;
            try {
                Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                Object factory = cls.newInstance();
                Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
            }
            catch (Throwable ex) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs != null) {
                try {
                    ClassLoader loader = OracleDriver.class.getClassLoader();
                    String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                    int count = 0;
                    String name = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                    diagnosticMBeanObjectName = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + name);
                    mbs.unregisterMBean(diagnosticMBeanObjectName);
                }
                catch (Throwable ex) {
                    Logger.getLogger("oracle.jdbc").log(Level.INFO, "Unabled to unregister Oracle JDBC Diagnosability MBean: " + ex.getMessage());
                }
            } else {
                Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Unable to find an MBeanServer to unregister Oracle JDBC Diagnosability MBean.");
            }
        }
        catch (Throwable ex) {
            Logger.getLogger("oracle.jdbc").log(Level.WARNING, "Error while unregistering Oracle JDBC Diagnosability MBean.", ex);
        }
    }

    private static void deregister() {
        OracleDriver.unRegisterMBeans();
        OracleTimeoutThreadPerVM.stopWatchdog();
        BlockSource.ThreadedCachingBlockSource.stopBlockReleaserThread();
        TimeoutInterruptHandler.stopTimer();
        if (threadPool != null) {
            threadPool.shutdownNow();
        }
        HAManager.shutdownAll();
        OracleDataSource.cleanup();
        TxnFailoverManagerImpl.cleanup();
        TcpMultiplexer.stop();
    }

    @Override
    public Connection connect(String url, @Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        return this.connect(url, info, AbstractConnectionBuilder.unconfigured());
    }

    public Connection connect(String url, @Blind(value=PropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        Connection conn;
        int extensionType;
        if (url == null) {
            throw (SQLException)DatabaseError.createSqlException(296).fillInStackTrace();
        }
        if (url.startsWith(SERVER_SIDE_DEFAULT_URL_PREFIX)) {
            url = OracleDriver.convertServerSideDefaultURL(url);
        }
        if (builder == null) {
            builder = AbstractConnectionBuilder.unconfigured();
        }
        Matcher serviceProviderMatcher = null;
        boolean urlFromProvider = false;
        serviceProviderMatcher = SERVICE_PROVIDER_URL.matcher(url);
        if (serviceProviderMatcher.matches()) {
            urlFromProvider = true;
            if (serviceProviderMatcher.group(2).length() > 0) {
                String[] userPassword = serviceProviderMatcher.group(2).split("/");
                info.put(user_string, userPassword[0]);
                info.put(password_string, userPassword[1]);
            }
            String providerType = serviceProviderMatcher.group(3);
            OracleConfigurationProvider provider = OracleConfigurationProvider.find(providerType);
            Properties properties = provider.getConnectionProperties(serviceProviderMatcher.group(4));
            boolean propertyRemoteConfigurationFiltering = this.getPropertyRemoteConfigurationFiltering(info);
            if (propertyRemoteConfigurationFiltering) {
                for (String key : properties.stringPropertyNames()) {
                    if (ProviderProperties.isProviderProperty(key) || GeneratedPhysicalConnection.isAllowedByProvider(key.toString())) continue;
                    if (key.equals("oracle.net.wallet_location") && !properties.getProperty("oracle.net.wallet_location").startsWith("data:")) {
                        throw (SQLException)DatabaseError.createSqlException(1733).fillInStackTrace();
                    }
                    throw (SQLException)DatabaseError.formatSqlException(null, 1729, null, null, key).fillInStackTrace();
                }
            }
            info.put("connection_url", properties.getProperty("URL"));
            info.putAll((Map<?, ?>)properties);
            url = properties.getProperty("URL");
        }
        if ((extensionType = OracleDriver.parseExtensionType(url)) == -2) {
            return null;
        }
        if (extensionType == -4) {
            return null;
        }
        if (builder.getGSSCredential() != null) {
            OracleDriver.ensureGSSCredentialSupport(extensionType);
        }
        OracleDriverExtension driverExtension = this.getDriverExtension(extensionType);
        if (info == null) {
            info = new Properties();
        }
        if (!url.matches(SIMPLE_URL_FORMAT)) {
            url = urlFromProvider ? OracleDriver.resolveNonSimpleURLFromProvider(url, info) : OracleDriver.resolveNonSimpleURL(url, info);
        }
        OracleDriver.ensureSingleRegisteredDriver();
        String translationProfile = OracleDriver.getTranslationProfile(extensionType, info);
        if (translationProfile != null) {
            conn = this.babelfishConnect(info, translationProfile, url, driverExtension, extensionType);
        } else {
            conn = driverExtension.getConnection(url, info, builder);
            OracleDriver.setConnectionProtocolID(conn, extensionType);
        }
        return conn;
    }

    private boolean getPropertyRemoteConfigurationFiltering(Properties info) {
        String remoteConfigurationFiltering = info.getProperty("oracle.jdbc.remoteConfigurationFiltering");
        boolean propertyWhiteListing = remoteConfigurationFiltering != null ? Boolean.valueOf(remoteConfigurationFiltering) : Boolean.valueOf(System.getProperty("oracle.jdbc.remoteConfigurationFiltering", "true"));
        return propertyWhiteListing;
    }

    public final CompletionStage<Connection> _INTERNAL_ORACLE_connectAsync(String url, @Blind(value=PropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) {
        OracleDriverExtension driverExtension;
        int extensionType;
        if (url == null) {
            return CompletionStageUtil.failedStage(DatabaseError.createSqlException(296).fillInStackTrace());
        }
        if (url.startsWith(SERVER_SIDE_DEFAULT_URL_PREFIX)) {
            return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connections are not supported by the server-side internal driver"));
        }
        try {
            extensionType = OracleDriver.parseExtensionType(url);
            if (extensionType == -2) {
                return CompletionStageUtil.completedStage(null);
            }
            if (builder != null && builder.getGSSCredential() != null) {
                OracleDriver.ensureGSSCredentialSupport(extensionType);
            }
            driverExtension = this.getDriverExtension(extensionType);
            if (info == null) {
                info = new Properties();
            }
            if (!url.matches(SIMPLE_URL_FORMAT)) {
                url = OracleDriver.resolveNonSimpleURL(url, info);
            }
            OracleDriver.ensureSingleRegisteredDriver();
        }
        catch (SQLException preConnectFailure) {
            return CompletionStageUtil.failedStage(preConnectFailure);
        }
        if (null != OracleDriver.getTranslationProfile(extensionType, info)) {
            return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connections do not support SQL translation."));
        }
        return driverExtension.getConnectionAsync(url, info, builder).thenApply(conn -> {
            OracleDriver.setConnectionProtocolID(conn, extensionType);
            return conn;
        });
    }

    private static final String convertServerSideDefaultURL(String serverSideDefaultURL) {
        if (serverSideDefaultURL.length() > SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH) {
            return "jdbc:oracle:kprb".concat(serverSideDefaultURL.substring(SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH));
        }
        return "jdbc:oracle:kprb".concat(":");
    }

    private static final int parseExtensionType(String url) throws SQLException {
        int extensionType = OracleDriver.oracleDriverExtensionTypeFromURL(url);
        if (extensionType == -3) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        return extensionType;
    }

    private static final void ensureGSSCredentialSupport(int extensionType) throws SQLException {
        if (!OracleDriver.isType4ExtensionType(extensionType)) {
            throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
        }
    }

    private static final boolean isType4ExtensionType(int extensionType) {
        return extensionType == 0;
    }

    private final OracleDriverExtension getDriverExtension(int extensionType) {
        OracleDriverExtension driverExtension = this.driverExtensions[extensionType];
        if (driverExtension == null) {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (driverExtension == null) {
                    this.driverExtensions[extensionType] = driverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[extensionType]).newInstance();
                } else {
                    driverExtension = this.driverExtensions[extensionType];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return driverExtension;
    }

    private static final String resolveNonSimpleURL(String nonSimpleURL, @Blind(value=PropertiesBlinder.class) Properties connectionProperties) throws SQLException {
        String resolvedURL = null;
        try {
            EZConnectResolver resolver = EZConnectResolver.newInstance(nonSimpleURL, connectionProperties);
            connectionProperties.putAll((Map<?, ?>)resolver.getProperties());
            resolvedURL = resolver.getResolvedUrl();
        }
        catch (NetException ne) {
            throw new SQLException(ne);
        }
        return resolvedURL == null ? nonSimpleURL : resolvedURL;
    }

    private static final String resolveNonSimpleURLFromProvider(String nonSimpleURL, @Blind(value=PropertiesBlinder.class) Properties connectionProperties) throws SQLException {
        String resolvedURL = null;
        try {
            EZConnectResolver resolver = EZConnectResolver.newInstance(nonSimpleURL);
            for (String key : resolver.getProperties().stringPropertyNames()) {
                if (GeneratedPhysicalConnection.isAllowedByProvider(key)) continue;
                throw (SQLException)DatabaseError.createSqlException(1729).fillInStackTrace();
            }
            connectionProperties.putAll((Map<?, ?>)resolver.getProperties());
            resolvedURL = resolver.getResolvedUrl();
        }
        catch (NetException ne) {
            throw new SQLException(ne);
        }
        return resolvedURL == null ? nonSimpleURL : resolvedURL;
    }

    private static final void ensureSingleRegisteredDriver() throws SQLException {
        Driver driverobj;
        Enumeration<Driver> enumdrivers = DriverManager.getDrivers();
        while (enumdrivers.hasMoreElements() && !((driverobj = enumdrivers.nextElement()) instanceof OracleDriver)) {
        }
        while (enumdrivers.hasMoreElements()) {
            driverobj = enumdrivers.nextElement();
            if (!(driverobj instanceof OracleDriver)) continue;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SQLException {
                        DriverManager.deregisterDriver(driverobj);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw (SQLException)ex.getException();
            }
        }
    }

    private static final String getTranslationProfile(int extensionType, @Blind(value=PropertiesBlinder.class) Properties connectionProperties) {
        if (extensionType == 2 && connectionProperties.containsKey("connection_pool") && connectionProperties.getProperty("connection_pool").equals("connection_pool")) {
            return null;
        }
        return connectionProperties != null ? connectionProperties.getProperty("oracle.jdbc.sqlTranslationProfile", PhysicalConnection.getSystemPropertySqlTranslationProfile()) : PhysicalConnection.getSystemPropertySqlTranslationProfile();
    }

    private static final void setConnectionProtocolID(Connection conn, int extensionType) {
        if (conn instanceof PhysicalConnection) {
            ((PhysicalConnection)conn).protocolId = extensionType;
        }
    }

    private Connection babelfishConnect(@Blind(value=PropertiesBlinder.class) Properties info, String tempval, String url, OracleDriverExtension driverExtension, int extensionType) throws SQLException {
        info.put("oracle.jdbc.sqlTranslationProfile", tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.sqlErrorTranslationFile");
        }
        if (tempval == null) {
            tempval = System.getProperty("oracle.jdbc.sqlErrorTranslationFile", null);
        }
        if (tempval != null) {
            info.put("oracle.jdbc.sqlErrorTranslationFile", tempval);
        }
        tempval = null;
        if (info != null && (tempval = info.getProperty(user_string)) == null) {
            tempval = info.getProperty("oracle.jdbc.user");
        }
        if (tempval == null) {
            tempval = System.getProperty("oracle.jdbc.user", null);
        }
        if (tempval == null) {
            Hashtable<String, String> url_props = PhysicalConnection.parseUrl(url);
            tempval = url_props.get(user_string);
        }
        info.put(user_string, tempval);
        ProxyFactory proxyFactory = ProxyFactory.createJDBCProxyFactory(BabelfishGenericProxy.class, BabelfishConnection.class, BabelfishStatement.class, BabelfishPreparedStatement.class, BabelfishCallableStatement.class);
        Translator trnsltr = TranslationManager.getTranslator(url, info.getProperty(user_string), info.getProperty("oracle.jdbc.sqlTranslationProfile"), info.getProperty("oracle.jdbc.sqlErrorTranslationFile"));
        try {
            PhysicalConnection conn = (PhysicalConnection)driverExtension.getConnection(url, info);
            conn.protocolId = extensionType;
            Connection babelfishConnection = proxyFactory.proxyFor(conn);
            ((BabelfishConnection)((Object)babelfishConnection)).setTranslator(trnsltr);
            trnsltr.activateServerTranslation(conn);
            return babelfishConnection;
        }
        catch (SQLException ex) {
            throw trnsltr.translateError(ex);
        }
    }

    public Connection defaultConnection() throws SQLException {
        if (defaultConn == null || defaultConn.isClosed()) {
            try (Monitor.CloseableLock lock = DEFAULT_CONN_MONITOR.acquireCloseableLock();){
                if (defaultConn == null || defaultConn.isClosed()) {
                    defaultConn = this.connect("jdbc:oracle:kprb:", new Properties());
                }
            }
        }
        return defaultConn;
    }

    static final int oracleDriverExtensionTypeFromURL(String url) {
        int second_colon;
        int first_colon = url.indexOf(58);
        if (first_colon == -1) {
            return -2;
        }
        if (!url.regionMatches(true, 0, jdbc_string, 0, first_colon)) {
            return -2;
        }
        if ((second_colon = url.indexOf(58, ++first_colon)) == -1) {
            return -2;
        }
        if (!url.regionMatches(true, first_colon, oracle_string, 0, second_colon - first_colon)) {
            return -2;
        }
        int third_colon = url.indexOf(58, ++second_colon);
        String sub_name = null;
        if (third_colon == -1) {
            return -3;
        }
        sub_name = url.substring(second_colon, third_colon);
        if (sub_name.equals("thin")) {
            return 0;
        }
        if (sub_name.equals("oci8") || sub_name.equals("oci")) {
            return 2;
        }
        if (sub_name.equals("nucleo")) {
            return -4;
        }
        return -3;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw (SQLException)DatabaseError.createSqlException(296).fillInStackTrace();
        }
        if (url.startsWith("jdbc:oracle:")) {
            return OracleDriver.oracleDriverExtensionTypeFromURL(url) > -2;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, @Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        Class<OracleConnection> oracleConnectionClass = OracleConnection.class;
        ArrayList<DriverPropertyInfo> driverInfo = new ArrayList<DriverPropertyInfo>(150);
        Field[] publicPropertiesFields = oracleConnectionClass.getFields();
        for (int i = 0; i < publicPropertiesFields.length; ++i) {
            String fieldName = publicPropertiesFields[i].getName();
            if (!fieldName.startsWith("CONNECTION_PROPERTY_") || fieldName.endsWith("_DEFAULT") || fieldName.endsWith("_ACCESSMODE")) continue;
            try {
                String propertyName = (String)publicPropertiesFields[i].get(null);
                if (ProviderProperties.isProviderProperty(propertyName)) continue;
                Field propertyDefaultField = oracleConnectionClass.getField(publicPropertiesFields[i].getName() + "_DEFAULT");
                String propertyValue = (String)propertyDefaultField.get(null);
                driverInfo.add(new DriverPropertyInfo(propertyName, propertyValue));
                continue;
            }
            catch (IllegalAccessException | NoSuchFieldException propertyName) {
                // empty catch block
            }
        }
        Hashtable<String, String> urlProperties = PhysicalConnection.parseUrl(url);
        for (int i = 0; i < driverInfo.size(); ++i) {
            DriverPropertyInfo existingInfo = (DriverPropertyInfo)driverInfo.get(i);
            String urlValue = urlProperties.get(existingInfo.name);
            if (urlValue == null) continue;
            existingInfo.value = urlValue;
        }
        ProviderProperties providerProperties = ProviderProperties.create(urlProperties, info);
        driverInfo.addAll(providerProperties.generatePropertyInfo());
        return driverInfo.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return OracleDatabaseMetaData.getDriverMajorVersionInfo();
    }

    @Override
    public int getMinorVersion() {
        return OracleDatabaseMetaData.getDriverMinorVersionInfo();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public String processSqlEscapes(String sqlString) throws SQLException {
        OracleSql sql = new OracleSql(null);
        sql.initialize(sqlString);
        return sql.parse();
    }

    public static String getCompileTime() {
        return BuildInfo.getBuildDate();
    }

    public static String getSystemPropertyFastConnectionFailover(String defaultValue) {
        return PhysicalConnection.getSystemPropertyFastConnectionFailover(defaultValue);
    }

    public static boolean getSystemPropertyDateZeroTime() {
        String sVal = PhysicalConnection.getSystemPropertyDateZeroTime("false");
        return sVal.equalsIgnoreCase("true");
    }

    public static boolean getSystemPropertyDateZeroTimeExtra() {
        String sVal = PhysicalConnection.getSystemPropertyDateZeroTimeExtra("false");
        return sVal.equalsIgnoreCase("true");
    }

    public static ExecutorService getExecutorService() throws SQLException {
        return threadPool;
    }

    public static void setExecutorService(ExecutorService pool) throws SQLException {
        if (threadPool != null) {
            threadPool.shutdownNow();
        }
        threadPool = pool;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(oracle_string);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    static {
        defaultConn = null;
        DEFAULT_CONN_MONITOR = Monitor.newInstance();
        defaultDriver = null;
        try {
            if (defaultDriver == null) {
                defaultDriver = new oracle.jdbc.OracleDriver();
                DriverManager.registerDriver(defaultDriver, OracleDriver::deregister);
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    OracleDriver.registerMBeans();
                    return null;
                }
            });
            Timestamp timestamp = Timestamp.valueOf("2000-01-01 00:00:00.0");
        }
        catch (RuntimeException | SQLException ex) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Exception in static block. " + ex.getMessage(), ex);
        }
        try {
            OraclePKIProvider ex = new OraclePKIProvider();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        systemTypeMap = new Hashtable(2);
        try {
            systemTypeMap.put("SYS.ANYDATA", Class.forName("oracle.sql.AnyDataFactory"));
            systemTypeMap.put("SYS.ANYTYPE", Class.forName("oracle.sql.TypeDescriptorFactory"));
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        DEFAULT_CONNECTION_PROPERTIES = new Properties();
        try {
            InputStream in = PhysicalConnection.class.getResourceAsStream(DEFAULT_CONNECTION_PROPERTIES_RESOURCE_NAME);
            if (in != null) {
                DEFAULT_CONNECTION_PROPERTIES.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger numCreatedThreads = new AtomicInteger(0);
            private static final String THREAD_NAME_PREFIX = "OJDBC-WORKER-THREAD-";

            @Override
            public Thread newThread(Runnable r) {
                Thread newT = new Thread(null, r, THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                newT.setPriority(5);
                newT.setDaemon(true);
                return newT;
            }
        });
        SERVER_SIDE_DEFAULT_URL_PREFIX_LENGTH = SERVER_SIDE_DEFAULT_URL_PREFIX.length();
        diagnosticMBeanObjectName = null;
    }
}

