/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.internal.OracleConnection;

public class OracleLocalTransaction
implements LocalTransaction {
    private OracleManagedConnection managedConnection = null;
    private Connection connection = null;
    boolean isBeginCalled = false;
    private static final String RAERR_LTXN_COMMIT = "commit without begin";
    private static final String RAERR_LTXN_ROLLBACK = "rollback without begin";

    OracleLocalTransaction(OracleManagedConnection omc) throws ResourceException {
        this.managedConnection = omc;
        this.connection = omc.getPhysicalConnection();
        this.isBeginCalled = false;
    }

    public void begin() throws ResourceException {
        try {
            if (((OracleConnection)this.connection).getTxnMode() == 1) {
                throw new IllegalStateException("Could not start a new transaction inside an active transaction");
            }
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
            this.isBeginCalled = true;
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
        this.managedConnection.eventOccurred(2);
    }

    public void commit() throws ResourceException {
        if (!this.isBeginCalled) {
            throw new LocalTransactionException("begin() must be called before commit()", RAERR_LTXN_COMMIT);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
        this.isBeginCalled = false;
        this.managedConnection.eventOccurred(3);
    }

    public void rollback() throws ResourceException {
        if (!this.isBeginCalled) {
            throw new LocalTransactionException("begin() must be called before rollback()", RAERR_LTXN_ROLLBACK);
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
        this.isBeginCalled = false;
        this.managedConnection.eventOccurred(4);
    }
}

