/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationsOverlay;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.DeclarationInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class FieldInfoImpl
extends DeclarationInfoImpl<org.jboss.jandex.FieldInfo>
implements FieldInfo {
    private final DotName className;
    private final String name;

    FieldInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, org.jboss.jandex.FieldInfo jandexDeclaration) {
        super(jandexIndex, annotationOverlays, jandexDeclaration);
        this.className = jandexDeclaration.declaringClass().name();
        this.name = jandexDeclaration.name();
    }

    public String name() {
        return ((org.jboss.jandex.FieldInfo)this.jandexDeclaration).name();
    }

    public Type type() {
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, ((org.jboss.jandex.FieldInfo)this.jandexDeclaration).type());
    }

    public boolean isStatic() {
        return Modifier.isStatic(((org.jboss.jandex.FieldInfo)this.jandexDeclaration).flags());
    }

    public boolean isFinal() {
        return Modifier.isFinal(((org.jboss.jandex.FieldInfo)this.jandexDeclaration).flags());
    }

    public int modifiers() {
        return ((org.jboss.jandex.FieldInfo)this.jandexDeclaration).flags();
    }

    public ClassInfo declaringClass() {
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlays, ((org.jboss.jandex.FieldInfo)this.jandexDeclaration).declaringClass());
    }

    @Override
    AnnotationsOverlay<org.jboss.jandex.FieldInfo> annotationsOverlay() {
        return this.annotationOverlays.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInfoImpl fieldInfo = (FieldInfoImpl)o;
        return Objects.equals(this.className, fieldInfo.className) && Objects.equals(this.name, fieldInfo.name);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.name);
    }
}

