/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Optional;
import org.keycloak.config.ExportOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import picocli.CommandLine;

final class ExportPropertyMappers {
    private ExportPropertyMappers() {
    }

    public static PropertyMapper<?>[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(ExportOptions.FILE).to("kc.spi-export-exporter").transformer(ExportPropertyMappers::transformExporter).paramLabel("file").build(), PropertyMapper.fromOption(ExportOptions.FILE).to("kc.spi-export-single-file-file").paramLabel("file").build(), PropertyMapper.fromOption(ExportOptions.DIR).to("kc.spi-export-dir-dir").paramLabel("dir").build(), PropertyMapper.fromOption(ExportOptions.REALM).to("kc.spi-export-single-file-realm-name").paramLabel("realm").build(), PropertyMapper.fromOption(ExportOptions.REALM).to("kc.spi-export-dir-realm-name").paramLabel("realm").build(), PropertyMapper.fromOption(ExportOptions.USERS).to("kc.spi-export-dir-users-export-strategy").paramLabel("strategy").build(), PropertyMapper.fromOption(ExportOptions.USERS_PER_FILE).to("kc.spi-export-dir-users-per-file").paramLabel("number").build()};
    }

    private static Optional<String> transformExporter(Optional<String> option, ConfigSourceInterceptorContext context) {
        ConfigValue exporter = context.proceed("kc.spi-export-exporter");
        if (exporter != null) {
            return Optional.of(exporter.getValue());
        }
        if (option.isPresent()) {
            return Optional.of("singleFile");
        }
        ConfigValue dirConfigValue = context.proceed("kc.spi-export-dir-dir");
        if (dirConfigValue != null && dirConfigValue.getValue() != null) {
            return Optional.of("dir");
        }
        ConfigValue dirValue = context.proceed("kc.dir");
        if (dirValue != null && dirValue.getValue() != null) {
            return Optional.of("dir");
        }
        if (System.getProperty("keycloak.migration.provider") == null) {
            throw new CommandLine.PicocliException("Must specify either --dir or --file options.");
        }
        return Optional.empty();
    }
}

