/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.JDBCException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConverter;

public class StandardSQLExceptionConverter
implements SQLExceptionConverter {
    private final List<SQLExceptionConversionDelegate> delegates;

    public StandardSQLExceptionConverter(SQLExceptionConversionDelegate ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    @Deprecated(since="6.0")
    public StandardSQLExceptionConverter() {
        this.delegates = new ArrayList<SQLExceptionConversionDelegate>();
    }

    @Deprecated(since="6.0")
    public void addDelegate(SQLExceptionConversionDelegate delegate) {
        if (delegate != null) {
            this.delegates.add(delegate);
        }
    }

    @Override
    public JDBCException convert(SQLException sqlException, String message, String sql) {
        for (SQLExceptionConversionDelegate delegate : this.delegates) {
            JDBCException jdbcException = delegate.convert(sqlException, message, sql);
            if (jdbcException == null) continue;
            return jdbcException;
        }
        return new GenericJDBCException(message, sqlException, sql);
    }
}

