/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.BadRequestException;
import org.keycloak.AbstractOAuthClient;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.Auth;
import org.keycloak.util.TokenUtil;

public abstract class AbstractSecuredLocalService {
    private static final Logger logger = Logger.getLogger(AbstractSecuredLocalService.class);
    protected final ClientModel client;
    protected final RealmModel realm;
    protected final HttpHeaders headers;
    protected final ClientConnection clientConnection;
    protected String stateChecker;
    protected final KeycloakSession session;
    protected final HttpRequest request;
    protected Auth auth;

    public AbstractSecuredLocalService(KeycloakSession session, ClientModel client) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.clientConnection = session.getContext().getConnection();
        this.client = client;
        this.request = session.getContext().getHttpRequest();
        this.headers = session.getContext().getRequestHeaders();
    }

    @Path(value="login-redirect")
    @GET
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @QueryParam(value="path") String path, @QueryParam(value="referrer") String referrer) {
        if (error != null) {
            if ("access_denied".equals(error)) {
                this.session.getContext().setClient(this.client);
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setError("noAccessMessage", new Object[0]).createErrorPage(Response.Status.FORBIDDEN);
            }
            logger.debug((Object)"error from oauth");
            throw new ForbiddenException("error");
        }
        if (path != null && !this.getValidPaths().contains(path)) {
            throw new BadRequestException("Invalid path");
        }
        if (!this.realm.isEnabled()) {
            logger.debug((Object)"realm not enabled");
            throw new ForbiddenException();
        }
        if (!this.client.isEnabled()) {
            logger.debug((Object)"account management app not enabled");
            throw new ForbiddenException();
        }
        if (code == null) {
            logger.debug((Object)"code not specified");
            throw new BadRequestException("code not specified");
        }
        if (state == null) {
            logger.debug((Object)"state not specified");
            throw new BadRequestException("state not specified");
        }
        KeycloakUriBuilder redirect = KeycloakUriBuilder.fromUri((URI)this.getBaseRedirectUri());
        if (path != null) {
            redirect.path(path);
        }
        if (referrer != null) {
            redirect.queryParam("referrer", new Object[]{referrer});
        }
        return Response.status((int)302).location(redirect.build(new Object[0])).build();
    }

    protected abstract Set<String> getValidPaths();

    protected abstract URI getBaseRedirectUri();

    protected Response login(String path) {
        String referrerUri;
        String referrer;
        OAuthRedirect oauth = new OAuthRedirect();
        String authUrl = OIDCLoginProtocolService.authUrl((UriInfo)this.session.getContext().getUri()).build(new Object[]{this.realm.getName()}).toString();
        oauth.setAuthUrl(authUrl);
        oauth.setClientId(this.client.getClientId());
        oauth.setSecure(this.realm.getSslRequired().isRequired(this.clientConnection));
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.getBaseRedirectUri()).path("login-redirect");
        if (path != null) {
            uriBuilder.queryParam("path", new Object[]{path});
        }
        if ((referrer = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer")) != null) {
            uriBuilder.queryParam("referrer", new Object[]{referrer});
        }
        if ((referrerUri = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer_uri")) != null) {
            uriBuilder.queryParam("referrer_uri", new Object[]{referrerUri});
        }
        URI accountUri = uriBuilder.build(new Object[]{this.realm.getName()});
        oauth.setStateCookiePath(accountUri.getRawPath());
        return oauth.redirect((UriInfo)this.session.getContext().getUri(), accountUri.toString());
    }

    static class OAuthRedirect
    extends AbstractOAuthClient {
        OAuthRedirect() {
        }

        public void stop() {
        }

        public Response redirect(UriInfo uriInfo, String redirectUri) {
            String state = this.getStateCode();
            String scopeParam = TokenUtil.attachOIDCScope((String)this.scope);
            UriBuilder uriBuilder = UriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{scopeParam});
            URI url = uriBuilder.build(new Object[0]);
            NewCookie cookie = new NewCookie(this.getStateCookieName(), state, this.getStateCookiePath(uriInfo), null, null, -1, this.isSecure, true);
            logger.debug((Object)("NewCookie: " + cookie.toString()));
            logger.debug((Object)("Oauth Redirect to: " + url));
            return Response.status((int)302).location(url).cookie(new NewCookie[]{cookie}).build();
        }

        private String getStateCookiePath(UriInfo uriInfo) {
            if (this.stateCookiePath != null) {
                return this.stateCookiePath;
            }
            return uriInfo.getBaseUri().getRawPath();
        }
    }
}

