/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractRsaKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigurationBuilder;

public abstract class AbstractGeneratedRsaKeyProviderFactory
extends AbstractRsaKeyProviderFactory {
    protected abstract Logger getLogger();

    public static final ProviderConfigurationBuilder rsaKeyConfigurationBuilder() {
        return ProviderConfigurationBuilder.create().property(Attributes.PRIORITY_PROPERTY).property(Attributes.ENABLED_PROPERTY).property(Attributes.ACTIVE_PROPERTY);
    }

    public boolean createFallbackKeys(KeycloakSession session, KeyUse keyUse, String algorithm) {
        if (this.isValidKeyUse(keyUse) && this.isSupportedRsaAlgorithm(algorithm)) {
            RealmModel realm = session.getContext().getRealm();
            ComponentModel generated = new ComponentModel();
            generated.setName("fallback-" + algorithm);
            generated.setParentId(realm.getId());
            generated.setProviderId(this.getId());
            generated.setProviderType(KeyProvider.class.getName());
            MultivaluedHashMap config = new MultivaluedHashMap();
            config.putSingle((Object)"priority", (Object)"-100");
            config.putSingle((Object)"algorithm", (Object)algorithm);
            generated.setConfig(config);
            realm.addComponentModel(generated);
            return true;
        }
        return false;
    }

    protected abstract boolean isValidKeyUse(KeyUse var1);

    protected abstract boolean isSupportedRsaAlgorithm(String var1);

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        super.validateConfiguration(session, realm, model);
        ConfigurationValidationHelper.check((ComponentModel)model).checkList(Attributes.KEY_SIZE_PROPERTY.get(), false);
        int size = model.get("keySize", 2048);
        if (!model.contains("privateKey") || !model.contains("certificate")) {
            this.generateKeys(realm, model, size);
            this.getLogger().debugv("Generated keys for {0}", (Object)realm.getName());
        } else {
            PrivateKey privateKey = PemUtils.decodePrivateKey((String)model.get("privateKey"));
            int currentSize = ((RSAPrivateKey)privateKey).getModulus().bitLength();
            if (currentSize != size) {
                this.generateKeys(realm, model, size);
                this.getLogger().debugv("Key size changed, generating new keys for {0}", (Object)realm.getName());
            }
        }
    }

    private void generateKeys(RealmModel realm, ComponentModel model, int size) {
        KeyPair keyPair;
        try {
            keyPair = KeyUtils.generateRsaKeyPair((int)size);
            model.put("privateKey", PemUtils.encodeKey((Key)keyPair.getPrivate()));
        }
        catch (Throwable t) {
            this.getLogger().warnf("Failed to generate keys for key provider '%s' in realm '%s'. Details: %s", (Object)model.getName(), (Object)realm.getName(), (Object)t.getMessage());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)t.getMessage(), t);
            }
            throw new ComponentValidationException("Failed to generate keys", t);
        }
        this.generateCertificate(realm, model, keyPair);
    }

    private void generateCertificate(RealmModel realm, ComponentModel model, KeyPair keyPair) {
        try {
            X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realm.getName());
            model.put("certificate", PemUtils.encodeCertificate((Certificate)certificate));
        }
        catch (Throwable t) {
            this.getLogger().warnf("Failed to generate certificate for key provider '%s' in realm '%s'. Details: %s", (Object)model.getName(), (Object)realm.getName(), (Object)t.getMessage());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)t.getMessage(), t);
            }
            throw new ComponentValidationException("Failed to generate certificate", t);
        }
    }
}

