/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.RealmModel;

public class LoAUtil {
    private static final Logger logger = Logger.getLogger(LoAUtil.class);

    public static int getCurrentLevelOfAuthentication(AuthenticatedClientSessionModel clientSession) {
        String clientSessionLoaNote = clientSession.getNote("level-of-authentication");
        return clientSessionLoaNote == null ? -1 : Integer.parseInt(clientSessionLoaNote);
    }

    public static Stream<Integer> getLoAConfiguredInRealmBrowserFlow(RealmModel realm) {
        Map<Integer, Integer> loaMaxAges = LoAUtil.getLoaMaxAgesConfiguredInRealmBrowserFlow(realm);
        if (loaMaxAges.isEmpty()) {
            return Stream.of(0, 1);
        }
        return Stream.concat(Stream.of(Integer.valueOf(0)), loaMaxAges.keySet().stream());
    }

    public static Map<Integer, Integer> getLoaMaxAgesConfiguredInRealmBrowserFlow(RealmModel realm) {
        List<AuthenticationExecutionModel> loaConditions = AuthenticatorUtil.getExecutionsByType(realm, realm.getBrowserFlow().getId(), "conditional-level-of-authentication");
        if (loaConditions.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Integer, Integer> loas = loaConditions.stream().map(authExecution -> realm.getAuthenticatorConfigById(authExecution.getAuthenticatorConfig())).filter(Objects::nonNull).filter(authConfig -> LoAUtil.getLevelFromLoaConditionConfiguration(authConfig) != null).collect(Collectors.toMap(LoAUtil::getLevelFromLoaConditionConfiguration, LoAUtil::getMaxAgeFromLoaConditionConfiguration));
        return loas;
    }

    public static Integer getLevelFromLoaConditionConfiguration(AuthenticatorConfigModel loaConditionConfig) {
        String levelAsStr = (String)loaConditionConfig.getConfig().get("loa-condition-level");
        try {
            return Integer.parseInt(levelAsStr);
        }
        catch (NullPointerException | NumberFormatException e) {
            logger.warnf("Invalid level '%s' configured for the configuration of LoA condition with alias '%s'. Level should be number.", (Object)levelAsStr, (Object)loaConditionConfig.getAlias());
            return null;
        }
    }

    public static int getMaxAgeFromLoaConditionConfiguration(AuthenticatorConfigModel loaConditionConfig) {
        try {
            return Integer.parseInt((String)loaConditionConfig.getConfig().get("loa-max-age"));
        }
        catch (NullPointerException | NumberFormatException e) {
            String storeLoaInUserSession = (String)loaConditionConfig.getConfig().get("loa-store-in-user-session");
            if (storeLoaInUserSession != null) {
                int maxAge = Boolean.parseBoolean(storeLoaInUserSession) ? 36000 : 0;
                logger.warnf("Max age not configured for condition '%s' in the authentication flow. Fallback to %d based on the configuration option %s from previous version", (Object)loaConditionConfig.getAlias(), (Object)maxAge, (Object)"loa-store-in-user-session");
                return maxAge;
            }
            logger.errorf("Invalid max age configured for condition '%s'. Fallback to 0", (Object)loaConditionConfig.getAlias());
            return 0;
        }
    }
}

