/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.HashMap;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.ScriptBasedAuthenticator;
import org.keycloak.authentication.authenticators.browser.ScriptBasedAuthenticatorFactory;
import org.keycloak.common.Profile;
import org.keycloak.deployment.DeployedConfigurationsManager;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.provider.ScriptProviderMetadata;

public final class DeployedScriptAuthenticatorFactory
extends ScriptBasedAuthenticatorFactory {
    private ScriptProviderMetadata metadata;
    private AuthenticatorConfigModel model;
    private List<ProviderConfigProperty> configProperties;
    private Authenticator authenticator = new ScriptBasedAuthenticator(){

        @Override
        protected AuthenticatorConfigModel getAuthenticatorConfig(AuthenticationFlowContext context) {
            return DeployedScriptAuthenticatorFactory.this.model;
        }
    };

    public DeployedScriptAuthenticatorFactory(ScriptProviderMetadata metadata) {
        this.metadata = metadata;
    }

    public DeployedScriptAuthenticatorFactory() {
    }

    @Override
    public Authenticator create(KeycloakSession session) {
        return this.authenticator;
    }

    @Override
    public String getId() {
        return this.metadata.getId();
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }

    @Override
    public String getDisplayType() {
        return this.model.getAlias();
    }

    @Override
    public String getHelpText() {
        return this.model.getAlias();
    }

    @Override
    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SCRIPTS);
    }

    @Override
    public void init(Config.Scope config) {
        this.model = this.createModel(this.metadata);
        this.configProperties = super.getConfigProperties();
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, session -> new DeployedConfigurationsManager(session).registerDeployedAuthenticatorConfig(this.model));
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public AuthenticatorConfigModel getConfig() {
        return this.model;
    }

    public void setMetadata(ScriptProviderMetadata metadata) {
        this.metadata = metadata;
    }

    public ScriptProviderMetadata getMetadata() {
        return this.metadata;
    }

    private AuthenticatorConfigModel createModel(ScriptProviderMetadata metadata) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(metadata.getId());
        model.setAlias(this.sanitizeString(metadata.getName()));
        HashMap<String, String> config = new HashMap<String, String>();
        model.setConfig(config);
        config.put("scriptName", metadata.getName());
        config.put("scriptCode", metadata.getCode());
        config.put("scriptDescription", metadata.getDescription());
        return model;
    }

    private String sanitizeString(String value) {
        return value.replace('/', '-').replace('.', '-');
    }
}

