/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership.role;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.role.RoleMapperConfig;

public class RoleLDAPStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "role-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties;
    protected static final Map<String, UserRolesRetrieveStrategy> userRolesStrategies;
    protected static final List<String> MEMBERSHIP_TYPES;
    protected static final List<String> MODES;
    protected static final List<String> NO_IMPORT_MODES;

    private static List<ProviderConfigProperty> getProps(ComponentModel parent) {
        LDAPConfig config;
        String roleObjectClasses = "groupOfNames";
        String mode = LDAPGroupMapperMode.LDAP_ONLY.toString();
        String membershipUserAttribute = "uid";
        boolean importEnabled = true;
        boolean isActiveDirectory = false;
        if (parent != null) {
            config = new LDAPConfig((MultivaluedHashMap<String, String>)parent.getConfig());
            roleObjectClasses = config.isActiveDirectory() ? "group" : "groupOfNames";
            mode = config.getEditMode() == UserStorageProvider.EditMode.WRITABLE ? LDAPGroupMapperMode.LDAP_ONLY.toString() : LDAPGroupMapperMode.READ_ONLY.toString();
            membershipUserAttribute = config.getUsernameLdapAttribute();
            importEnabled = new UserStorageProviderModel(parent).isImportEnabled();
            isActiveDirectory = config.isActiveDirectory();
        }
        config = ProviderConfigurationBuilder.create().property().name("roles.dn").label("LDAP Roles DN").helpText("LDAP DN where are roles of this tree saved. For example 'ou=finance,dc=example,dc=org' ").type("String").required(true).add().property().name("role.name.ldap.attribute").label("Role Name LDAP Attribute").helpText("Name of LDAP attribute, which is used in role objects for name and RDN of role. Usually it will be 'cn' . In this case typical group/role object may have DN like 'cn=role1,ou=finance,dc=example,dc=org' ").type("String").defaultValue((Object)"cn").add().property().name("role.object.classes").label("Role Object Classes").helpText("Object class (or classes) of the role object. It's divided by comma if more classes needed. In typical LDAP deployment it could be 'groupOfNames' . In Active Directory it's usually 'group' ").type("String").defaultValue((Object)roleObjectClasses).add().property().name("membership.ldap.attribute").label("Membership LDAP Attribute").helpText("Name of LDAP attribute on role, which is used for membership mappings. Usually it will be 'member' .However when 'Membership Attribute Type' is 'UID' then 'Membership LDAP Attribute' could be typically 'memberUid' .").type("String").defaultValue((Object)"member").add().property().name("membership.attribute.type").label("Membership Attribute Type").helpText("DN means that LDAP role has it's members declared in form of their full DN. For example 'member: uid=john,ou=users,dc=example,dc=com' . UID means that LDAP role has it's members declared in form of pure user uids. For example 'memberUid: john' .").type("List").options(MEMBERSHIP_TYPES).defaultValue((Object)MembershipType.DN.toString()).add().property().name("membership.user.ldap.attribute").label("Membership User LDAP Attribute").helpText("Used just if Membership Attribute Type is UID. It is name of LDAP attribute on user, which is used for membership mappings. Usually it will be 'uid' . For example if value of 'Membership User LDAP Attribute' is 'uid' and  LDAP group has  'memberUid: john', then it is expected that particular LDAP user will have attribute 'uid: john' .").type("String").defaultValue((Object)membershipUserAttribute).add().property().name("roles.ldap.filter").label("LDAP Filter").helpText("LDAP Filter adds additional custom filter to the whole query for retrieve LDAP roles. Leave this empty if no additional filtering is needed and you want to retrieve all roles from LDAP. Otherwise make sure that filter starts with '(' and ends with ')'").type("String").add();
        if (importEnabled) {
            config.property().name("mode").label("Mode").helpText("LDAP_ONLY means that all role mappings are retrieved from LDAP and saved into LDAP. READ_ONLY is Read-only LDAP mode where role mappings are retrieved from both LDAP and DB and merged together. New role grants are not saved to LDAP but to DB. IMPORT is Read-only LDAP mode where role mappings are retrieved from LDAP just at the time when user is imported from LDAP and then they are saved to local keycloak DB.").type("List").options(MODES).defaultValue((Object)mode).add();
        } else {
            config.property().name("mode").label("Mode").helpText("LDAP_ONLY means that specified role mappings are writable to LDAP. READ_ONLY means LDAP is readonly.").type("List").options(NO_IMPORT_MODES).defaultValue((Object)mode).add();
        }
        LinkedList<String> roleRetrievers = new LinkedList<String>(userRolesStrategies.keySet());
        Object roleRetrieveHelpText = "Specify how to retrieve roles of user. LOAD_ROLES_BY_MEMBER_ATTRIBUTE means that roles of user will be retrieved by sending LDAP query to retrieve all roles where 'member' is our user. GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE means that roles of user will be retrieved from 'memberOf' attribute of our user. Or from the other attribute specified by 'Member-Of LDAP Attribute' . ";
        if (isActiveDirectory) {
            roleRetrieveHelpText = (String)roleRetrieveHelpText + "LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY is applicable just in Active Directory and it means that roles of user will be retrieved recursively with usage of LDAP_MATCHING_RULE_IN_CHAIN Ldap extension.";
        } else {
            roleRetrievers.remove("LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY");
        }
        config.property().name("user.roles.retrieve.strategy").label("User Roles Retrieve Strategy").helpText((String)roleRetrieveHelpText).type("List").options(roleRetrievers).defaultValue((Object)"LOAD_ROLES_BY_MEMBER_ATTRIBUTE").add().property().name("memberof.ldap.attribute").label("Member-Of LDAP Attribute").helpText("Used just when 'User Roles Retrieve Strategy' is GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE . It specifies the name of the LDAP attribute on the LDAP user, which contains the roles (LDAP Groups), which the user is member of. Usually it will be 'memberOf' and that's also the default value.").type("String").defaultValue((Object)"memberOf").add().property().name("use.realm.roles.mapping").label("Use Realm Roles Mapping").helpText("If true, then LDAP role mappings will be mapped to realm role mappings in Keycloak. Otherwise it will be mapped to client role mappings").type("boolean").defaultValue((Object)"true").add().property().name("client.id").label("Client ID").helpText("Client ID of client to which LDAP role mappings will be mapped. Applicable just if 'Use Realm Roles Mapping' is false").type("ClientList").add();
        return config.build();
    }

    @Override
    public void onParentUpdate(RealmModel realm, UserStorageProviderModel oldParent, UserStorageProviderModel newParent, ComponentModel mapperModel) {
        if (!newParent.isImportEnabled() && new RoleMapperConfig(mapperModel).getMode() == LDAPGroupMapperMode.IMPORT) {
            mapperModel.getConfig().putSingle((Object)"mode", (Object)LDAPGroupMapperMode.READ_ONLY.toString());
            realm.updateComponent(mapperModel);
        }
    }

    @Override
    public void onCreate(KeycloakSession session, RealmModel realm, ComponentModel model) {
        ComponentModel parentModel = realm.getComponent(model.getParentId());
        UserStorageProviderModel parent = new UserStorageProviderModel(parentModel);
        this.onParentUpdate(realm, parent, parent, model);
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        ComponentModel parentModel = realm.getComponent(newModel.getParentId());
        UserStorageProviderModel parent = new UserStorageProviderModel(parentModel);
        this.onParentUpdate(realm, parent, parent, newModel);
    }

    @Override
    public String getHelpText() {
        return "Used to map role mappings of roles from some LDAP DN to Keycloak role mappings of either realm roles or client roles of particular client";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public List<ProviderConfigProperty> getConfigProperties(RealmModel realm, ComponentModel parent) {
        return RoleLDAPStorageMapperFactory.getProps(parent);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, Object> getTypeMetadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("fedToKeycloakSyncSupported", true);
        metadata.put("fedToKeycloakSyncMessage", "sync-ldap-roles-to-keycloak");
        metadata.put("keycloakToFedSyncSupported", true);
        metadata.put("keycloakToFedSyncMessage", "sync-keycloak-roles-to-ldap");
        return metadata;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        String clientId;
        this.checkMandatoryConfigAttribute("roles.dn", "LDAP Roles DN", config);
        this.checkMandatoryConfigAttribute("mode", "Mode", config);
        String realmMappings = (String)config.getConfig().getFirst((Object)"use.realm.roles.mapping");
        boolean useRealmMappings = Boolean.parseBoolean(realmMappings);
        if (!useRealmMappings && ((clientId = (String)config.getConfig().getFirst((Object)"client.id")) == null || clientId.trim().isEmpty())) {
            throw new ComponentValidationException("ldapErrorMissingClientId", new Object[0]);
        }
        LDAPUtils.validateCustomLdapFilter((String)config.getConfig().getFirst((Object)"roles.ldap.filter"));
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new RoleLDAPStorageMapper(mapperModel, federationProvider, this);
    }

    protected UserRolesRetrieveStrategy getUserRolesRetrieveStrategy(String strategyKey) {
        return userRolesStrategies.get(strategyKey);
    }

    static {
        userRolesStrategies = new LinkedHashMap<String, UserRolesRetrieveStrategy>();
        MEMBERSHIP_TYPES = new LinkedList<String>();
        MODES = new LinkedList<String>();
        NO_IMPORT_MODES = new LinkedList<String>();
        userRolesStrategies.put("LOAD_ROLES_BY_MEMBER_ATTRIBUTE", new UserRolesRetrieveStrategy.LoadRolesByMember());
        userRolesStrategies.put("GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE", new UserRolesRetrieveStrategy.GetRolesFromUserMemberOfAttribute());
        userRolesStrategies.put("LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY", new UserRolesRetrieveStrategy.LoadRolesByMemberRecursively());
        for (MembershipType membershipType : MembershipType.values()) {
            MEMBERSHIP_TYPES.add(membershipType.toString());
        }
        for (Enum enum_ : LDAPGroupMapperMode.values()) {
            MODES.add(enum_.toString());
        }
        NO_IMPORT_MODES.add(LDAPGroupMapperMode.LDAP_ONLY.toString());
        NO_IMPORT_MODES.add(LDAPGroupMapperMode.READ_ONLY.toString());
        List<ProviderConfigProperty> config = RoleLDAPStorageMapperFactory.getProps(null);
        configProperties = config;
    }
}

