/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Arrays;

public class BcDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected BcTlsCrypto crypto;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public BcDefaultTlsCredentialedDecryptor(BcTlsCrypto bcTlsCrypto, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (bcTlsCrypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(asymmetricKeyParameter instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.crypto = bcTlsCrypto;
        this.certificate = certificate;
        this.privateKey = asymmetricKeyParameter;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters tlsCryptoParameters, byte[] byArray) throws IOException {
        return this.safeDecryptPreMasterSecret(tlsCryptoParameters, (RSAKeyParameters)this.privateKey, byArray);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters tlsCryptoParameters, RSAKeyParameters rSAKeyParameters, byte[] byArray) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion protocolVersion = tlsCryptoParameters.getRSAPreMasterSecretVersion();
        boolean bl = false;
        byte[] byArray2 = new byte[48];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = Arrays.clone((byte[])byArray2);
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine(), byArray2);
            pKCS1Encoding.init(false, (CipherParameters)new ParametersWithRandom((CipherParameters)rSAKeyParameters, secureRandom));
            byArray3 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl || TlsImplUtils.isTLSv11(protocolVersion)) {
            int n = protocolVersion.getMajorVersion() ^ byArray3[0] & 0xFF | protocolVersion.getMinorVersion() ^ byArray3[1] & 0xFF;
            n = n - 1 >> 31;
            for (int i = 0; i < 48; ++i) {
                byArray3[i] = (byte)(byArray3[i] & n | byArray2[i] & ~n);
            }
        }
        return this.crypto.createSecret(byArray3);
    }
}

