/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.util.logging.Level;
import org.jruby.util.log.Logger;

public class JULLogger
implements Logger {
    private final java.util.logging.Logger logger;

    public JULLogger(String loggerName) {
        this(java.util.logging.Logger.getLogger(loggerName));
    }

    public JULLogger(Class<?> loggerClass) {
        this(java.util.logging.Logger.getLogger(loggerClass.getName()));
    }

    protected JULLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void warn(String message2, Object ... args2) {
        this.log(Level.WARNING, JULLogger.adjustPattern(message2), args2);
    }

    @Override
    public void warn(Throwable throwable) {
        this.log(Level.WARNING, null, throwable);
    }

    @Override
    public void warn(String message2, Throwable throwable) {
        this.log(Level.WARNING, message2, throwable);
    }

    @Override
    public void error(String message2, Object ... args2) {
        this.log(Level.SEVERE, JULLogger.adjustPattern(message2), args2);
    }

    @Override
    public void error(Throwable throwable) {
        this.log(Level.SEVERE, null, throwable);
    }

    @Override
    public void error(String message2, Throwable throwable) {
        this.log(Level.SEVERE, message2, throwable);
    }

    @Override
    public void info(String message2, Object ... args2) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, JULLogger.adjustPattern(message2), args2);
        }
    }

    @Override
    public void info(Throwable throwable) {
        this.log(Level.INFO, null, throwable);
    }

    @Override
    public void info(String message2, Throwable throwable) {
        this.log(Level.INFO, message2, throwable);
    }

    @Override
    public void debug(String message2, Object ... args2) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, JULLogger.adjustPattern(message2), args2);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        this.log(Level.FINE, null, throwable);
    }

    @Override
    public void debug(String message2, Throwable throwable) {
        this.log(Level.FINE, message2, throwable);
    }

    protected void log(Level level2, String message2, Object ... args2) {
        String souceClass = null;
        String souceMethod = null;
        this.logger.logp(level2, souceClass, souceMethod, message2, args2);
    }

    protected void log(Level level2, String message2, Throwable ex) {
        String souceClass = null;
        String souceMethod = null;
        this.logger.logp(level2, souceClass, souceMethod, message2, ex);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnable(boolean debug) {
        this.logger.setLevel(debug ? Level.FINE : Level.INFO);
    }

    static String adjustPattern(String messagePattern) {
        if (messagePattern == null) {
            return null;
        }
        StringBuilder julPattern = null;
        int len = messagePattern.length();
        int last2 = 0;
        int counter = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (messagePattern.charAt(i2) != '{' || i2 != 0 && (i2 <= 0 || messagePattern.charAt(i2 - 1) == '\\') || i2 >= len - 1 || messagePattern.charAt(i2 + 1) != '}') continue;
            if (julPattern == null) {
                julPattern = new StringBuilder(len + 8);
            }
            julPattern.append(messagePattern, last2, i2).append('{').append(counter++).append('}');
            last2 = i2 + 2;
        }
        if (julPattern != null) {
            if (last2 < len) {
                julPattern.append(messagePattern, last2, len);
            }
            return julPattern.toString();
        }
        return messagePattern;
    }
}

