/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandResultBaseInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class LoadFrameClosureInstr
extends NoOperandResultBaseInstr
implements FixedArityInstr {
    public LoadFrameClosureInstr(Variable result2) {
        super(Operation.LOAD_FRAME_CLOSURE, result2);
        assert (result2 != null) : "LoadFrameClosureInstr result is null";
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new LoadFrameClosureInstr(info.getRenamedVariable(this.result));
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.getCallClosure() instanceof WrappedIRClosure) {
            return NopInstr.NOP;
        }
        return new CopyInstr(ii.getRenamedVariable(this.result), ii.getCallClosure());
    }

    public static LoadFrameClosureInstr decode(IRReaderDecoder d) {
        return new LoadFrameClosureInstr(d.decodeVariable());
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        super.computeScopeFlags(scope, flags2);
        flags2.add(IRFlags.REQUIRES_BLOCK);
        return true;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LoadFrameClosure(this);
    }
}

