/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.SplitSuperState;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.util.cli.Options;

public abstract class AbstractIRMethod
extends DynamicMethod
implements IRMethodArgs,
PositionAware,
Cloneable {
    protected final Signature signature;
    protected IRScope method;
    protected final int line;
    protected final StaticScope staticScope;
    protected int callCount = 0;
    protected transient InterpreterContext interpreterContext;
    private transient MethodData methodData;
    private boolean ruby2Keywords;

    public AbstractIRMethod(IRScope method2, Visibility visibility, RubyModule implementationClass) {
        this(method2.getStaticScope(), method2.getId(), method2.getLine(), visibility, implementationClass);
        this.method = method2;
    }

    public AbstractIRMethod(StaticScope scope, String id2, int line, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, id2);
        this.staticScope = scope;
        this.staticScope.determineModule();
        this.signature = this.staticScope.getSignature();
        this.line = line;
        Ruby runtime2 = implementationClass.getRuntime();
        if (IRRuntimeHelpers.shouldPrintIR(runtime2)) {
            this.ensureInstrsReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractIRMethod> void tryJit(ThreadContext context, T self2) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isBooting() && !Options.JIT_KERNEL.load().booleanValue()) {
            return;
        }
        if (self2.callCount < 0) {
            return;
        }
        if (self2.callCount++ >= runtime2.getInstanceConfig().getJitThreshold()) {
            T t = self2;
            synchronized (t) {
                if (self2.callCount >= 0) {
                    self2.callCount = Integer.MIN_VALUE;
                    runtime2.getJITCompiler().buildThresholdReached(context, (Compilable)((Object)self2));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCallCount(int callCount) {
        AbstractIRMethod abstractIRMethod = this;
        synchronized (abstractIRMethod) {
            this.callCount = callCount;
        }
    }

    public IRScope getIRScope() {
        try {
            if (this.method == null) {
                this.method = this.staticScope.getIRScope();
            }
            return this.method;
        }
        catch (Exception e) {
            return null;
        }
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        this.ensureInstrsReady();
        return ((IRMethod)this.getIRScope()).getArgumentDescriptors();
    }

    public InterpreterContext ensureInstrsReady() {
        InterpreterContext interpreterContext = this.interpreterContext;
        if (interpreterContext == null) {
            this.interpreterContext = this.retrieveInterpreterContext();
            return this.interpreterContext;
        }
        return interpreterContext;
    }

    private InterpreterContext retrieveInterpreterContext() {
        IRScope method2 = this.getIRScope();
        InterpreterContext interpreterContext = method2.builtInterpreterContext();
        if (IRRuntimeHelpers.shouldPrintIR(this.implementationClass.getRuntime())) {
            this.printMethodIR();
        }
        return interpreterContext;
    }

    protected abstract void printMethodIR();

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    @Deprecated
    public Arity getArity() {
        return this.signature.arity();
    }

    @Override
    public DynamicMethod dup() {
        return (DynamicMethod)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("not cloneable: " + this);
        }
    }

    @Override
    public String getFile() {
        return this.staticScope.getFile();
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public MethodData getMethodData() {
        if (this.methodData == null) {
            this.methodData = ((IRMethod)this.getIRScope()).getMethodData();
        }
        return this.methodData;
    }

    @Override
    public Collection<String> getInstanceVariableNames() {
        return this.staticScope.getInstanceVariableNames();
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + ' ' + this.getIRScope() + ' ' + this.getSignature();
    }

    public boolean needsToFindImplementer() {
        this.ensureInstrsReady();
        IRScope irScope = this.getIRScope();
        return !(irScope instanceof IRMethod) || irScope.getInterpreterContext().getFlags().contains((Object)IRFlags.REQUIRES_CLASS);
    }

    @Override
    public void setRuby2Keywords() {
        this.ruby2Keywords = true;
        this.getIRScope().setRuby2Keywords();
    }

    public boolean getRuby2Keywords() {
        return this.ruby2Keywords;
    }

    public abstract SplitSuperState startSplitSuperCall(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public abstract void finishSplitCall(SplitSuperState var1);
}

