/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import jnr.constants.platform.IP;

public class MulticastStateManager {
    private MulticastSocket multicastSocket;
    private final ArrayList membershipGroups = new ArrayList();
    public static final int IP_ADD_MEMBERSHIP = IP.IP_ADD_MEMBERSHIP.intValue();

    public void addMembership(byte[] ipaddr_buf) throws IOException {
        String ipString = "";
        if (ipaddr_buf.length >= 4) {
            ipString = ipString + String.valueOf(ipaddr_buf[0] & 0xFF);
            ipString = ipString + ".";
            ipString = ipString + String.valueOf(ipaddr_buf[1] & 0xFF);
            ipString = ipString + ".";
            ipString = ipString + String.valueOf(ipaddr_buf[2] & 0xFF);
            ipString = ipString + ".";
            ipString = ipString + String.valueOf(ipaddr_buf[3] & 0xFF);
        }
        this.membershipGroups.add(ipString);
        this.updateMemberships();
    }

    public void rebindToPort(int port) throws IOException {
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
        }
        this.multicastSocket = new MulticastSocket(port);
        this.updateMemberships();
    }

    public MulticastSocket getMulticastSocket() {
        return this.multicastSocket;
    }

    private void updateMemberships() throws IOException {
        if (this.multicastSocket == null) {
            return;
        }
        for (int i2 = 0; i2 < this.membershipGroups.size(); ++i2) {
            String ipString = (String)this.membershipGroups.get(i2);
            InetAddress group2 = InetAddress.getByName(ipString);
            this.multicastSocket.joinGroup(new InetSocketAddress(group2, 0), null);
        }
    }
}

