/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux.powerpc64;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum SocketOption implements Constant
{
    SO_DEBUG(1L),
    SO_ACCEPTCONN(30L),
    SO_REUSEADDR(2L),
    SO_KEEPALIVE(9L),
    SO_DONTROUTE(5L),
    SO_BROADCAST(6L),
    SO_LINGER(13L),
    SO_OOBINLINE(10L),
    SO_REUSEPORT(15L),
    SO_TIMESTAMP(29L),
    SO_SNDBUF(7L),
    SO_RCVBUF(8L),
    SO_SNDLOWAT(17L),
    SO_RCVLOWAT(16L),
    SO_SNDTIMEO(19L),
    SO_RCVTIMEO(18L),
    SO_ERROR(4L),
    SO_TYPE(3L),
    SO_ATTACH_FILTER(26L),
    SO_BINDTODEVICE(25L),
    SO_DETACH_FILTER(27L),
    SO_NO_CHECK(11L),
    SO_PASSCRED(20L),
    SO_PEERCRED(21L),
    SO_PEERNAME(28L),
    SO_PRIORITY(12L),
    SO_SECURITY_AUTHENTICATION(22L),
    SO_SECURITY_ENCRYPTION_NETWORK(24L),
    SO_SECURITY_ENCRYPTION_TRANSPORT(23L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 30L;

    private SocketOption(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<SocketOption, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<SocketOption, String> generateTable() {
            EnumMap<SocketOption, String> map2 = new EnumMap<SocketOption, String>(SocketOption.class);
            map2.put(SO_DEBUG, "SO_DEBUG");
            map2.put(SO_ACCEPTCONN, "SO_ACCEPTCONN");
            map2.put(SO_REUSEADDR, "SO_REUSEADDR");
            map2.put(SO_KEEPALIVE, "SO_KEEPALIVE");
            map2.put(SO_DONTROUTE, "SO_DONTROUTE");
            map2.put(SO_BROADCAST, "SO_BROADCAST");
            map2.put(SO_LINGER, "SO_LINGER");
            map2.put(SO_OOBINLINE, "SO_OOBINLINE");
            map2.put(SO_REUSEPORT, "SO_REUSEPORT");
            map2.put(SO_TIMESTAMP, "SO_TIMESTAMP");
            map2.put(SO_SNDBUF, "SO_SNDBUF");
            map2.put(SO_RCVBUF, "SO_RCVBUF");
            map2.put(SO_SNDLOWAT, "SO_SNDLOWAT");
            map2.put(SO_RCVLOWAT, "SO_RCVLOWAT");
            map2.put(SO_SNDTIMEO, "SO_SNDTIMEO");
            map2.put(SO_RCVTIMEO, "SO_RCVTIMEO");
            map2.put(SO_ERROR, "SO_ERROR");
            map2.put(SO_TYPE, "SO_TYPE");
            map2.put(SO_ATTACH_FILTER, "SO_ATTACH_FILTER");
            map2.put(SO_BINDTODEVICE, "SO_BINDTODEVICE");
            map2.put(SO_DETACH_FILTER, "SO_DETACH_FILTER");
            map2.put(SO_NO_CHECK, "SO_NO_CHECK");
            map2.put(SO_PASSCRED, "SO_PASSCRED");
            map2.put(SO_PEERCRED, "SO_PEERCRED");
            map2.put(SO_PEERNAME, "SO_PEERNAME");
            map2.put(SO_PRIORITY, "SO_PRIORITY");
            map2.put(SO_SECURITY_AUTHENTICATION, "SO_SECURITY_AUTHENTICATION");
            map2.put(SO_SECURITY_ENCRYPTION_NETWORK, "SO_SECURITY_ENCRYPTION_NETWORK");
            map2.put(SO_SECURITY_ENCRYPTION_TRANSPORT, "SO_SECURITY_ENCRYPTION_TRANSPORT");
            return map2;
        }
    }
}

