/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.util.NumberUtil;

public class ResourceOperation {
    private final BuildOperationContext context;
    private final Type operationType;
    private long contentLengthBytes;
    private String contentLengthString;
    private long loggedKBytes;
    private long totalProcessedBytes;

    public ResourceOperation(BuildOperationContext context, Type type) {
        this.context = context;
        this.operationType = type;
    }

    public void setContentLength(long contentLength) {
        this.contentLengthBytes = contentLength;
        this.contentLengthString = contentLength <= 0L ? String.format(" %sed", new Object[]{this.operationType}) : String.format("/%s %sed", new Object[]{NumberUtil.formatBytes((Long)contentLength), this.operationType});
    }

    public long getTotalProcessedBytes() {
        return this.totalProcessedBytes;
    }

    public void logProcessedBytes(long processedBytes) {
        this.totalProcessedBytes += processedBytes;
        long processedKiB = this.totalProcessedBytes / 1024L;
        if (processedKiB > this.loggedKBytes) {
            this.loggedKBytes = processedKiB;
            String progressMessage = NumberUtil.formatBytes((Long)this.totalProcessedBytes) + this.contentLengthString;
            this.context.progress(this.totalProcessedBytes, this.contentLengthBytes, "bytes", progressMessage);
        }
    }

    public static enum Type {
        download,
        upload;

    }
}

