/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.util.Collections;
import java.util.List;
import org.gradle.internal.event.ListenerNotificationException;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;

public class FailsafeBuildProgressListenerAdapter
implements InternalBuildProgressListener {
    private final InternalBuildProgressListener delegate;
    private Throwable listenerFailure;

    public FailsafeBuildProgressListenerAdapter(InternalBuildProgressListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onEvent(Object event) {
        if (this.listenerFailure != null) {
            return;
        }
        try {
            this.delegate.onEvent(event);
        }
        catch (Throwable t) {
            this.listenerFailure = t;
        }
    }

    @Override
    public List<String> getSubscribedOperations() {
        return this.delegate.getSubscribedOperations();
    }

    public void rethrowErrors() {
        if (this.listenerFailure != null) {
            throw new ListenerNotificationException(null, "One or more progress listeners failed with an exception.", Collections.singletonList(this.listenerFailure));
        }
    }
}

