/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import javax.annotation.Nullable;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.internal.TextUtil;

public abstract class ConfigurationTargetIdentifier {
    private ConfigurationTargetIdentifier() {
    }

    public abstract Type getTargetType();

    @Nullable
    public abstract String getTargetPath();

    public abstract String getBuildPath();

    @Nullable
    public static ConfigurationTargetIdentifier of(Object any) {
        if (any instanceof PluginAwareInternal) {
            return ((PluginAwareInternal)any).getConfigurationTargetIdentifier();
        }
        return null;
    }

    public static ConfigurationTargetIdentifier of(final ProjectInternal project) {
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.PROJECT;
            }

            @Override
            @Nullable
            public String getTargetPath() {
                return project.getProjectPath().getPath();
            }

            @Override
            public String getBuildPath() {
                return project.getGradle().getIdentityPath().getPath();
            }
        };
    }

    public static ConfigurationTargetIdentifier of(final SettingsInternal settings) {
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.SETTINGS;
            }

            @Override
            @Nullable
            public String getTargetPath() {
                return null;
            }

            @Override
            public String getBuildPath() {
                return settings.getGradle().getIdentityPath().getPath();
            }
        };
    }

    public static ConfigurationTargetIdentifier of(final GradleInternal gradle) {
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.GRADLE;
            }

            @Override
            @Nullable
            public String getTargetPath() {
                return null;
            }

            @Override
            public String getBuildPath() {
                return gradle.getIdentityPath().getPath();
            }
        };
    }

    public static enum Type {
        GRADLE,
        SETTINGS,
        PROJECT;

        public final String label = TextUtil.toLowerCaseLocaleSafe((String)this.name());
    }
}

