/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColRules;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.util.test.FreeColTestCase;

public final class SpecificationTest
extends FreeColTestCase {
    private static final BuildingType depotType = SpecificationTest.spec().getBuildingType("model.building.depot");
    private static final GoodsType fishType = SpecificationTest.spec().getGoodsType("model.goods.fish");
    private static final GoodsType foodType = SpecificationTest.spec().getPrimaryFoodType();
    private static final GoodsType horsesType = SpecificationTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType musketsType = SpecificationTest.spec().getGoodsType("model.goods.muskets");
    private static final GoodsType toolsType = SpecificationTest.spec().getGoodsType("model.goods.tools");
    private static final Role armedBraveRole = SpecificationTest.spec().getRole("model.role.armedBrave");
    private static final Role cavalryRole = SpecificationTest.spec().getRole("model.role.cavalry");
    private static final Role dragoonRole = SpecificationTest.spec().getRole("model.role.dragoon");
    private static final Role infantryRole = SpecificationTest.spec().getRole("model.role.infantry");
    private static final Role missionaryRole = SpecificationTest.spec().getRole("model.role.missionary");
    private static final Role nativeDragoonRole = SpecificationTest.spec().getRole("model.role.nativeDragoon");
    private static final Role soldierRole = SpecificationTest.spec().getRole("model.role.soldier");
    private static final UnitType blackSmithType = SpecificationTest.spec().getUnitType("model.unit.masterBlacksmith");
    private static final UnitType braveType = SpecificationTest.spec().getUnitType("model.unit.brave");
    private static final UnitType caravelType = SpecificationTest.spec().getUnitType("model.unit.caravel");
    private static final UnitType freeColonistType = SpecificationTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType kingsRegularType = SpecificationTest.spec().getUnitType("model.unit.kingsRegular");
    private static final UnitType privateerType = SpecificationTest.spec().getUnitType("model.unit.privateer");
    private static final UnitType wagonType = SpecificationTest.spec().getUnitType("model.unit.wagonTrain");

    public void testLoad() {
        Specification spec = null;
        try {
            spec = FreeColRules.getFreeColRulesFile("classic").getSpecification();
        }
        catch (Exception e) {
            e.printStackTrace();
            SpecificationTest.fail();
        }
        SpecificationTest.assertNotNull((Object)spec);
    }

    public void testUnitAbilities() {
        SpecificationTest.assertTrue((boolean)freeColonistType.hasAbility("model.ability.foundColony"));
        SpecificationTest.assertFalse((boolean)freeColonistType.hasAbility("model.ability.bornInIndianSettlement"));
        SpecificationTest.assertTrue((boolean)freeColonistType.isRecruitable());
        SpecificationTest.assertFalse((boolean)freeColonistType.hasAbility("model.ability.navalUnit"));
        SpecificationTest.assertFalse((boolean)freeColonistType.hasAbility("model.ability.carryGoods"));
        SpecificationTest.assertFalse((boolean)freeColonistType.hasAbility("model.ability.carryUnits"));
        SpecificationTest.assertFalse((boolean)freeColonistType.hasAbility("model.ability.captureGoods"));
        SpecificationTest.assertFalse((boolean)wagonType.hasAbility("model.ability.foundColony"));
        SpecificationTest.assertFalse((boolean)wagonType.isRecruitable());
        SpecificationTest.assertFalse((boolean)wagonType.hasAbility("model.ability.navalUnit"));
        SpecificationTest.assertTrue((boolean)wagonType.hasAbility("model.ability.carryGoods"));
        SpecificationTest.assertFalse((boolean)wagonType.hasAbility("model.ability.carryUnits"));
        SpecificationTest.assertFalse((boolean)wagonType.hasAbility("model.ability.captureGoods"));
        SpecificationTest.assertTrue((boolean)braveType.hasAbility("model.ability.bornInIndianSettlement"));
        SpecificationTest.assertFalse((boolean)braveType.isRecruitable());
        SpecificationTest.assertFalse((boolean)braveType.hasAbility("model.ability.navalUnit"));
        SpecificationTest.assertTrue((boolean)braveType.hasAbility("model.ability.carryGoods"));
        SpecificationTest.assertFalse((boolean)braveType.hasAbility("model.ability.carryUnits"));
        SpecificationTest.assertFalse((boolean)braveType.hasAbility("model.ability.captureGoods"));
        SpecificationTest.assertFalse((boolean)caravelType.hasAbility("model.ability.foundColony"));
        SpecificationTest.assertFalse((boolean)caravelType.isRecruitable());
        SpecificationTest.assertTrue((boolean)caravelType.hasAbility("model.ability.navalUnit"));
        SpecificationTest.assertTrue((boolean)caravelType.hasAbility("model.ability.carryGoods"));
        SpecificationTest.assertTrue((boolean)caravelType.hasAbility("model.ability.carryUnits"));
        SpecificationTest.assertFalse((boolean)caravelType.hasAbility("model.ability.captureGoods"));
        SpecificationTest.assertFalse((boolean)privateerType.hasAbility("model.ability.foundColony"));
        SpecificationTest.assertFalse((boolean)privateerType.isRecruitable());
        SpecificationTest.assertTrue((boolean)privateerType.hasAbility("model.ability.navalUnit"));
        SpecificationTest.assertTrue((boolean)privateerType.hasAbility("model.ability.carryGoods"));
        SpecificationTest.assertTrue((boolean)privateerType.hasAbility("model.ability.carryUnits"));
        SpecificationTest.assertTrue((boolean)privateerType.hasAbility("model.ability.captureGoods"));
    }

    public void testFoundingFathers() {
        FoundingFather smith = SpecificationTest.spec().getFoundingFather("model.foundingFather.adamSmith");
        SpecificationTest.assertNotNull((Object)smith);
        SpecificationTest.assertEquals((Object)((Object)FoundingFather.FoundingFatherType.TRADE), (Object)((Object)smith.getType()));
        SpecificationTest.assertTrue((smith.getWeight(0) >= 0 ? 1 : 0) != 0);
        SpecificationTest.assertTrue((smith.getWeight(1) >= 0 ? 1 : 0) != 0);
        SpecificationTest.assertTrue((smith.getWeight(2) >= 0 ? 1 : 0) != 0);
        SpecificationTest.assertTrue((smith.getWeight(0) <= 10 ? 1 : 0) != 0);
        SpecificationTest.assertTrue((smith.getWeight(1) <= 10 ? 1 : 0) != 0);
        SpecificationTest.assertTrue((smith.getWeight(2) <= 10 ? 1 : 0) != 0);
        SpecificationTest.assertEquals((int)0, (int)smith.getWeight(-1));
        SpecificationTest.assertEquals((int)0, (int)smith.getWeight(34));
        SpecificationTest.assertTrue((boolean)smith.hasAbility("model.ability.buildFactory"));
    }

    public void testModifiers() {
        Modifier modifier = CollectionUtils.first(depotType.getModifiers("model.modifier.warehouseStorage"));
        SpecificationTest.assertEquals((Object)((Object)Modifier.ModifierType.ADDITIVE), (Object)((Object)modifier.getType()));
        SpecificationTest.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(modifier.getValue()));
        modifier = CollectionUtils.first(blackSmithType.getModifiers("model.goods.tools"));
        SpecificationTest.assertEquals((Object)((Object)Modifier.ModifierType.MULTIPLICATIVE), (Object)((Object)modifier.getType()));
        SpecificationTest.assertEquals((Object)Float.valueOf(2.0f), (Object)Float.valueOf(modifier.getValue()));
    }

    public void testNations() {
        List<Nation> europeanNations = SpecificationTest.spec().getEuropeanNations();
        SpecificationTest.assertEquals((int)8, (int)europeanNations.size());
        List<Nation> indianNations = SpecificationTest.spec().getIndianNations();
        SpecificationTest.assertEquals((int)8, (int)indianNations.size());
        List<Nation> REFNations = SpecificationTest.spec().getREFNations();
        SpecificationTest.assertEquals((int)europeanNations.size(), (int)REFNations.size());
    }

    public void testNationTypes() {
        Specification spec = SpecificationTest.spec();
        List<IndianNationType> indianNationTypes = spec.getIndianNationTypes();
        SpecificationTest.assertEquals((int)8, (int)indianNationTypes.size());
        List<EuropeanNationType> REFNationTypes = spec.getREFNationTypes();
        SpecificationTest.assertEquals((int)1, (int)REFNationTypes.size());
    }

    public void testRequiredAbilitiesForRoles() {
        Specification spec = SpecificationTest.spec();
        HashMap roleAbilities = new HashMap();
        HashMap<String, Boolean> expectAbilities = new HashMap<String, Boolean>();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", false);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.scout", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", false);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.soldier", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", false);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.dragoon", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", false);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.pioneer", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.dressMissionary", true);
        expectAbilities.put("model.ability.native", false);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.missionary", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", false);
        expectAbilities.put("model.ability.refUnit", true);
        expectAbilities.put("model.ability.royalExpeditionaryForce", true);
        roleAbilities.put("model.role.infantry", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", false);
        expectAbilities.put("model.ability.refUnit", true);
        expectAbilities.put("model.ability.royalExpeditionaryForce", true);
        roleAbilities.put("model.role.cavalry", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", true);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.mountedBrave", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", true);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.armedBrave", expectAbilities);
        expectAbilities = new HashMap();
        expectAbilities.put("model.ability.canBeEquipped", true);
        expectAbilities.put("model.ability.native", true);
        expectAbilities.put("model.ability.refUnit", false);
        roleAbilities.put("model.role.nativeDragoon", expectAbilities);
        CollectionUtils.forEachMapEntry(roleAbilities, e -> {
            Role role = spec.getRole((String)e.getKey());
            Map<String, Boolean> required = role.getRequiredAbilities();
            Map expect = (Map)e.getValue();
            for (String key : required.keySet()) {
                Boolean req = required.get(key);
                Boolean val = (Boolean)expect.get(key);
                SpecificationTest.assertNotNull((String)(role.getId() + " missing " + key), (Object)val);
                SpecificationTest.assertEquals((String)(role.getId() + " " + key + " value != " + req), (Object)req, (Object)val);
                expect.remove(key);
            }
            SpecificationTest.assertEquals((String)(role.getId() + " excess abilities"), (int)0, (int)expect.size());
        });
        Role role = spec.getRole("model.role.default");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods[0]);
        role = spec.getRole("model.role.scout");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(horsesType, 50));
        role = spec.getRole("model.role.soldier");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(musketsType, 50));
        role = spec.getRole("model.role.dragoon");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(horsesType, 50), new AbstractGoods(musketsType, 50));
        role = spec.getRole("model.role.pioneer");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(toolsType, 20));
        role = spec.getRole("model.role.missionary");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods[0]);
        role = spec.getRole("model.role.infantry");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(musketsType, 50));
        role = spec.getRole("model.role.cavalry");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(horsesType, 50), new AbstractGoods(musketsType, 50));
        role = spec.getRole("model.role.mountedBrave");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(horsesType, 25));
        role = spec.getRole("model.role.armedBrave");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(musketsType, 25));
        role = spec.getRole("model.role.nativeDragoon");
        SpecificationTest.assertNotNull((Object)role);
        this.checkGoods(role.getId(), role.getRequiredGoodsList(), new AbstractGoods(horsesType, 25), new AbstractGoods(musketsType, 25));
    }

    public void testGoodsTypes() {
        SpecificationTest.assertTrue((boolean)foodType.isFarmed());
        SpecificationTest.assertTrue((boolean)SpecificationTest.spec().getFarmedGoodsTypeList().contains(foodType));
        SpecificationTest.assertTrue((boolean)foodType.isFoodType());
        SpecificationTest.assertTrue((boolean)SpecificationTest.spec().getFoodGoodsTypeList().contains(foodType));
        SpecificationTest.assertTrue((boolean)fishType.isFarmed());
        SpecificationTest.assertTrue((boolean)SpecificationTest.spec().getFarmedGoodsTypeList().contains(fishType));
        SpecificationTest.assertTrue((boolean)fishType.isFoodType());
        SpecificationTest.assertTrue((boolean)SpecificationTest.spec().getFoodGoodsTypeList().contains(fishType));
    }

    public void testExtends() {
        String specification = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><freecol-specification id=\"test\" extends=\"freecol\"><unit-types><unit-type id=\"model.unit.milkmaid\" extends=\"colonist\" expert-production=\"model.goods.food\" /></unit-types></freecol-specification>";
        Specification spec = null;
        try {
            spec = new Specification(new ByteArrayInputStream(specification.getBytes()));
        }
        catch (XMLStreamException xse) {
            SpecificationTest.fail((String)"Spec read fail");
        }
        SpecificationTest.assertNotNull((Object)spec.getUnitType("model.unit.milkmaid"));
        SpecificationTest.assertNotNull((Object)spec.getUnitType("model.unit.caravel"));
        try {
            spec = FreeColRules.getFreeColRulesFile("freecol").getSpecification();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void testExtendsDelete() {
        String specification = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><freecol-specification id=\"test\" extends=\"freecol\"><unit-types><delete id=\"model.unit.caravel\" /></unit-types></freecol-specification>";
        Specification spec = null;
        try {
            spec = new Specification(new ByteArrayInputStream(specification.getBytes()));
        }
        catch (XMLStreamException xse) {
            SpecificationTest.fail((String)"Spec read fail");
        }
        SpecificationTest.assertNull((String)"Caravel should be undefined", (Object)spec.getUnitType("model.unit.caravel"));
        for (UnitType unitType : spec.getUnitTypeList()) {
            SpecificationTest.assertFalse((boolean)"model.unit.caravel".equals(unitType.getId()));
        }
    }

    public void testGetDefaultUnitType() {
        NationType europeanNationType = null;
        NationType nativeNationType = null;
        NationType refNationType = null;
        for (NationType nt : SpecificationTest.spec().getNationTypes()) {
            if (nt.isIndian()) {
                if (nativeNationType != null) continue;
                nativeNationType = nt;
                continue;
            }
            if (nt.isREF()) {
                if (refNationType != null) continue;
                refNationType = nt;
                continue;
            }
            if (europeanNationType != null) continue;
            europeanNationType = nt;
        }
        SpecificationTest.assertNotNull((String)"No European nation type", europeanNationType);
        SpecificationTest.assertNotNull((String)"No native nation type", nativeNationType);
        SpecificationTest.assertNotNull((String)"No REF nation type", refNationType);
        SpecificationTest.assertEquals((String)"Should find free colonist", (Object)freeColonistType, (Object)SpecificationTest.spec().getDefaultUnitType(europeanNationType));
        SpecificationTest.assertEquals((String)"Should find brave", (Object)braveType, (Object)SpecificationTest.spec().getDefaultUnitType(nativeNationType));
        SpecificationTest.assertEquals((String)"Should find kings regular", (Object)kingsRegularType, (Object)SpecificationTest.spec().getDefaultUnitType(refNationType));
    }

    public void testLoadMods() {
        try {
            Specification spec = FreeColRules.getFreeColRulesFile("freecol").getSpecification();
            int numberOfUnitTypes = spec.getUnitTypeList().size();
            ArrayList<FreeColModFile> mods = new ArrayList<FreeColModFile>();
            mods.add(new FreeColModFile(new File("data/mods/example")));
            spec.loadMods(mods);
            UnitType milkmaid = spec.getUnitType("model.unit.milkmaid");
            SpecificationTest.assertEquals((int)(numberOfUnitTypes + 1), (int)spec.getUnitTypeList().size());
        }
        catch (IOException | XMLStreamException ex) {
            SpecificationTest.fail((String)ex.toString());
        }
    }
}

