/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class PathfindingTest
extends FreeColTestCase {
    private final TileType plainsType = PathfindingTest.spec().getTileType("model.tile.plains");
    private final UnitType colonistType = PathfindingTest.spec().getUnitType("model.unit.freeColonist");

    public void testComposedGoalDeciders() {
        Game game = PathfindingTest.getStandardGame();
        Map map = PathfindingTest.getCoastTestMap(this.plainsType, true);
        game.changeMap(map);
        final Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile colonyTile = map.getTile(9, 2);
        Colony colony = FreeColTestUtils.getColonyBuilder().player(dutch).colonyTile(colonyTile).build();
        PathfindingTest.assertTrue((boolean)colonyTile.isShore());
        Tile unitTile = map.getTile(9, 3);
        ServerUnit unit = new ServerUnit(game, unitTile, dutch, this.colonistType);
        Tile nativeTile = map.getTile(9, 4);
        IndianSettlement is = new FreeColTestCase.IndianSettlementBuilder(game).settlementTile(nativeTile).build();
        PathfindingTest.assertTrue((boolean)nativeTile.isShore());
        GoalDecider settlementGD = new GoalDecider(){
            private PathNode goal = null;

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile tile = path.getTile();
                if (tile.hasSettlement()) {
                    this.goal = path;
                    return true;
                }
                return false;
            }
        };
        GoalDecider colonyGD = new GoalDecider(){
            private PathNode goal = null;

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile tile = path.getTile();
                if (tile.getColony() != null) {
                    this.goal = path;
                    return true;
                }
                return false;
            }
        };
        GoalDecider nativeGD = new GoalDecider(){
            private PathNode goal = null;

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile tile = path.getTile();
                if (tile.getIndianSettlement() != null) {
                    this.goal = path;
                    return true;
                }
                return false;
            }
        };
        GoalDecider ownedGD = new GoalDecider(){
            private PathNode goal = null;

            @Override
            public PathNode getGoal() {
                return this.goal;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                Tile tile = path.getTile();
                if (tile.getOwner() == dutch) {
                    this.goal = path;
                    return true;
                }
                return false;
            }
        };
        GoalDecider gd = GoalDeciders.getComposedGoalDecider(true, ownedGD, settlementGD);
        PathNode path = unit.search(unitTile, gd, null, 1, null);
        PathfindingTest.assertNotNull((Object)path);
        PathfindingTest.assertEquals((String)"Composed-AND GoalDecider should find colony", (Object)colonyTile, (Object)path.getLastNode().getTile());
        gd = GoalDeciders.getComposedGoalDecider(true, settlementGD, ownedGD);
        path = unit.search(unitTile, gd, null, 1, null);
        PathfindingTest.assertNotNull((Object)path);
        PathfindingTest.assertEquals((String)"Composed-AND GoalDecider should still find colony", (Object)colonyTile, (Object)path.getLastNode().getTile());
        gd = GoalDeciders.getComposedGoalDecider(false, nativeGD, colonyGD);
        path = unit.search(unitTile, gd, null, 1, null);
        PathfindingTest.assertNotNull((Object)path);
        PathfindingTest.assertEquals((String)"Composed-OR GoalDecider should find natives", (Object)nativeTile, (Object)path.getLastNode().getTile());
        gd = GoalDeciders.getComposedGoalDecider(false, nativeGD, colonyGD);
        path = unit.search(unitTile, gd, null, 1, null);
        PathfindingTest.assertNotNull((Object)path);
        PathfindingTest.assertEquals((String)"Composed-OR GoalDecider should find colony", (Object)colonyTile, (Object)path.getLastNode().getTile());
    }
}

