/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.mapviewer.MapViewer;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class UnitAnimator {
    private final Map<Unit, Integer> unitsOutForAnimation = new HashMap<Unit, Integer>();
    private final Map<Unit, JLabel> unitsOutForAnimationLabels = new HashMap<Unit, JLabel>();
    private final FreeColClient freeColClient;
    private final MapViewer mapViewer;
    private final ImageLibrary lib;

    UnitAnimator(FreeColClient freeColClient, MapViewer mapViewer, ImageLibrary lib) {
        this.freeColClient = freeColClient;
        this.mapViewer = mapViewer;
        this.lib = lib;
    }

    public JLabel enterUnitOutForAnimation(Unit unit) {
        Integer i = this.unitsOutForAnimation.get(unit);
        if (i == null) {
            JLabel unitLabel = this.createUnitAnimationLabel(unit);
            this.unitsOutForAnimationLabels.put(unit, unitLabel);
            i = 1;
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.unitsOutForAnimation.put(unit, i);
        return this.unitsOutForAnimationLabels.get(unit);
    }

    public void releaseUnitOutForAnimation(Unit unit) {
        Integer i = this.unitsOutForAnimation.get(unit);
        if (i == null) {
            throw new RuntimeException("Unit not out for animation: " + unit);
        }
        if (i == 1) {
            this.unitsOutForAnimation.remove(unit);
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i - 1);
            this.unitsOutForAnimation.put(unit, i);
        }
    }

    boolean isUnitsOutForAnimation() {
        return !this.unitsOutForAnimation.isEmpty();
    }

    public boolean isOutForAnimation(Unit unit) {
        return this.unitsOutForAnimation.containsKey(unit);
    }

    public Point getAnimationPosition(JLabel unitLabel, Tile tile) {
        return this.mapViewer.getTileBounds().calculateUnitLabelPositionInTile(unitLabel, this.mapViewer.getMapViewerBounds().calculateTilePosition(tile, false));
    }

    private JLabel createUnitAnimationLabel(Unit unit) {
        BufferedImage unitImg = this.lib.getScaledUnitImage(unit);
        int scaledUnitOffset = (int)(20.0f * this.lib.getScaleFactor());
        int width = Math.max(unitImg.getWidth(), this.mapViewer.getTileBounds().getWidth());
        int height = Math.max(unitImg.getHeight() + scaledUnitOffset * 2, this.mapViewer.getTileBounds().getHeight());
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.translate((width - this.mapViewer.getTileBounds().getWidth()) / 2, (height - this.mapViewer.getTileBounds().getHeight()) / 2);
        this.mapViewer.displayUnit(g2d, unit);
        JLabel label = new JLabel(new ImageIcon(img));
        label.setSize(width, height);
        g2d.dispose();
        return label;
    }
}

