/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.PrefixCollector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeNamespaceContext
implements NamespacePrefixList {
    private static final String NODE_NAMSPACE_CONTEXT = NamespacePrefixList.class.getName();
    private static final Collection XML_NS_PREFIX_COLLECTION = Collections.singletonList("xml");
    private static final Collection XMLNS_ATTRIBUTE_COLLECTION = Collections.singletonList("xmlns");
    static Method getUserData;
    static Method setUserData;
    private final Map declarations;
    private String[] prefixes;

    private NodeNamespaceContext(Map decls) {
        this.declarations = decls;
    }

    public static NodeNamespaceContext getNamespaceContext(Node pNode) {
        if (getUserData != null) {
            try {
                NodeNamespaceContext ctx = (NodeNamespaceContext)getUserData.invoke((Object)pNode, NODE_NAMSPACE_CONTEXT);
                if (ctx == null) {
                    NamedNodeMap map;
                    HashMap<String, String> declarations = new HashMap<String, String>();
                    Node parentNode = pNode.getParentNode();
                    if (parentNode != null) {
                        NodeNamespaceContext parent = (NodeNamespaceContext)getUserData.invoke((Object)parentNode, NODE_NAMSPACE_CONTEXT);
                        if (parent == null) {
                            parent = NodeNamespaceContext.getNamespaceContext(parentNode);
                        }
                        declarations.putAll(parent.declarations);
                    }
                    if ((map = pNode.getAttributes()) != null) {
                        for (int i = 0; i < map.getLength(); ++i) {
                            Node attr = map.item(i);
                            String uri = attr.getNamespaceURI();
                            if (!"http://www.w3.org/2000/xmlns/".equals(uri)) continue;
                            String localName = attr.getLocalName();
                            String prefix = "xmlns".equals(localName) ? "" : localName;
                            declarations.put(prefix, attr.getNodeValue());
                        }
                    }
                    ctx = new NodeNamespaceContext(declarations);
                    setUserData.invoke((Object)pNode, NODE_NAMSPACE_CONTEXT, ctx, null);
                }
                return ctx;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        final HashMap declarations = new HashMap();
        new PrefixCollector(){

            protected void declare(String pPrefix, String pNamespaceURI) {
                declarations.put(pPrefix, pNamespaceURI);
            }
        }.searchAllPrefixDeclarations(pNode);
        return new NodeNamespaceContext(declarations);
    }

    public String getNamespaceURI(String pPrefix) {
        if (pPrefix == null) {
            throw new IllegalArgumentException("The prefix must not be null.");
        }
        if ("xml".equals(pPrefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(pPrefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String uri = (String)this.declarations.get(pPrefix);
        return uri == null ? "" : uri;
    }

    public String getPrefix(String pNamespaceURI) {
        if (pNamespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI must not be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pNamespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pNamespaceURI)) {
            return "xmlns";
        }
        Iterator iter = this.declarations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!pNamespaceURI.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String pNamespaceURI) {
        if (pNamespaceURI == null) {
            throw new IllegalArgumentException("The namespace URI must not be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pNamespaceURI)) {
            return XML_NS_PREFIX_COLLECTION.iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pNamespaceURI)) {
            return XMLNS_ATTRIBUTE_COLLECTION.iterator();
        }
        ArrayList list = new ArrayList();
        Iterator iter = this.declarations.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!pNamespaceURI.equals(entry.getValue())) continue;
            list.add(entry.getKey());
        }
        return list.iterator();
    }

    public String[] getDeclaredPrefixes() {
        if (this.prefixes == null) {
            Set keys = this.declarations.keySet();
            this.prefixes = keys.toArray(new String[keys.size()]);
        }
        return this.prefixes;
    }

    static {
        try {
            Class<?> cls = Class.forName("org.w3c.dom.UserDataHandler", false, Node.class.getClassLoader());
            getUserData = Node.class.getMethod("getUserData", String.class);
            setUserData = Node.class.getMethod("setUserData", String.class, Object.class, cls);
        }
        catch (Throwable e) {
            getUserData = null;
            setUserData = null;
        }
    }
}

